/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.disk.indexed;

import java.text.DecimalFormat;
import java.util.Random;
import junit.framework.TestCase;
import org.apache.commons.jcs3.JCS;
import org.apache.commons.jcs3.access.CacheAccess;
import org.apache.commons.jcs3.auxiliary.disk.DiskTestObject;
import org.apache.commons.jcs3.utils.timing.ElapsedTimer;

public class IndexedDiskCacheSteadyLoadTest
extends TestCase {
    private static final String LOG_DIVIDER = "---------------------------";
    private static final Runtime rt = Runtime.getRuntime();
    private static final DecimalFormat format = new DecimalFormat("#,###");

    public void testRunSteadyLoadTest() throws Exception {
        JCS.setConfigFilename((String)"/TestDiskCacheSteadyLoad.ccf");
        System.out.println("runSteadyLoadTest");
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        int numPerRun = 200;
        long pauseBetweenRuns = 1000L;
        int runCount = 0;
        int runs = 1000;
        int upperKB = 50;
        CacheAccess jcs = JCS.getInstance((String)"100aSecond");
        ElapsedTimer timer = new ElapsedTimer();
        int numToGet = 20000;
        for (int i = 0; i < 20000; ++i) {
            jcs.get((Object)String.valueOf(i));
        }
        System.out.println(LOG_DIVIDER);
        System.out.println("After getting 20000");
        System.out.println("Elapsed " + timer.getElapsedTimeString());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        jcs.clear();
        Thread.sleep(3000L);
        System.out.println(LOG_DIVIDER);
        System.out.println("Start putting");
        long totalSize = 0L;
        int totalPut = 0;
        Random random = new Random(89L);
        while (runCount < 1000) {
            ++runCount;
            for (int i = 0; i < 200; ++i) {
                int kiloBytes = Math.max(25, random.nextInt(50));
                int bytes = kiloBytes * 1024;
                totalSize += (long)bytes;
                DiskTestObject object = new DiskTestObject(i, new byte[bytes]);
                jcs.put((Object)String.valueOf(++totalPut), (Object)object);
            }
            if (runCount > 1) {
                for (int j = totalPut - 200 - 100; j < totalPut - 200; ++j) {
                    jcs.remove((Object)String.valueOf(j));
                }
            }
            Thread.sleep(1000L);
            if (runCount % 100 != 0) continue;
            System.out.println(LOG_DIVIDER);
            System.out.println("Elapsed " + timer.getElapsedTimeString());
            System.out.println("Run count: " + runCount + " Average size: " + totalSize / (long)totalPut + "\n" + jcs.getStats());
            IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        }
        Thread.sleep(3000L);
        System.out.println(jcs.getStats());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        Thread.sleep(10000L);
        System.out.println(jcs.getStats());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
        System.gc();
        Thread.sleep(3000L);
        System.gc();
        System.out.println(jcs.getStats());
        IndexedDiskCacheSteadyLoadTest.logMemoryUsage();
    }

    private static void logMemoryUsage() {
        long byte2MB = 0x100000L;
        long total = rt.totalMemory() / 0x100000L;
        long free = rt.freeMemory() / 0x100000L;
        long used = total - free;
        System.out.println(LOG_DIVIDER);
        System.out.println("Memory: Used:" + format.format(used) + "MB Free:" + format.format(free) + "MB Total:" + format.format(total) + "MB");
    }
}

