/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jcs3.auxiliary.remote;

import org.apache.commons.jcs3.auxiliary.AbstractAuxiliaryCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.RemoteLocation;
import org.apache.commons.jcs3.auxiliary.remote.behavior.ICommonRemoteCacheAttributes;
import org.apache.commons.jcs3.auxiliary.remote.behavior.IRemoteCacheConstants;
import org.apache.commons.jcs3.auxiliary.remote.server.behavior.RemoteType;

public class CommonRemoteCacheAttributes
extends AbstractAuxiliaryCacheAttributes
implements ICommonRemoteCacheAttributes {
    private static final long serialVersionUID = -1555143736942374000L;
    private String remoteServiceName = IRemoteCacheConstants.REMOTE_CACHE_SERVICE_VAL;
    private RemoteLocation location;
    private String clusterServers = "";
    private RemoteType remoteType = RemoteType.LOCAL;
    private boolean removeUponRemotePut = true;
    private boolean getOnly;
    private boolean localClusterConsistency;
    private int rmiSocketFactoryTimeoutMillis = 10000;

    @Override
    public String getRemoteTypeName() {
        return this.remoteType != null ? this.remoteType.toString() : RemoteType.LOCAL.toString();
    }

    @Override
    public void setRemoteTypeName(String s) {
        this.remoteType = RemoteType.valueOf(s);
    }

    @Override
    public RemoteType getRemoteType() {
        return this.remoteType;
    }

    @Override
    public void setRemoteType(RemoteType p) {
        this.remoteType = p;
    }

    @Override
    public String getRemoteServiceName() {
        return this.remoteServiceName;
    }

    @Override
    public void setRemoteServiceName(String s) {
        this.remoteServiceName = s;
    }

    @Override
    public void setRemoteLocation(RemoteLocation location) {
        this.location = location;
    }

    @Override
    public void setRemoteLocation(String host, int port) {
        this.location = new RemoteLocation(host, port);
    }

    @Override
    public RemoteLocation getRemoteLocation() {
        return this.location;
    }

    @Override
    public String getClusterServers() {
        return this.clusterServers;
    }

    @Override
    public void setClusterServers(String s) {
        this.clusterServers = s;
    }

    @Override
    public boolean getRemoveUponRemotePut() {
        return this.removeUponRemotePut;
    }

    @Override
    public void setRemoveUponRemotePut(boolean r) {
        this.removeUponRemotePut = r;
    }

    @Override
    public boolean getGetOnly() {
        return this.getOnly;
    }

    @Override
    public void setGetOnly(boolean r) {
        this.getOnly = r;
    }

    @Override
    public boolean isLocalClusterConsistency() {
        return this.localClusterConsistency;
    }

    @Override
    public void setLocalClusterConsistency(boolean r) {
        this.localClusterConsistency = r;
    }

    @Override
    public void setRmiSocketFactoryTimeoutMillis(int rmiSocketFactoryTimeoutMillis) {
        this.rmiSocketFactoryTimeoutMillis = rmiSocketFactoryTimeoutMillis;
    }

    @Override
    public int getRmiSocketFactoryTimeoutMillis() {
        return this.rmiSocketFactoryTimeoutMillis;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n RemoteCacheAttributes ");
        if (this.location != null) {
            buf.append("\n remoteHost = [" + this.location.getHost() + "]");
            buf.append("\n remotePort = [" + this.location.getPort() + "]");
        }
        buf.append("\n cacheName = [" + this.getCacheName() + "]");
        buf.append("\n remoteType = [" + (Object)((Object)this.remoteType) + "]");
        buf.append("\n removeUponRemotePut = [" + this.removeUponRemotePut + "]");
        buf.append("\n getOnly = [" + this.getOnly + "]");
        return buf.toString();
    }
}

