/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2.internal.introspection;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.apache.commons.jexl2.internal.introspection.ClassMap;
import org.apache.commons.jexl2.internal.introspection.MethodKey;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodKeyTest
extends TestCase {
    private static final Class<?>[] PRIMS = new Class[]{Boolean.TYPE, Byte.TYPE, Character.TYPE, Double.TYPE, Float.TYPE, Integer.TYPE, Long.TYPE, Short.TYPE, String.class, Date.class};
    private static final Object[] ARGS = new Object[]{new Boolean(true), new Byte(1), new Character('2'), new Double(4.0), new Float(8.0f), new Integer(16), new Long(32L), new Short(64), "foobar", new Date()};
    private static final String[] METHODS = new String[]{"plus", "minus", "execute", "activate", "perform", "apply", "invoke", "executeAction", "activateAction", "performAction", "applyAction", "invokeAction", "executeFunctor", "activateFunctor", "performFunctor", "applyFunctor", "invokeFunctor", "executeIt", "activateIt", "performIt", "applyIt", "invokeIt"};
    private static final Map<MethodKey, String> byKey = new HashMap<MethodKey, String>();
    private static final Map<String, MethodKey> byString = new HashMap<String, MethodKey>();
    private static final MethodKey[] keyList;
    private static final int LOOP = 3;

    private static void setUpKey(String name, Class<?>[] parms) {
        MethodKey key = new MethodKey(name, (Class[])parms);
        String str = key.toString();
        byKey.put(key, str);
        byString.put(str, key);
    }

    String makeStringKey(String method, Class<?> ... params) {
        StringBuilder builder = new StringBuilder(method);
        for (int p = 0; p < params.length; ++p) {
            builder.append(ClassMap.MethodCache.primitiveClass(params[p]).getName());
        }
        return builder.toString();
    }

    void checkStringKey(String method, Class<?> ... params) {
        String key = this.makeStringKey(method, params);
        MethodKey out = byString.get(key);
        MethodKeyTest.assertTrue((out != null ? 1 : 0) != 0);
    }

    MethodKey makeKey(String method, Class<?> ... params) {
        return new MethodKey(method, (Class[])params);
    }

    void checkKey(String method, Class<?> ... params) {
        MethodKey key = this.makeKey(method, params);
        String out = byKey.get(key);
        MethodKeyTest.assertTrue((out != null ? 1 : 0) != 0);
    }

    public void testObjectKey() throws Exception {
        for (int k = 0; k < keyList.length; ++k) {
            MethodKey ctl = keyList[k];
            MethodKey key = this.makeKey(ctl.getMethod(), ctl.getParameters());
            String out = byKey.get(key);
            MethodKeyTest.assertTrue((out != null ? 1 : 0) != 0);
            MethodKeyTest.assertTrue((String)(ctl.toString() + " != " + out), (boolean)ctl.toString().equals(out));
        }
    }

    public void testStringKey() throws Exception {
        for (int k = 0; k < keyList.length; ++k) {
            MethodKey ctl = keyList[k];
            String key = this.makeStringKey(ctl.getMethod(), ctl.getParameters());
            MethodKey out = byString.get(key);
            MethodKeyTest.assertTrue((out != null ? 1 : 0) != 0);
            MethodKeyTest.assertTrue((String)(ctl.toString() + " != " + key), (boolean)ctl.equals((Object)out));
        }
    }

    public void testPerfKey() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < keyList.length; ++k) {
                MethodKey ctl = keyList[k];
                MethodKey key = this.makeKey(ctl.getMethod(), ctl.getParameters());
                String out = byKey.get(key);
                MethodKeyTest.assertTrue((out != null ? 1 : 0) != 0);
            }
        }
    }

    public void testPerfString() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (int k = 0; k < keyList.length; ++k) {
                MethodKey ctl = keyList[k];
                String key = this.makeStringKey(ctl.getMethod(), ctl.getParameters());
                MethodKey out = byString.get(key);
                MethodKeyTest.assertTrue((out != null ? 1 : 0) != 0);
            }
        }
    }

    public void testPerfKey2() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (int m = 0; m < METHODS.length; ++m) {
                String method = METHODS[m];
                for (int p0 = 0; p0 < ARGS.length; ++p0) {
                    this.checkKey(method, ARGS[p0].getClass());
                    for (int p1 = 0; p1 < ARGS.length; ++p1) {
                        this.checkKey(method, ARGS[p0].getClass(), ARGS[p1].getClass());
                        for (int p2 = 0; p2 < ARGS.length; ++p2) {
                            this.checkKey(method, ARGS[p0].getClass(), ARGS[p1].getClass(), ARGS[p2].getClass());
                        }
                    }
                }
            }
        }
    }

    public void testPerfStringKey2() throws Exception {
        for (int l = 0; l < 3; ++l) {
            for (int m = 0; m < METHODS.length; ++m) {
                String method = METHODS[m];
                for (int p0 = 0; p0 < ARGS.length; ++p0) {
                    this.checkStringKey(method, ARGS[p0].getClass());
                    for (int p1 = 0; p1 < ARGS.length; ++p1) {
                        this.checkStringKey(method, ARGS[p0].getClass(), ARGS[p1].getClass());
                        for (int p2 = 0; p2 < ARGS.length; ++p2) {
                            this.checkStringKey(method, ARGS[p0].getClass(), ARGS[p1].getClass(), ARGS[p2].getClass());
                        }
                    }
                }
            }
        }
    }

    static {
        for (int m = 0; m < METHODS.length; ++m) {
            String method = METHODS[m];
            for (int p0 = 0; p0 < PRIMS.length; ++p0) {
                Class[] arg0 = new Class[]{PRIMS[p0]};
                MethodKeyTest.setUpKey(method, arg0);
                for (int p1 = 0; p1 < PRIMS.length; ++p1) {
                    Class[] arg1 = new Class[]{PRIMS[p0], PRIMS[p1]};
                    MethodKeyTest.setUpKey(method, arg1);
                    for (int p2 = 0; p2 < PRIMS.length; ++p2) {
                        Class[] arg2 = new Class[]{PRIMS[p0], PRIMS[p1], PRIMS[p2]};
                        MethodKeyTest.setUpKey(method, arg2);
                    }
                }
            }
        }
        keyList = byKey.keySet().toArray(new MethodKey[byKey.size()]);
    }
}

