/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jxpath.ri.model;

import org.apache.commons.jxpath.AbstractFactory;
import org.apache.commons.jxpath.JXPathAbstractFactoryException;
import org.apache.commons.jxpath.JXPathContext;
import org.apache.commons.jxpath.JXPathException;
import org.apache.commons.jxpath.JXPathIntrospector;
import org.apache.commons.jxpath.JXPathInvalidAccessException;
import org.apache.commons.jxpath.Variables;
import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.apache.commons.jxpath.ri.model.beans.NullPointer;
import org.apache.commons.jxpath.util.ValueUtils;

public class VariablePointer
extends NodePointer {
    private static final long serialVersionUID = -454731297397189293L;
    private Variables variables;
    private final QName qName;
    private NodePointer valuePointer;
    private boolean actual;

    public VariablePointer(QName qName) {
        super(null);
        this.qName = qName;
        this.actual = false;
    }

    public VariablePointer(Variables variables, QName qName) {
        super(null);
        this.variables = variables;
        this.qName = qName;
        this.actual = true;
    }

    @Override
    public String asPath() {
        StringBuilder buffer = new StringBuilder();
        buffer.append('$');
        buffer.append(this.qName);
        if (!this.actual) {
            if (this.index != Integer.MIN_VALUE) {
                buffer.append('[').append(this.index + 1).append(']');
            }
        } else if (this.index != Integer.MIN_VALUE && (this.getNode() == null || this.isCollection())) {
            buffer.append('[').append(this.index + 1).append(']');
        }
        return buffer.toString();
    }

    @Override
    public NodeIterator attributeIterator(QName qName) {
        return this.getValuePointer().attributeIterator(qName);
    }

    @Override
    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        return this.getValuePointer().childIterator(test, reverse, startWith);
    }

    @Override
    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return pointer1.getIndex() - pointer2.getIndex();
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index) {
        Object collection = this.createCollection(context, index);
        if (!this.isActual() || index != 0 && index != Integer.MIN_VALUE) {
            AbstractFactory factory = this.getAbstractFactory(context);
            boolean success = factory.createObject(context, this, collection, this.getName().toString(), index);
            if (!success) {
                throw new JXPathAbstractFactoryException("Factory could not create object path: " + this.asPath());
            }
            NodePointer cln = (NodePointer)this.clone();
            cln.setIndex(index);
            return cln;
        }
        return this;
    }

    @Override
    public NodePointer createChild(JXPathContext context, QName qName, int index, Object value) {
        Object collection = this.createCollection(context, index);
        ValueUtils.setValue(collection, index, value);
        NodePointer cl = (NodePointer)this.clone();
        cl.setIndex(index);
        return cl;
    }

    private Object createCollection(JXPathContext context, int index) {
        this.createPath(context);
        Object collection = this.getBaseValue();
        if (collection == null) {
            throw new JXPathAbstractFactoryException("Factory did not assign a collection to variable '" + this.qName + "' for path: " + this.asPath());
        }
        if (index == Integer.MIN_VALUE) {
            index = 0;
        } else if (index < 0) {
            throw new JXPathInvalidAccessException("Index is less than 1: " + this.asPath());
        }
        if (index >= this.getLength()) {
            collection = ValueUtils.expandCollection(collection, index + 1);
            this.variables.declareVariable(this.qName.toString(), collection);
        }
        return collection;
    }

    @Override
    public NodePointer createPath(JXPathContext context) {
        if (!this.actual) {
            AbstractFactory factory = this.getAbstractFactory(context);
            if (!factory.declareVariable(context, this.qName.toString())) {
                throw new JXPathAbstractFactoryException("Factory cannot define variable '" + this.qName + "' for path: " + this.asPath());
            }
            this.findVariables(context);
        }
        return this;
    }

    @Override
    public NodePointer createPath(JXPathContext context, Object value) {
        if (this.actual) {
            this.setValue(value);
            return this;
        }
        NodePointer ptr = this.createPath(context);
        ptr.setValue(value);
        return ptr;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VariablePointer)) {
            return false;
        }
        VariablePointer other = (VariablePointer)object;
        return this.variables == other.variables && this.qName.equals(other.qName) && this.index == other.index;
    }

    protected void findVariables(JXPathContext context) {
        this.valuePointer = null;
        for (JXPathContext varCtx = context; varCtx != null; varCtx = varCtx.getParentContext()) {
            this.variables = varCtx.getVariables();
            if (this.variables.isDeclaredVariable(this.qName.toString())) {
                this.actual = true;
                break;
            }
            this.variables = null;
        }
    }

    @Override
    public Object getBaseValue() {
        if (!this.actual) {
            throw new JXPathException("Undefined variable: " + this.qName);
        }
        return this.variables.getVariable(this.qName.toString());
    }

    @Override
    public Object getImmediateNode() {
        Object value = this.getBaseValue();
        return this.index == Integer.MIN_VALUE ? ValueUtils.getValue(value) : ValueUtils.getValue(value, this.index);
    }

    @Override
    public NodePointer getImmediateValuePointer() {
        if (this.valuePointer == null) {
            if (!this.actual) {
                return new NullPointer(this, this.getName()){
                    private static final long serialVersionUID = 1L;

                    @Override
                    public Object getImmediateNode() {
                        throw new JXPathException("Undefined variable: " + VariablePointer.this.qName);
                    }
                };
            }
            Object value = this.getImmediateNode();
            this.valuePointer = VariablePointer.newChildNodePointer(this, null, value);
        }
        return this.valuePointer;
    }

    @Override
    public int getLength() {
        if (this.actual) {
            Object value = this.getBaseValue();
            return value == null ? 1 : ValueUtils.getLength(value);
        }
        return 0;
    }

    @Override
    public QName getName() {
        return this.qName;
    }

    public int hashCode() {
        return (this.actual ? System.identityHashCode(this.variables) : 0) + this.qName.hashCode() + this.index;
    }

    @Override
    public boolean isActual() {
        return this.actual;
    }

    @Override
    public boolean isCollection() {
        Object value = this.getBaseValue();
        return value != null && ValueUtils.isCollection(value);
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isLeaf() {
        Object value = this.getNode();
        return value == null || JXPathIntrospector.getBeanInfo(value.getClass()).isAtomic();
    }

    @Override
    public NodeIterator namespaceIterator() {
        return this.getValuePointer().namespaceIterator();
    }

    @Override
    public NodePointer namespacePointer(String name) {
        return this.getValuePointer().namespacePointer(name);
    }

    @Override
    public void remove() {
        if (this.actual) {
            if (this.index == Integer.MIN_VALUE) {
                this.variables.undeclareVariable(this.qName.toString());
            } else {
                if (this.index < 0) {
                    throw new JXPathInvalidAccessException("Index is less than 1: " + this.asPath());
                }
                Object collection = this.getBaseValue();
                if (collection != null && this.index < this.getLength()) {
                    collection = ValueUtils.remove(collection, this.index);
                    this.variables.declareVariable(this.qName.toString(), collection);
                }
            }
        }
    }

    @Override
    public void setIndex(int index) {
        super.setIndex(index);
        this.valuePointer = null;
    }

    @Override
    public void setValue(Object value) {
        if (!this.actual) {
            throw new JXPathException("Cannot set undefined variable: " + this.qName);
        }
        this.valuePointer = null;
        if (this.index != Integer.MIN_VALUE) {
            Object collection = this.getBaseValue();
            ValueUtils.setValue(collection, this.index, value);
        } else {
            this.variables.declareVariable(this.qName.toString(), value);
        }
    }

    @Override
    public boolean testNode(NodeTest nodeTest) {
        return this.getValuePointer().testNode(nodeTest);
    }
}

