/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.logging;

import junit.framework.Test;
import junit.framework.TestCase;
import org.apache.commons.logging.AltHashtable;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.logging.PathableClassLoader;
import org.apache.commons.logging.PathableTestSuite;

public class AltHashtableTestCase
extends TestCase {
    public static Test suite() throws Exception {
        Class<AltHashtableTestCase> thisClass = AltHashtableTestCase.class;
        ClassLoader thisClassLoader = thisClass.getClassLoader();
        PathableClassLoader loader = new PathableClassLoader(null);
        loader.useExplicitLoader("junit.", thisClassLoader);
        loader.addLogicalLib("testclasses");
        loader.addLogicalLib("commons-logging");
        Class<?> testClass = loader.loadClass(thisClass.getName());
        return new PathableTestSuite(testClass, loader);
    }

    public void setUp() {
        System.setProperty("org.apache.commons.logging.LogFactory.HashtableImpl", AltHashtable.class.getName());
    }

    public void testPutCalled() throws Exception {
        AltHashtable.lastKey = null;
        AltHashtable.lastValue = null;
        LogFactory.getLog(AltHashtableTestCase.class);
        ClassLoader contextLoader = Thread.currentThread().getContextClassLoader();
        AltHashtableTestCase.assertEquals((Object)contextLoader, (Object)AltHashtable.lastKey);
        AltHashtableTestCase.assertNotNull((Object)AltHashtable.lastValue);
    }

    public void testType() {
        AltHashtableTestCase.assertTrue((boolean)(LogFactory.factories instanceof AltHashtable));
    }
}

