/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math3.analysis.interpolation;

import java.util.Random;
import org.apache.commons.math3.FieldElement;
import org.apache.commons.math3.analysis.interpolation.FieldHermiteInterpolator;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.dfp.Dfp;
import org.apache.commons.math3.dfp.DfpField;
import org.apache.commons.math3.exception.NoDataException;
import org.apache.commons.math3.fraction.BigFraction;
import org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class FieldHermiteInterpolatorTest {
    @Test
    public void testZero() {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        interpolator.addSamplePoint((FieldElement)new BigFraction(0), (FieldElement[][])new BigFraction[][]{{new BigFraction(0)}});
        for (int x = -10; x < 10; ++x) {
            BigFraction y = ((BigFraction[])interpolator.value((FieldElement)new BigFraction(x)))[0];
            Assert.assertEquals((Object)BigFraction.ZERO, (Object)y);
            BigFraction[][] derivatives = (BigFraction[][])interpolator.derivatives((FieldElement)new BigFraction(x), 1);
            Assert.assertEquals((Object)BigFraction.ZERO, (Object)derivatives[0][0]);
            Assert.assertEquals((Object)BigFraction.ZERO, (Object)derivatives[1][0]);
        }
    }

    @Test
    public void testQuadratic() {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        interpolator.addSamplePoint((FieldElement)new BigFraction(0), (FieldElement[][])new BigFraction[][]{{new BigFraction(2)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(1), (FieldElement[][])new BigFraction[][]{{new BigFraction(0)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(2), (FieldElement[][])new BigFraction[][]{{new BigFraction(0)}});
        for (double x = -10.0; x < 10.0; x += 1.0) {
            BigFraction y = ((BigFraction[])interpolator.value((FieldElement)new BigFraction(x)))[0];
            Assert.assertEquals((double)((x - 1.0) * (x - 2.0)), (double)y.doubleValue(), (double)1.0E-15);
            BigFraction[][] derivatives = (BigFraction[][])interpolator.derivatives((FieldElement)new BigFraction(x), 3);
            Assert.assertEquals((double)((x - 1.0) * (x - 2.0)), (double)derivatives[0][0].doubleValue(), (double)1.0E-15);
            Assert.assertEquals((double)(2.0 * x - 3.0), (double)derivatives[1][0].doubleValue(), (double)1.0E-15);
            Assert.assertEquals((double)2.0, (double)derivatives[2][0].doubleValue(), (double)1.0E-15);
            Assert.assertEquals((double)0.0, (double)derivatives[3][0].doubleValue(), (double)1.0E-15);
        }
    }

    @Test
    public void testMixedDerivatives() {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        interpolator.addSamplePoint((FieldElement)new BigFraction(0), (FieldElement[][])new BigFraction[][]{{new BigFraction(1)}, {new BigFraction(2)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(1), (FieldElement[][])new BigFraction[][]{{new BigFraction(4)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(2), (FieldElement[][])new BigFraction[][]{{new BigFraction(5)}, {new BigFraction(2)}});
        BigFraction[][] derivatives = (BigFraction[][])interpolator.derivatives((FieldElement)new BigFraction(0), 5);
        Assert.assertEquals((Object)new BigFraction(1), (Object)derivatives[0][0]);
        Assert.assertEquals((Object)new BigFraction(2), (Object)derivatives[1][0]);
        Assert.assertEquals((Object)new BigFraction(8), (Object)derivatives[2][0]);
        Assert.assertEquals((Object)new BigFraction(-24), (Object)derivatives[3][0]);
        Assert.assertEquals((Object)new BigFraction(24), (Object)derivatives[4][0]);
        Assert.assertEquals((Object)new BigFraction(0), (Object)derivatives[5][0]);
        derivatives = (BigFraction[][])interpolator.derivatives((FieldElement)new BigFraction(1), 5);
        Assert.assertEquals((Object)new BigFraction(4), (Object)derivatives[0][0]);
        Assert.assertEquals((Object)new BigFraction(2), (Object)derivatives[1][0]);
        Assert.assertEquals((Object)new BigFraction(-4), (Object)derivatives[2][0]);
        Assert.assertEquals((Object)new BigFraction(0), (Object)derivatives[3][0]);
        Assert.assertEquals((Object)new BigFraction(24), (Object)derivatives[4][0]);
        Assert.assertEquals((Object)new BigFraction(0), (Object)derivatives[5][0]);
        derivatives = (BigFraction[][])interpolator.derivatives((FieldElement)new BigFraction(2), 5);
        Assert.assertEquals((Object)new BigFraction(5), (Object)derivatives[0][0]);
        Assert.assertEquals((Object)new BigFraction(2), (Object)derivatives[1][0]);
        Assert.assertEquals((Object)new BigFraction(8), (Object)derivatives[2][0]);
        Assert.assertEquals((Object)new BigFraction(24), (Object)derivatives[3][0]);
        Assert.assertEquals((Object)new BigFraction(24), (Object)derivatives[4][0]);
        Assert.assertEquals((Object)new BigFraction(0), (Object)derivatives[5][0]);
    }

    @Test
    public void testRandomPolynomialsValuesOnly() {
        Random random = new Random(4805877208711276850L);
        for (int i = 0; i < 100; ++i) {
            int k;
            Dfp[] values;
            Dfp x;
            int j;
            int maxDegree = 0;
            PolynomialFunction[] p = new PolynomialFunction[5];
            for (int k2 = 0; k2 < p.length; ++k2) {
                int degree = random.nextInt(7);
                p[k2] = this.randomPolynomial(degree, random);
                maxDegree = FastMath.max((int)maxDegree, (int)degree);
            }
            DfpField field = new DfpField(30);
            Dfp step = field.getOne().divide(field.newDfp(10));
            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
            for (j = 0; j < 1 + maxDegree; ++j) {
                x = field.newDfp(j).multiply(step);
                values = new Dfp[p.length];
                for (k = 0; k < p.length; ++k) {
                    values[k] = field.newDfp(p[k].value(x.getReal()));
                }
                interpolator.addSamplePoint((FieldElement)x, (FieldElement[][])new Dfp[][]{values});
            }
            for (j = 0; j < 20; ++j) {
                x = field.newDfp(j).multiply(step);
                values = (Dfp[])interpolator.value((FieldElement)x);
                Assert.assertEquals((long)p.length, (long)values.length);
                for (k = 0; k < p.length; ++k) {
                    Assert.assertEquals((double)p[k].value(x.getReal()), (double)values[k].getReal(), (double)(1.0E-8 * FastMath.abs((double)p[k].value(x.getReal()))));
                }
            }
        }
    }

    @Test
    public void testRandomPolynomialsFirstDerivative() {
        Random random = new Random(6271266645131025723L);
        for (int i = 0; i < 100; ++i) {
            int maxDegree = 0;
            PolynomialFunction[] p = new PolynomialFunction[5];
            PolynomialFunction[] pPrime = new PolynomialFunction[5];
            for (int k = 0; k < p.length; ++k) {
                int degree = random.nextInt(7);
                p[k] = this.randomPolynomial(degree, random);
                pPrime[k] = p[k].polynomialDerivative();
                maxDegree = FastMath.max((int)maxDegree, (int)degree);
            }
            DfpField field = new DfpField(30);
            Dfp step = field.getOne().divide(field.newDfp(10));
            FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
            for (int j = 0; j < 1 + maxDegree / 2; ++j) {
                Dfp x = field.newDfp(j).multiply(step);
                Dfp[] values = new Dfp[p.length];
                Dfp[] derivatives = new Dfp[p.length];
                for (int k = 0; k < p.length; ++k) {
                    values[k] = field.newDfp(p[k].value(x.getReal()));
                    derivatives[k] = field.newDfp(pPrime[k].value(x.getReal()));
                }
                interpolator.addSamplePoint((FieldElement)x, (FieldElement[][])new Dfp[][]{values, derivatives});
            }
            Dfp h = step.divide(field.newDfp(100000));
            for (int j = 0; j < 20; ++j) {
                Dfp x = field.newDfp(j).multiply(step);
                Dfp[] y = (Dfp[])interpolator.value((FieldElement)x);
                Dfp[] yP = (Dfp[])interpolator.value((FieldElement)x.add(h));
                Dfp[] yM = (Dfp[])interpolator.value((FieldElement)x.subtract(h));
                Assert.assertEquals((long)p.length, (long)y.length);
                for (int k = 0; k < p.length; ++k) {
                    Assert.assertEquals((double)p[k].value(x.getReal()), (double)y[k].getReal(), (double)(1.0E-8 * FastMath.abs((double)p[k].value(x.getReal()))));
                    Assert.assertEquals((double)pPrime[k].value(x.getReal()), (double)yP[k].subtract(yM[k]).divide(h.multiply(2)).getReal(), (double)(4.0E-8 * FastMath.abs((double)p[k].value(x.getReal()))));
                }
            }
        }
    }

    @Test
    public void testSine() {
        DfpField field = new DfpField(30);
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        Dfp x = field.getZero();
        while (x.getReal() < Math.PI) {
            interpolator.addSamplePoint((FieldElement)x, (FieldElement[][])new Dfp[][]{{x.sin()}});
            x = x.add(0.5);
        }
        x = field.newDfp(0.1);
        while (x.getReal() < 2.9) {
            Dfp y = ((Dfp[])interpolator.value((FieldElement)x))[0];
            Assert.assertEquals((double)x.sin().getReal(), (double)y.getReal(), (double)3.5E-5);
            x = x.add(0.01);
        }
    }

    @Test
    public void testSquareRoot() {
        DfpField field = new DfpField(30);
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        Dfp x = field.getOne();
        while (x.getReal() < 3.6) {
            interpolator.addSamplePoint((FieldElement)x, (FieldElement[][])new Dfp[][]{{x.sqrt()}});
            x = x.add(0.5);
        }
        x = field.newDfp(1.1);
        while (x.getReal() < 3.5) {
            Dfp y = ((Dfp[])interpolator.value((FieldElement)x))[0];
            Assert.assertEquals((double)x.sqrt().getReal(), (double)y.getReal(), (double)1.5E-4);
            x = x.add(0.01);
        }
    }

    @Test
    public void testWikipedia() {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        interpolator.addSamplePoint((FieldElement)new BigFraction(-1), (FieldElement[][])new BigFraction[][]{{new BigFraction(2)}, {new BigFraction(-8)}, {new BigFraction(56)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(0), (FieldElement[][])new BigFraction[][]{{new BigFraction(1)}, {new BigFraction(0)}, {new BigFraction(0)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(1), (FieldElement[][])new BigFraction[][]{{new BigFraction(2)}, {new BigFraction(8)}, {new BigFraction(56)}});
        BigFraction x = new BigFraction(-1);
        while (x.doubleValue() <= 1.0) {
            BigFraction y = ((BigFraction[])interpolator.value((FieldElement)x))[0];
            BigFraction x2 = x.multiply(x);
            BigFraction x4 = x2.multiply(x2);
            BigFraction x8 = x4.multiply(x4);
            Assert.assertEquals((Object)x8.add(new BigFraction(1)), (Object)y);
            x = x.add(new BigFraction(1, 8));
        }
    }

    @Test
    public void testOnePointParabola() {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        interpolator.addSamplePoint((FieldElement)new BigFraction(0), (FieldElement[][])new BigFraction[][]{{new BigFraction(1)}, {new BigFraction(1)}, {new BigFraction(2)}});
        BigFraction x = new BigFraction(-1);
        while (x.doubleValue() <= 1.0) {
            BigFraction y = ((BigFraction[])interpolator.value((FieldElement)x))[0];
            Assert.assertEquals((Object)BigFraction.ONE.add(x.multiply(BigFraction.ONE.add(x))), (Object)y);
            x = x.add(new BigFraction(1, 8));
        }
    }

    private PolynomialFunction randomPolynomial(int degree, Random random) {
        double[] coeff = new double[1 + degree];
        for (int j = 0; j < degree; ++j) {
            coeff[j] = random.nextDouble();
        }
        return new PolynomialFunction(coeff);
    }

    @Test(expected=NoDataException.class)
    public void testEmptySampleValue() {
        new FieldHermiteInterpolator().value((FieldElement)BigFraction.ZERO);
    }

    @Test(expected=NoDataException.class)
    public void testEmptySampleDerivative() {
        new FieldHermiteInterpolator().derivatives((FieldElement)BigFraction.ZERO, 1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testDuplicatedAbscissa() {
        FieldHermiteInterpolator interpolator = new FieldHermiteInterpolator();
        interpolator.addSamplePoint((FieldElement)new BigFraction(1), (FieldElement[][])new BigFraction[][]{{new BigFraction(0)}});
        interpolator.addSamplePoint((FieldElement)new BigFraction(1), (FieldElement[][])new BigFraction[][]{{new BigFraction(1)}});
    }
}

