/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2.performance;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.apache.commons.pool2.PooledObjectFactory;
import org.apache.commons.pool2.impl.GenericObjectPool;
import org.apache.commons.pool2.performance.SleepingObjectFactory;

class PerformanceTest {
    private int logLevel;
    private int nrIterations = 5;
    private GenericObjectPool<Integer> pool;

    PerformanceTest() {
    }

    public static void main(String[] args) {
        PerformanceTest test = new PerformanceTest();
        test.setLogLevel(0);
        System.out.println("Increase threads");
        test.run(1, 50, 5, 5);
        test.run(1, 100, 5, 5);
        test.run(1, 200, 5, 5);
        test.run(1, 400, 5, 5);
        System.out.println("Increase threads & poolSize");
        test.run(1, 50, 5, 5);
        test.run(1, 100, 10, 10);
        test.run(1, 200, 20, 20);
        test.run(1, 400, 40, 40);
        System.out.println("Increase maxIdle");
        test.run(1, 400, 40, 5);
        test.run(1, 400, 40, 40);
    }

    private void run(int iterations, int nrThreads, int maxTotal, int maxIdle) {
        this.nrIterations = iterations;
        SleepingObjectFactory factory = new SleepingObjectFactory();
        if (this.logLevel >= 4) {
            factory.setDebug(true);
        }
        this.pool = new GenericObjectPool((PooledObjectFactory)factory);
        this.pool.setMaxTotal(maxTotal);
        this.pool.setMaxIdle(maxIdle);
        this.pool.setTestOnBorrow(true);
        ExecutorService threadPool = Executors.newFixedThreadPool(nrThreads);
        ArrayList<PerfTask> tasks = new ArrayList<PerfTask>();
        for (int i = 0; i < nrThreads; ++i) {
            tasks.add(new PerfTask());
            Thread.yield();
        }
        if (this.logLevel >= 1) {
            System.out.println("created");
        }
        Thread.yield();
        List futures = null;
        try {
            futures = threadPool.invokeAll(tasks);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        if (this.logLevel >= 1) {
            System.out.println("started");
        }
        Thread.yield();
        if (this.logLevel >= 1) {
            System.out.println("go");
        }
        Thread.yield();
        if (this.logLevel >= 1) {
            System.out.println("finish");
        }
        TaskStats aggregate = new TaskStats();
        if (futures != null) {
            for (Future future : futures) {
                TaskStats taskStats = null;
                try {
                    taskStats = (TaskStats)future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    e.printStackTrace();
                }
                if (taskStats == null) continue;
                aggregate.complete += taskStats.complete;
                aggregate.nrSamples += taskStats.nrSamples;
                aggregate.totalBorrowNanos += taskStats.totalBorrowNanos;
                aggregate.totalReturnNanos += taskStats.totalReturnNanos;
                aggregate.waiting += taskStats.waiting;
            }
        }
        Duration totalBorrowDuration = Duration.ofNanos(aggregate.totalBorrowNanos);
        Duration totalReturnDuration = Duration.ofNanos(aggregate.totalReturnNanos);
        System.out.println("-----------------------------------------");
        System.out.println("nrIterations: " + iterations);
        System.out.println("nrThreads: " + nrThreads);
        System.out.println("maxTotal: " + maxTotal);
        System.out.println("maxIdle: " + maxIdle);
        System.out.println("nrSamples: " + aggregate.nrSamples);
        System.out.println("totalBorrowTime: " + totalBorrowDuration);
        System.out.println("totalReturnTime: " + totalReturnDuration);
        System.out.println("avg BorrowTime: " + totalBorrowDuration.dividedBy(aggregate.nrSamples));
        System.out.println("avg ReturnTime: " + totalReturnDuration.dividedBy(aggregate.nrSamples));
        threadPool.shutdown();
    }

    public void setLogLevel(int i) {
        this.logLevel = i;
    }

    final class PerfTask
    implements Callable<TaskStats> {
        final TaskStats taskStats = new TaskStats();
        long borrowTimeNanos;
        long returnTimeNanos;

        PerfTask() {
        }

        @Override
        public TaskStats call() {
            this.runOnce();
            for (int i = 0; i < PerformanceTest.this.nrIterations; ++i) {
                this.runOnce();
                this.taskStats.totalBorrowNanos += this.borrowTimeNanos;
                this.taskStats.totalReturnNanos += this.returnTimeNanos;
                ++this.taskStats.nrSamples;
                if (PerformanceTest.this.logLevel < 2) continue;
                String name = "thread" + Thread.currentThread().getName();
                System.out.println("result " + this.taskStats.nrSamples + '\t' + name + '\t' + "borrow time: " + Duration.ofNanos(this.borrowTimeNanos) + '\t' + "return time: " + Duration.ofNanos(this.returnTimeNanos) + '\t' + "waiting: " + this.taskStats.waiting + '\t' + "complete: " + this.taskStats.complete);
            }
            return this.taskStats;
        }

        public void runOnce() {
            try {
                ++this.taskStats.waiting;
                if (PerformanceTest.this.logLevel >= 5) {
                    String name = "thread" + Thread.currentThread().getName();
                    System.out.println(name + "   waiting: " + this.taskStats.waiting + "   complete: " + this.taskStats.complete);
                }
                long bbeginNanos = System.nanoTime();
                Integer o = (Integer)PerformanceTest.this.pool.borrowObject();
                long bendNanos = System.nanoTime();
                --this.taskStats.waiting;
                if (PerformanceTest.this.logLevel >= 3) {
                    String name = "thread" + Thread.currentThread().getName();
                    System.out.println(name + "    waiting: " + this.taskStats.waiting + "   complete: " + this.taskStats.complete);
                }
                long rbeginNanos = System.nanoTime();
                PerformanceTest.this.pool.returnObject((Object)o);
                long rendNanos = System.nanoTime();
                Thread.yield();
                ++this.taskStats.complete;
                this.borrowTimeNanos = bendNanos - bbeginNanos;
                this.returnTimeNanos = rendNanos - rbeginNanos;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static final class TaskStats {
        int waiting;
        int complete;
        long totalBorrowNanos;
        long totalReturnNanos;
        int nrSamples;

        private TaskStats() {
        }
    }
}

