/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.LongJumpableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.LongProvider;
import org.apache.commons.rng.core.util.NumberFactory;

abstract class AbstractL64
extends LongProvider
implements LongJumpableUniformRandomProvider {
    private static final int SEED_SIZE = 2;
    protected long la;
    protected long ls;

    AbstractL64(long[] seed) {
        this.setState(AbstractL64.extendSeed(seed, 2));
    }

    AbstractL64(long seed0, long seed1) {
        this.la = seed0 | 1L;
        this.ls = seed1;
    }

    AbstractL64(AbstractL64 source) {
        super(source);
        this.la = source.la;
        this.ls = source.ls;
    }

    private void setState(long[] state) {
        this.la = state[0] | 1L;
        this.ls = state[1];
    }

    @Override
    protected byte[] getStateInternal() {
        return this.composeStateInternal(NumberFactory.makeByteArray(new long[]{this.la, this.ls}), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 16);
        this.setState(NumberFactory.makeLongArray(c[0]));
        super.setStateInternal(c[1]);
    }

    public UniformRandomProvider jump() {
        AbstractL64 copy = this.copy();
        this.ls = -3372029247567499371L * this.ls + this.la;
        this.resetCachedState();
        return copy;
    }

    public JumpableUniformRandomProvider longJump() {
        AbstractL64 copy = this.copy();
        this.ls = -8276630626270969855L * this.ls + 1614853376254672896L * this.la;
        this.resetCachedState();
        return copy;
    }

    abstract AbstractL64 copy();
}

