/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.rng.core.source64;

import java.util.stream.Stream;
import org.apache.commons.rng.JumpableUniformRandomProvider;
import org.apache.commons.rng.SplittableUniformRandomProvider;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.rng.core.source64.AbstractL128;
import org.apache.commons.rng.core.source64.LXMSupport;
import org.apache.commons.rng.core.util.NumberFactory;
import org.apache.commons.rng.core.util.RandomStreams;

public class L128X1024Mix
extends AbstractL128
implements SplittableUniformRandomProvider {
    private static final int SEED_SIZE = 20;
    private static final int XBG_STATE_SIZE = 16;
    private static final int LCG_STATE_SIZE = 4;
    private static final long ML = -3024805186288043011L;
    private final long[] x;
    private int index;

    public L128X1024Mix(long[] seed) {
        seed = L128X1024Mix.extendSeed(seed, 20);
        super(seed);
        this.x = new long[16];
        System.arraycopy(seed, 4, this.x, 0, 16);
        this.index = 15;
    }

    protected L128X1024Mix(L128X1024Mix source) {
        super(source);
        this.x = new long[16];
        System.arraycopy(source.x, 0, this.x, 0, 16);
        this.index = source.index;
    }

    @Override
    protected byte[] getStateInternal() {
        long[] s = new long[17];
        System.arraycopy(this.x, 0, s, 0, 16);
        s[16] = this.index;
        return this.composeStateInternal(NumberFactory.makeByteArray(s), super.getStateInternal());
    }

    @Override
    protected void setStateInternal(byte[] s) {
        byte[][] c = this.splitStateInternal(s, 136);
        long[] tmp = NumberFactory.makeLongArray(c[0]);
        System.arraycopy(tmp, 0, this.x, 0, 16);
        this.index = (int)tmp[16];
        super.setStateInternal(c[1]);
    }

    @Override
    public long next() {
        int q = this.index;
        this.index = q + 1 & 0xF;
        long s0 = this.x[this.index];
        long s15 = this.x[q];
        long sh = this.lsh;
        long z = LXMSupport.lea64(sh + s0);
        long sl = this.lsl;
        long al = this.lal;
        long u = -3024805186288043011L * sl;
        this.lsh = -3024805186288043011L * sh + LXMSupport.unsignedMultiplyHigh(-3024805186288043011L, sl) + sl + this.lah + LXMSupport.unsignedAddHigh(u, al);
        this.lsl = u + al;
        this.x[q] = Long.rotateLeft(s0, 25) ^ (s15 ^= s0) ^ s15 << 27;
        this.x[this.index] = Long.rotateLeft(s15, 36);
        return z;
    }

    @Override
    public UniformRandomProvider jump() {
        return super.jump();
    }

    @Override
    public JumpableUniformRandomProvider longJump() {
        return super.longJump();
    }

    @Override
    AbstractL128 copy() {
        return new L128X1024Mix(this);
    }

    public SplittableUniformRandomProvider split(UniformRandomProvider source) {
        return L128X1024Mix.create(source.nextLong(), source);
    }

    public Stream<SplittableUniformRandomProvider> splits(long streamSize, SplittableUniformRandomProvider source) {
        return RandomStreams.generateWithSeed(streamSize, source, L128X1024Mix::create);
    }

    private static SplittableUniformRandomProvider create(long seed, UniformRandomProvider source) {
        int i;
        long[] s = new long[20];
        s[0] = source.nextLong();
        s[1] = seed << 1;
        s[2] = source.nextLong();
        s[3] = source.nextLong();
        long x = 0L;
        for (i = 4; i < s.length; ++i) {
            s[i] = source.nextLong();
            x |= s[i];
        }
        if (x == 0L) {
            x = s[3];
            for (i = 4; i < s.length; ++i) {
                s[i] = LXMSupport.lea64(x);
                x += -7046029254386353131L;
            }
        }
        return new L128X1024Mix(s);
    }
}

