/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs2.provider.zip;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.SystemUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemManager;
import org.apache.commons.vfs2.VFS;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class FileLockTest {
    private FileSystemManager manager;
    private Path newZipFile;
    private String zipFileUri;

    private void assertDelete() throws IOException {
        Files.delete(this.newZipFile);
    }

    private void readAndAssert(InputStream inputStream) throws IOException {
        String string = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
        Assertions.assertNotNull((Object)string);
        Assertions.assertEquals((Object)"This is a test file.", (Object)string);
    }

    private void resolveAndOpenCloseContent() throws FileSystemException {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            zipFileObject.getContent().close();
        }
    }

    private void resolveAndOpenCloseInputStream() throws IOException, FileSystemException {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            zipFileObject.getContent().getInputStream().close();
        }
    }

    private void resolveAndOpenReadCloseInputStream() throws IOException, FileSystemException {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            this.readAndAssert(inputStream);
        }
    }

    @BeforeEach
    public void setup() throws IOException {
        Path zipFile = Paths.get("src/test/resources/test-data/test.zip", new String[0]);
        this.newZipFile = Files.createTempFile(this.getClass().getSimpleName(), ".zip", new FileAttribute[0]);
        this.newZipFile.toFile().deleteOnExit();
        Files.copy(zipFile, this.newZipFile, StandardCopyOption.REPLACE_EXISTING);
        this.zipFileUri = "zip:file:" + this.newZipFile.toAbsolutePath() + "!/read-tests/file1.txt";
        this.manager = VFS.getManager();
    }

    @Test
    public void testCannotDeleteWhileStreaming() throws Exception {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            if (SystemUtils.IS_OS_WINDOWS) {
                Assertions.assertFalse((boolean)this.newZipFile.toFile().delete(), (String)"Could not delete file");
            }
        }
        this.assertDelete();
    }

    @Test
    public void testCannotDeleteWhileStreaming2() throws Exception {
        Assumptions.assumeTrue((boolean)SystemUtils.IS_OS_WINDOWS);
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);
             InputStream inputStream = zipFileObject.getContent().getInputStream();){
            Assertions.assertFalse((boolean)this.newZipFile.toFile().delete(), (String)"Could not delete file");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReadClosedFileObject() throws Exception {
        FileObject zipFileObjectRef;
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            zipFileObjectRef = zipFileObject;
            try (InputStream inputStream = zipFileObject.getContent().getInputStream();){
                this.readAndAssert(inputStream);
            }
        }
        try (InputStream inputStream = zipFileObjectRef.getContent().getInputStream();){
            this.readAndAssert(inputStream);
        }
        finally {
            zipFileObjectRef.close();
        }
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseContent() throws Exception {
        this.resolveAndOpenCloseContent();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseContent3() throws Exception {
        this.resolveAndOpenCloseContent();
        this.resolveAndOpenCloseContent();
        this.resolveAndOpenCloseContent();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseInputStream() throws Exception {
        this.resolveAndOpenCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenCloseInputStream3() throws Exception {
        this.resolveAndOpenCloseInputStream();
        this.resolveAndOpenCloseInputStream();
        this.resolveAndOpenCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenReadCloseInputStream() throws Exception {
        this.resolveAndOpenReadCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveAndOpenReadCloseInputStream3() throws Exception {
        this.resolveAndOpenReadCloseInputStream();
        this.resolveAndOpenReadCloseInputStream();
        this.resolveAndOpenReadCloseInputStream();
        this.assertDelete();
    }

    @Test
    public void testResolveOpenCloseNestedInputStreams() throws Exception {
        try (FileObject zipFileObject = this.manager.resolveFile(this.zipFileUri);){
            try (FileObject zipFileObject2 = this.manager.resolveFile(this.zipFileUri);){
                zipFileObject2.getContent().getInputStream().close();
            }
            zipFileObject.getContent().getInputStream().close();
        }
        this.assertDelete();
    }
}

