/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rat.report.claim;

import org.apache.rat.ReportConfiguration;
import org.apache.rat.api.Document;
import org.apache.rat.api.RatException;
import org.apache.rat.config.results.ClaimValidator;
import org.apache.rat.report.RatReport;
import org.apache.rat.report.claim.ClaimStatistic;
import org.apache.rat.report.xml.XmlElements;
import org.apache.rat.report.xml.writer.IXmlWriter;

public class ClaimValidatorReport
implements RatReport {
    private final XmlElements elements;
    private final ClaimStatistic statistic;
    private final ClaimValidator validator;

    public ClaimValidatorReport(IXmlWriter writer, ClaimStatistic statistic, ReportConfiguration configuration) {
        this.elements = new XmlElements(writer);
        this.statistic = statistic;
        this.validator = configuration.getClaimValidator();
    }

    @Override
    public void endReport() throws RatException {
        this.elements.statistics();
        for (ClaimStatistic.Counter counter : ClaimStatistic.Counter.values()) {
            int count = this.statistic.getCounter(counter);
            this.elements.statistic(counter.displayName(), count, counter.getDescription(), this.validator.isValid(counter, count));
        }
        for (String category : this.statistic.getLicenseFamilyCategories()) {
            this.elements.licenseCategory(category, this.statistic.getLicenseCategoryCount(category));
        }
        for (String category : this.statistic.getLicenseNames()) {
            this.elements.licenseName(category, this.statistic.getLicenseNameCount(category));
        }
        for (Document.Type type : this.statistic.getDocumentTypes()) {
            this.elements.documentType(type.name(), this.statistic.getCounter(type));
        }
        this.elements.closeElement();
    }
}

