/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.clientcred;

import javax.ws.rs.core.MultivaluedMap;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.common.ServerAccessToken;
import org.apache.cxf.rs.security.oauth2.grants.AbstractGrantHandler;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public class ClientCredentialsGrantHandler
extends AbstractGrantHandler {
    public ClientCredentialsGrantHandler() {
        super("client_credentials");
    }

    @Override
    public ServerAccessToken createAccessToken(Client client, MultivaluedMap<String, String> params) throws OAuthServiceException {
        if (!client.isConfidential()) {
            throw new OAuthServiceException(new OAuthError("invalid_client"));
        }
        ServerAccessToken at = this.doCreateAccessToken(client, client.getSubject(), params);
        if (at.getRefreshToken() != null) {
            LOG.warning("Client credentials grant tokens SHOULD not have refresh tokens");
        }
        return at;
    }
}

