/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.service.extensions.xa.recovery;

import java.lang.invoke.MethodHandles;
import java.util.Arrays;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQExceptionType;
import org.apache.activemq.artemis.api.core.ActiveMQNotConnectedException;
import org.apache.activemq.artemis.api.core.DiscoveryGroupConfiguration;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ClientSession;
import org.apache.activemq.artemis.api.core.client.ClientSessionFactory;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.api.core.client.SessionFailureListener;
import org.apache.activemq.artemis.service.extensions.xa.recovery.ActiveMQXARecoveryLogger;
import org.apache.activemq.artemis.service.extensions.xa.recovery.XARecoveryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ActiveMQXAResourceWrapper
implements XAResource,
SessionFailureListener {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final Object lock = new Object();
    private ServerLocator serverLocator;
    private ClientSessionFactory csf;
    private ClientSession delegate;
    private XARecoveryConfig[] xaRecoveryConfigs;

    public ActiveMQXAResourceWrapper(XARecoveryConfig ... xaRecoveryConfigs) {
        this.xaRecoveryConfigs = xaRecoveryConfigs;
        if (logger.isDebugEnabled()) {
            logger.debug("Recovery configured with {}, instance={}", (Object)Arrays.toString(xaRecoveryConfigs), (Object)System.identityHashCode(this));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateRecoveryConfig(XARecoveryConfig ... xaRecoveryConfigs) {
        Object object = lock;
        synchronized (object) {
            this.close();
            this.xaRecoveryConfigs = xaRecoveryConfigs;
        }
    }

    @Override
    public Xid[] recover(int flag) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        if (logger.isDebugEnabled()) {
            logger.debug("looking for recover at {} configuration {}", (Object)xaResource, (Object)Arrays.toString(this.xaRecoveryConfigs));
        }
        try {
            Object[] xids = xaResource.recover(flag);
            if (logger.isDebugEnabled() && xids != null && xids.length > 0) {
                logger.debug("Recovering these following IDs {} at {}", (Object)Arrays.toString(xids), (Object)this);
            }
            return xids;
        }
        catch (XAException e) {
            ActiveMQXARecoveryLogger.LOGGER.xaRecoverError(e);
            throw this.check(e);
        }
    }

    @Override
    public void commit(Xid xid, boolean onePhase) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        logger.debug("Commit {} xid onePhase={}", (Object)xaResource, (Object)onePhase);
        try {
            xaResource.commit(xid, onePhase);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void rollback(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        logger.debug("Rollback {} xid", (Object)xaResource);
        try {
            xaResource.rollback(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void forget(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        logger.debug("Forget {} xid ", (Object)xaResource);
        try {
            xaResource.forget(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean isSameRM(XAResource xaRes) throws XAException {
        if (xaRes instanceof ActiveMQXAResourceWrapper) {
            xaRes = ((ActiveMQXAResourceWrapper)xaRes).getDelegate(false);
        }
        XAResource xaResource = this.getDelegate(false);
        try {
            return xaResource.isSameRM(xaRes);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int prepare(Xid xid) throws XAException {
        XAResource xaResource = this.getDelegate(true);
        logger.debug("prepare {} xid ", (Object)xaResource);
        try {
            return xaResource.prepare(xid);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void start(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        logger.debug("start {} xid ", (Object)xaResource);
        try {
            xaResource.start(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public void end(Xid xid, int flags) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        logger.debug("end {} xid ", (Object)xaResource);
        try {
            xaResource.end(xid, flags);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public int getTransactionTimeout() throws XAException {
        XAResource xaResource = this.getDelegate(false);
        logger.debug("getTransactionTimeout {} xid ", (Object)xaResource);
        try {
            return xaResource.getTransactionTimeout();
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    @Override
    public boolean setTransactionTimeout(int seconds) throws XAException {
        XAResource xaResource = this.getDelegate(false);
        logger.debug("setTransactionTimeout {} xid ", (Object)xaResource);
        try {
            return xaResource.setTransactionTimeout(seconds);
        }
        catch (XAException e) {
            throw this.check(e);
        }
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver) {
        if (me.getType() == ActiveMQExceptionType.DISCONNECTED) {
            logger.debug("being disconnected for server shutdown", (Throwable)me);
        } else {
            ActiveMQXARecoveryLogger.LOGGER.xaRecoverConnectionError(this.csf, (Exception)me);
        }
        this.close();
    }

    public void connectionFailed(ActiveMQException me, boolean failedOver, String scaleDownTargetNodeID) {
        this.connectionFailed(me, failedOver);
    }

    public void beforeReconnect(ActiveMQException me) {
    }

    private XAResource getDelegate(boolean retry) throws XAException {
        XAResource result = null;
        Exception error = null;
        try {
            result = this.connect();
        }
        catch (Exception e) {
            error = e;
        }
        if (result == null) {
            if (retry) {
                XAException xae = new XAException("Connection unavailable for xa recovery");
                xae.errorCode = 4;
                if (error != null) {
                    xae.initCause(error);
                }
                logger.debug("Cannot get connectionFactory XAResource", (Throwable)xae);
                throw xae;
            }
            XAException xae = new XAException("Error trying to connect to any providers for xa recovery");
            xae.errorCode = -7;
            if (error != null) {
                xae.initCause(error);
            }
            logger.debug("Cannot get connectionFactory XAResource", (Throwable)xae);
            throw xae;
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XAResource connect() throws Exception {
        XARecoveryConfig[] xARecoveryConfigArray = lock;
        synchronized (lock) {
            if (this.delegate != null) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.delegate;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            for (XARecoveryConfig xaRecoveryConfig : this.xaRecoveryConfigs) {
                if (xaRecoveryConfig == null) continue;
                if (logger.isDebugEnabled()) {
                    logger.debug("Trying to connect recovery on {} of {}", (Object)xaRecoveryConfig, (Object)Arrays.toString(this.xaRecoveryConfigs));
                }
                ClientSession cs = null;
                try {
                    this.serverLocator = xaRecoveryConfig.getDiscoveryConfiguration() != null ? ActiveMQClient.createServerLocator((boolean)false, (DiscoveryGroupConfiguration)xaRecoveryConfig.getDiscoveryConfiguration()) : ActiveMQClient.createServerLocator((boolean)false, (TransportConfiguration[])xaRecoveryConfig.getTransportConfig());
                    if (xaRecoveryConfig.getLocatorConfig() != null) {
                        this.serverLocator.setLocatorConfig(xaRecoveryConfig.getLocatorConfig());
                    }
                    this.serverLocator.setProtocolManagerFactory(xaRecoveryConfig.getClientProtocolManager());
                    this.csf = this.serverLocator.createSessionFactory();
                    cs = xaRecoveryConfig.getUsername() == null ? this.csf.createSession(true, false, false) : this.csf.createSession(xaRecoveryConfig.getUsername(), xaRecoveryConfig.getPassword(), true, false, false, false, 1);
                }
                catch (Throwable e) {
                    ActiveMQXARecoveryLogger.LOGGER.xaRecoverAutoConnectionError(xaRecoveryConfig, e);
                    logger.debug(e.getMessage(), e);
                    try {
                        if (this.serverLocator == null) continue;
                        this.serverLocator.close();
                    }
                    catch (Throwable ignored) {
                        logger.trace(e.getMessage(), ignored);
                    }
                    continue;
                }
                cs.addFailureListener((SessionFailureListener)this);
                Object object = lock;
                synchronized (object) {
                    this.delegate = cs;
                }
                return this.delegate;
            }
            ActiveMQXARecoveryLogger.LOGGER.recoveryConnectFailed(Arrays.toString(this.xaRecoveryConfigs));
            throw new ActiveMQNotConnectedException();
        }
    }

    public String toString() {
        return "ActiveMQXAResourceWrapper [serverLocator=" + this.serverLocator + ", csf=" + this.csf + ", delegate=" + this.delegate + ", xaRecoveryConfigs=" + Arrays.toString(this.xaRecoveryConfigs) + ", instance=" + System.identityHashCode(this) + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ServerLocator oldServerLocator = null;
        ClientSessionFactory oldCSF = null;
        ClientSession oldDelegate = null;
        Object object = lock;
        synchronized (object) {
            oldCSF = this.csf;
            this.csf = null;
            oldDelegate = this.delegate;
            this.delegate = null;
            oldServerLocator = this.serverLocator;
            this.serverLocator = null;
        }
        if (oldDelegate != null) {
            try {
                oldDelegate.close();
            }
            catch (Throwable ignorable) {
                logger.debug(ignorable.getMessage(), ignorable);
            }
        }
        if (oldCSF != null) {
            try {
                oldCSF.close();
            }
            catch (Throwable ignorable) {
                logger.debug(ignorable.getMessage(), ignorable);
            }
        }
        if (oldServerLocator != null) {
            try {
                oldServerLocator.close();
            }
            catch (Throwable ignorable) {
                logger.debug(ignorable.getMessage(), ignorable);
            }
        }
    }

    protected XAException check(XAException e) throws XAException {
        ActiveMQXARecoveryLogger.LOGGER.xaRecoveryError(e);
        if (e.errorCode != -4) {
            this.close();
        }
        throw e;
    }
}

