/*
 * Decompiled with CFR 0.152.
 */
package org.apache.daffodil.runtime1.processors;

import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.daffodil.api.Daffodil;
import org.apache.daffodil.api.Diagnostic;
import org.apache.daffodil.api.InputSourceDataInputStream;
import org.apache.daffodil.api.infoset.InfosetOutputter;
import org.apache.daffodil.lib.exceptions.SchemaFileLocation;
import org.apache.daffodil.lib.xml.XMLUtils$;
import org.apache.daffodil.runtime1.iapi.DFDL;
import org.apache.daffodil.runtime1.infoset.SAXInfosetOutputter;
import org.apache.daffodil.runtime1.processors.DataProcessor;
import org.apache.daffodil.runtime1.processors.ParseResult;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Using;
import scala.util.Using$;

public class DaffodilParseXMLReader
implements org.apache.daffodil.api.DaffodilParseXMLReader {
    private final DataProcessor dp;
    private ContentHandler contentHandler;
    private ErrorHandler errorHandler;
    private DTDHandler dtdHandler;
    private EntityResolver entityResolver;
    private ParseResult saxParseResultPropertyValue;
    private Path saxBlobDirectoryPropertyValue;
    private String saxBlobPrefixPropertyValue;
    private String saxBlobSuffixPropertyValue;
    private boolean saxNamespaceFeatureValue;
    private boolean saxNamespacePrefixesFeatureValue;

    public DaffodilParseXMLReader(DataProcessor dp) {
        this.dp = dp;
        this.saxBlobDirectoryPropertyValue = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]);
        this.saxBlobPrefixPropertyValue = "daffodil-sax-";
        this.saxBlobSuffixPropertyValue = ".blob";
        this.saxNamespaceFeatureValue = true;
        this.saxNamespacePrefixesFeatureValue = false;
    }

    @Override
    public boolean getFeature(String name) {
        String string = name;
        String string2 = XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            return this.saxNamespaceFeatureValue;
        }
        String string4 = XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            return this.saxNamespacePrefixesFeatureValue;
        }
        return this.throwFeatureSAXNotRecogizedException(name, "Feature unsupported");
    }

    @Override
    public void setFeature(String name, boolean value) {
        String string = name;
        String string2 = XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.saxNamespaceFeatureValue = value;
            return;
        }
        String string4 = XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE();
        String string5 = string;
        if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
            this.saxNamespacePrefixesFeatureValue = value;
            return;
        }
        this.throwFeatureSAXNotRecogizedException(name, "Feature unsupported");
    }

    @Override
    public Object getProperty(String name) {
        Object object;
        String string = name;
        String string2 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_PARSERESULT();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            object = this.saxParseResultPropertyValue;
        } else {
            String string4 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBDIRECTORY();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                object = this.saxBlobDirectoryPropertyValue;
            } else {
                String string6 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBPREFIX();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    object = this.saxBlobPrefixPropertyValue;
                } else {
                    String string8 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBSUFFIX();
                    String string9 = string;
                    if (!(string8 != null ? !string8.equals(string9) : string9 != null)) {
                        object = this.saxBlobSuffixPropertyValue;
                    } else {
                        throw new SAXNotRecognizedException("Property unsupported: " + name + ".");
                    }
                }
            }
        }
        ParseResult prop = object;
        return prop;
    }

    @Override
    public void setProperty(String name, Object value) {
        block5: {
            try {
                String string = name;
                String string2 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBDIRECTORY();
                String string3 = string;
                if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
                    this.saxBlobDirectoryPropertyValue = (Path)value;
                    break block5;
                }
                String string4 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBPREFIX();
                String string5 = string;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    this.saxBlobPrefixPropertyValue = (String)value;
                    break block5;
                }
                String string6 = XMLUtils$.MODULE$.DAFFODIL_SAX_URN_BLOBSUFFIX();
                String string7 = string;
                if (!(string6 != null ? !string6.equals(string7) : string7 != null)) {
                    this.saxBlobSuffixPropertyValue = (String)value;
                    break block5;
                }
                throw new SAXNotRecognizedException("Property unsupported: " + name + ".");
            }
            catch (ClassCastException classCastException) {
                throw new SAXNotSupportedException("Unsupported value for property: " + name + ".");
            }
        }
    }

    @Override
    public void setEntityResolver(EntityResolver resolver) {
        this.entityResolver = resolver;
    }

    @Override
    public EntityResolver getEntityResolver() {
        return this.entityResolver;
    }

    @Override
    public void setDTDHandler(DTDHandler handler) {
        this.dtdHandler = handler;
    }

    @Override
    public DTDHandler getDTDHandler() {
        return this.dtdHandler;
    }

    @Override
    public void setContentHandler(ContentHandler handler) {
        this.contentHandler = handler;
    }

    @Override
    public ContentHandler getContentHandler() {
        return this.contentHandler;
    }

    @Override
    public void setErrorHandler(ErrorHandler handler) {
        this.errorHandler = handler;
    }

    @Override
    public ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public void parse(InputSource input) {
        InputStream is = input.getByteStream();
        if (is != null) {
            Using$.MODULE$.resource((Object)Daffodil.newInputSourceDataInputStream(is), (Function1)(JProcedure1 & Serializable)isdis -> this.parse((InputSourceDataInputStream)isdis), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return;
        }
        throw new IOException("InputSource must be backed by InputStream");
    }

    @Override
    public void parse(String systemId) {
        throw new IOException("SAX parsing of systemId is unsupported");
    }

    @Override
    public void parse(InputSourceDataInputStream isdis) {
        if (!this.saxNamespaceFeatureValue && !this.saxNamespacePrefixesFeatureValue) {
            throw new SAXException("Illegal State: Namespaces and NamespacePrefixes features cannot both be false");
        }
        SAXInfosetOutputter sio = new SAXInfosetOutputter(this, this.saxNamespaceFeatureValue, this.saxNamespacePrefixesFeatureValue);
        sio.setBlobAttributes(this.saxBlobDirectoryPropertyValue, this.saxBlobPrefixPropertyValue, this.saxBlobSuffixPropertyValue);
        DFDL.ParseResult pr = this.dp.parse(isdis, (InfosetOutputter)sio);
        this.saxParseResultPropertyValue = (ParseResult)pr;
        this.handleDiagnostics(pr);
    }

    @Override
    public void parse(InputStream stream) {
        Using$.MODULE$.resource((Object)Daffodil.newInputSourceDataInputStream(stream), (Function1)(JProcedure1 & Serializable)isdis -> this.parse((InputSourceDataInputStream)isdis), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    @Override
    public void parse(byte[] arr) {
        Using$.MODULE$.resource((Object)Daffodil.newInputSourceDataInputStream(arr), (Function1)(JProcedure1 & Serializable)isdis -> this.parse((InputSourceDataInputStream)isdis), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private void handleDiagnostics(DFDL.ParseResult pr) {
        java.util.List<Diagnostic> diagnostics = ((DFDL.Result)((Object)pr)).getDiagnostics();
        ErrorHandler eh = this.getErrorHandler();
        if (diagnostics.size() > 0 && eh != null) {
            diagnostics.forEach(d -> {
                SAXParseException spe;
                String msg = d.getMessage();
                Tuple3 tuple3 = (Tuple3)CollectionConverters$.MODULE$.ListHasAsScala(d.getLocationsInSchemaFiles()).asScala().headOption().map((Function1 & Serializable)s -> {
                    SchemaFileLocation sl = (SchemaFileLocation)s;
                    int ln = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)sl.lineNumber().getOrElse(DaffodilParseXMLReader::$anonfun$2)));
                    int cn = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString((String)sl.columnNumber().getOrElse(DaffodilParseXMLReader::$anonfun$3)));
                    String sId = sl.diagnosticFile().toString();
                    return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)ln), (Object)BoxesRunTime.boxToInteger((int)cn), (Object)sId);
                }).getOrElse(DaffodilParseXMLReader::$anonfun$4);
                if (tuple3 == null) {
                    throw new MatchError((Object)tuple3);
                }
                int lineNo = BoxesRunTime.unboxToInt((Object)tuple3._1());
                int colNo = BoxesRunTime.unboxToInt((Object)tuple3._2());
                String systemId = (String)tuple3._3();
                Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)lineNo), (Object)BoxesRunTime.boxToInteger((int)colNo), (Object)systemId);
                int lineNo2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
                int colNo2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
                String systemId2 = (String)tuple32._3();
                SAXParseException spe2 = spe = new SAXParseException(msg, null, systemId2, lineNo2, colNo2, (Exception)d);
                if (d.isError()) {
                    eh.error(spe2);
                    return;
                }
                eh.warning(spe2);
            });
            return;
        }
    }

    public boolean throwFeatureSAXNotRecogizedException(String name, String message) {
        throw new SAXNotRecognizedException(message + ": " + name + ".\nSupported features are: " + ((SeqOps)new .colon.colon((Object)XMLUtils$.MODULE$.SAX_NAMESPACES_FEATURE(), (List)new .colon.colon((Object)XMLUtils$.MODULE$.SAX_NAMESPACE_PREFIXES_FEATURE(), (List)Nil$.MODULE$))).mkString(", "));
    }

    private static final String $anonfun$2() {
        return "0";
    }

    private static final String $anonfun$3() {
        return "0";
    }

    private static final Tuple3 $anonfun$4() {
        return Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToInteger((int)0), (Object)BoxesRunTime.boxToInteger((int)0), null);
    }
}

