/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.sql.ResultSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.execute.CursorResultSet;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.impl.sql.execute.DMLVTIResultSet;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;

class UpdateVTIResultSet
extends DMLVTIResultSet {
    private ResultSet rs;
    private TemporaryRowHolderImpl rowHolder;

    public UpdateVTIResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        super(source, activation);
    }

    @Override
    protected void openCore() throws StandardException {
        int rowLocationColumn = -1;
        boolean firstRow = true;
        this.rs = this.activation.getTargetVTI();
        ExecRow row = this.getNextRowCore(this.sourceResultSet);
        if (null != row) {
            rowLocationColumn = row.nColumns();
        }
        if (this.constants.deferred) {
            this.activation.clearIndexScanInfo();
        }
        if (null == this.rowHolder && this.constants.deferred) {
            Properties properties = new Properties();
            this.rowHolder = new TemporaryRowHolderImpl(this.activation, properties, this.resultDescription);
        }
        try {
            while (row != null) {
                if (this.constants.deferred) {
                    if (firstRow) {
                        row.getColumn(rowLocationColumn).setValue(this.rs.getRow());
                        firstRow = false;
                    } else {
                        DataValueDescriptor rowLocation = row.cloneColumn(rowLocationColumn);
                        rowLocation.setValue(this.rs.getRow());
                        row.setColumn(rowLocationColumn, rowLocation);
                    }
                    this.rowHolder.insert(row);
                } else {
                    this.updateVTI(this.rs, row);
                }
                ++this.rowCount;
                if (this.constants.singleRowSource) {
                    row = null;
                    continue;
                }
                row = this.getNextRowCore(this.sourceResultSet);
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (this.constants.deferred) {
            CursorResultSet tempRS = this.rowHolder.getResultSet();
            try {
                tempRS.open();
                while ((row = tempRS.getNextRow()) != null) {
                    int rowNumber = row.getColumn(rowLocationColumn).getInt();
                    this.rs.absolute(rowNumber);
                    this.updateVTI(this.rs, row);
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
            finally {
                this.sourceResultSet.clearCurrentRow();
                tempRS.close();
            }
        }
        if (this.rowHolder != null) {
            this.rowHolder.close();
        }
    }

    @Override
    public void close() throws StandardException {
        this.close(false);
    }

    private void updateVTI(ResultSet target, ExecRow row) throws StandardException {
        int[] changedColumnIds = this.constants.changedColumnIds;
        try {
            for (int i = 0; i < changedColumnIds.length; ++i) {
                int columnId = changedColumnIds[i];
                DataValueDescriptor newValue = row.getColumn(i + 1);
                if (newValue.isNull()) {
                    target.updateNull(columnId);
                    continue;
                }
                newValue.setInto(target, columnId);
            }
            target.updateRow();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }
}

