import java.util.ArrayList;
import java.util.Collections;
import org.apache.derby.agg.Aggregator;

public  class   Median<V extends Comparable<V>>    implements  Aggregator<V,V,Median<V>>
{
    private ArrayList<V>   _values;

    public  Median() {}

    public  void    init() { _values = new ArrayList<V>(); }
    public  void    accumulate( V value ) { _values.add( value ); }
    public  void    merge( Median<V> other ) { _values.addAll( other._values ); }

    public  V       terminate()
    {
        Collections.sort( _values );

        int     count = _values.size();
        if ( count == 0 ) { return null; }
        else { return _values.get( count/2 ); }
    }
}

