/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class Triggers {
    private static final String RESULT_SET_NOT_OPEN = "XCL16";

    private Triggers() {
    }

    public static int doNothingInt() throws Throwable {
        return 1;
    }

    public static void doNothing() throws Throwable {
    }

    public static int doConnCommitInt() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.commit();
        return 1;
    }

    public static void doConnCommit() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.commit();
    }

    public static void doConnRollback() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.rollback();
    }

    public static void doConnectionSetIsolation() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.setTransactionIsolation(8);
    }

    public static int doConnStmtIntNoRS(String text) throws Throwable {
        Triggers.doConnStmtNoRS(text);
        return 1;
    }

    public static void doConnStmtNoRS(String text) throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = conn.createStatement();
        stmt.execute(text);
    }

    public static int doConnStmtInt(String text) throws Throwable {
        Triggers.doConnStmt(text);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doConnStmt(String text) throws Throwable {
        Statement stmt;
        Connection conn;
        block8: {
            conn = DriverManager.getConnection("jdbc:default:connection");
            stmt = conn.createStatement();
            if (stmt.execute(text)) {
                try (ResultSet rs = stmt.getResultSet();){
                    while (rs.next()) {
                    }
                }
            }
        }
        stmt.close();
        conn.close();
    }

    public static void getConnection() throws Throwable {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        conn.close();
        System.out.println("getConnection() called");
    }

    static void zipThroughRs(ResultSet s) throws SQLException {
        if (s == null) {
            return;
        }
        while (s.next()) {
        }
    }

    public static long returnPrimLong(long x) {
        return x;
    }

    public static Long returnLong(Long x) {
        return x;
    }
}

