/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.apache.derby.iapi.services.context.Context;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.sql.conn.LanguageConnectionContext;

public abstract class PropertyUtil
extends org.apache.derby.iapi.util.PropertyUtil {
    public static Serializable getDatabasePropertyDefault(String k) throws Exception {
        LanguageConnectionContext lcc = (LanguageConnectionContext)PropertyUtil.getContextOrNull("LanguageConnectionContext");
        if (lcc == null) {
            throw new Exception("getPropertyDefault only works in a connection");
        }
        return lcc.getTransactionExecute().getPropertyDefault(k);
    }

    public static void setDatabasePropertyDefault(String k, Serializable v) throws Exception {
        LanguageConnectionContext lcc = (LanguageConnectionContext)PropertyUtil.getContextOrNull("LanguageConnectionContext");
        if (lcc == null) {
            throw new Exception("getPropertyDefault only works in a connection");
        }
        lcc.getTransactionExecute().setPropertyDefault(k, v);
    }

    private static Context getContextOrNull(final String contextID) {
        if (System.getSecurityManager() == null) {
            return ContextService.getContextOrNull((String)contextID);
        }
        return AccessController.doPrivileged(new PrivilegedAction<Context>(){

            @Override
            public Context run() {
                return ContextService.getContextOrNull((String)contextID);
            }
        });
    }
}

