/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.replicationTests;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derby.client.ClientDataSourceInterface;
import org.apache.derby.jdbc.BasicClientDataSource40;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SimplePerfTest_Verify
extends BaseJDBCTestCase {
    private static String dbPath = "UNDEFINED!";
    private static String masterHostName = "UNDEFINED!";
    private static int masterPortNo = -1;
    private static int tuplesToInsert = -1;

    public SimplePerfTest_Verify(String string) {
        super(string);
    }

    public static Test suite() throws Exception {
        masterHostName = System.getProperty("test.serverHost", "localhost");
        masterPortNo = Integer.parseInt(System.getProperty("test.serverPort", "1527"));
        dbPath = System.getProperty("test.dbPath", "wombat");
        tuplesToInsert = Integer.parseInt(System.getProperty("test.inserts", "0"));
        BaseTestSuite baseTestSuite = new BaseTestSuite("SimplePerfTest_Verify");
        baseTestSuite.addTest(SimplePerfTest_Verify.suite(masterHostName, masterPortNo, dbPath));
        return baseTestSuite;
    }

    public static Test suite(String string, int n, String string2) {
        Test test = TestConfiguration.existingServerSuite(SimplePerfTest_Verify.class, false, string, n, string2);
        return SecurityManagerSetup.noSecurityManager(test);
    }

    public void testVerify() throws SQLException, IOException, InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        this.verifyTestInserts();
    }

    private void verifyTestInserts() throws SQLException, IOException, InterruptedException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        Connection connection = this.clientConnection(masterHostName, masterPortNo, dbPath);
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select count(*) from t");
        resultSet.next();
        int n = resultSet.getInt(1);
        SimplePerfTest_Verify.assertEquals((int)n, (int)tuplesToInsert);
    }

    private Connection clientConnection(String string, int n, String string2) throws SQLException, ClassNotFoundException, IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        BasicClientDataSource40 basicClientDataSource40;
        if (JDBC.vmSupportsJNDI()) {
            Class<?> clazz = Class.forName("org.apache.derby.jdbc.ClientDataSource");
            basicClientDataSource40 = (ClientDataSourceInterface)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        } else {
            basicClientDataSource40 = new BasicClientDataSource40();
        }
        basicClientDataSource40.setDatabaseName(string2);
        basicClientDataSource40.setServerName(string);
        basicClientDataSource40.setPortNumber(n);
        return basicClientDataSource40.getConnection();
    }
}

