/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.multi;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Date;
import java.util.Properties;
import java.util.Random;
import junit.framework.AssertionFailedError;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.Decorator;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StressMultiTest
extends BaseJDBCTestCase {
    private static int THREADS = 10;
    private static int MINUTES = 10;
    private static final String THREADSMINUTES = "derby.tests.ThreadsMinutes";
    private static boolean DEBUG = false;
    private Throwable thrown = null;
    private Thread[] threads = null;
    private Random rnd = new Random();
    private boolean complete = false;

    public StressMultiTest(String string) {
        super(string);
    }

    public static Test suite() {
        Properties properties = new Properties();
        properties.put("derby.locks.deadlockTimeout", "2");
        properties.put("derby.locks.waitTimeout", "3");
        Properties properties2 = new Properties();
        properties2.put("derby.storage.keepTransactionLog", "true");
        properties2.put("derby.language.logStatementText", "true");
        properties2.put("derby.infolog.append", "true");
        Object object = new BaseTestSuite(StressMultiTest.class);
        object = new SystemPropertyTestSetup((Test)object, properties2, true);
        object = new DatabasePropertyTestSetup((Test)object, properties);
        object = TestConfiguration.singleUseDatabaseDecorator(StressMultiTest.newCleanDatabase((Test)object));
        Test test = TestConfiguration.clientServerDecorator((Test)new BaseTestSuite(StressMultiTest.class));
        test = StressMultiTest.newCleanDatabase((Test)new DatabasePropertyTestSetup(test, properties));
        BaseTestSuite baseTestSuite = new BaseTestSuite(StressMultiTest.class);
        BaseTestSuite baseTestSuite2 = new BaseTestSuite("StressMultiTest:unencrypted");
        baseTestSuite2.addTest((Test)object);
        baseTestSuite2.addTest(test);
        BaseTestSuite baseTestSuite3 = new BaseTestSuite("StressMultiTest, " + THREADS + " Threads " + MINUTES + " Minutes");
        baseTestSuite3.addTest(StressMultiTest.newCleanDatabase((Test)baseTestSuite2));
        baseTestSuite3.addTest(Decorator.encryptedDatabase((Test)new DatabasePropertyTestSetup(StressMultiTest.newCleanDatabase((Test)baseTestSuite), properties)));
        return baseTestSuite3;
    }

    public static Test suite(int n, int n2) {
        THREADS = n;
        MINUTES = n2;
        return StressMultiTest.suite();
    }

    public static Test embeddedSuite(int n, int n2) {
        THREADS = n;
        MINUTES = n2;
        Properties properties = new Properties();
        properties.put("derby.locks.deadlockTimeout", "2");
        properties.put("derby.locks.waitTimeout", "3");
        properties.put("derby.language.logStatementText", "true");
        properties.put("derby.storage.keepTransactionLog", "true");
        Properties properties2 = new Properties();
        properties2.put("derby.storage.keepTransactionLog", "true");
        properties2.put("derby.language.logStatementText", "true");
        properties2.put("derby.infolog.append", "true");
        Object object = new BaseTestSuite(StressMultiTest.class);
        object = new SystemPropertyTestSetup((Test)object, properties2, true);
        object = new DatabasePropertyTestSetup((Test)object, properties);
        object = TestConfiguration.singleUseDatabaseDecorator(StressMultiTest.newCleanDatabase((Test)object));
        return object;
    }

    private static Test newCleanDatabase(Test test) {
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement statement) throws SQLException {
                statement.execute("CREATE FUNCTION  PADSTRING (DATA VARCHAR(32000), LENGTH INTEGER) RETURNS VARCHAR(32000) EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.Formatters.padString' LANGUAGE JAVA PARAMETER STYLE JAVA");
                statement.execute("CREATE FUNCTION RANDOM() RETURNS DOUBLE EXTERNAL NAME 'java.lang.Math.random' LANGUAGE JAVA PARAMETER STYLE JAVA");
                statement.execute("create table main(x int not null primary key, y varchar(2000))");
                statement.execute("insert into main values(1, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(2, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(3, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(4, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(5, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(6, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(7, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(8, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(9, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(10, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(12, PADSTRING('aaaa',2000))");
                statement.execute("insert into main values(13, PADSTRING('aaaa',2000))");
                statement.execute("create table main2(x int not null primary key, y varchar(2000))");
                statement.execute("insert into main2 values(1, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(2, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(3, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(4, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(5, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(6, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(7, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(8, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(9, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(10, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(12, PADSTRING('aaaa',2000))");
                statement.execute("insert into main2 values(13, PADSTRING('aaaa',2000))");
                this.getConnection().commit();
            }
        };
    }

    public void setUp() throws Exception {
        super.setUp();
        this.getTestConfiguration().setVerbosity(DEBUG);
        String string = StressMultiTest.getSystemProperty(THREADSMINUTES);
        if (string != null) {
            int n = string.indexOf("x");
            try {
                THREADS = Integer.parseInt(string.substring(0, n));
                MINUTES = Integer.parseInt(string.substring(n + 1, string.length()));
            }
            catch (Exception exception) {
                StressMultiTest.alarm("Illegal value for 'derby.tests.ThreadsMinutes': '" + string + "' - " + exception.getMessage() + ". Threads: " + THREADS + ", minutes: " + MINUTES);
            }
            StressMultiTest.traceit("Threads: " + THREADS + ", minutes: " + MINUTES);
        }
    }

    @Override
    public void tearDown() throws Exception {
        this.rnd = null;
        this.threads = null;
        super.tearDown();
    }

    public void testStressMulti() throws Throwable {
        this.thrown = null;
        StressMultiRunnable[] stressMultiRunnableArray = new StressMultiRunnable[THREADS];
        for (int i = 0; i < stressMultiRunnableArray.length; ++i) {
            stressMultiRunnableArray[i] = new StressMultiRunnable("Tester" + i, MINUTES);
        }
        this.runTestCaseRunnables(stressMultiRunnableArray);
        stressMultiRunnableArray = null;
        if (this.thrown != null) {
            throw this.thrown;
        }
    }

    protected void runTestCaseRunnables(StressMultiRunnable[] stressMultiRunnableArray) {
        int n;
        if (stressMultiRunnableArray == null) {
            throw new IllegalArgumentException("runnables is null");
        }
        this.threads = new Thread[stressMultiRunnableArray.length];
        for (n = 0; n < this.threads.length; ++n) {
            this.threads[n] = new Thread(stressMultiRunnableArray[n]);
        }
        for (n = 0; n < this.threads.length; ++n) {
            this.threads[n].start();
        }
        try {
            for (n = 0; n < this.threads.length; ++n) {
                this.threads[n].join();
            }
        }
        catch (InterruptedException interruptedException) {
            BaseTestCase.println("Thread join interrupted.");
        }
        this.threads = null;
    }

    private synchronized void handleException(Throwable throwable, String string) {
        this.complete = true;
        if (this.thrown == null) {
            if (throwable instanceof AssertionFailedError) {
                this.thrown = (AssertionFailedError)throwable;
            } else if (throwable instanceof SQLException) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                throwable.printStackTrace(new PrintStream(byteArrayOutputStream));
                this.thrown = new AssertionFailedError("Caused by: \n" + byteArrayOutputStream.toString());
            } else {
                this.thrown = throwable;
            }
            StressMultiTest.println("Exception handled!!: " + string + " - " + throwable);
        } else {
            StressMultiTest.println("Exception discarded because another was already caught and the threads are terminating..:\n" + string + " - " + throwable);
        }
    }

    class StressMultiRunnable
    implements Runnable {
        String name;
        Connection con;
        long starttime;
        long runtime;

        public StressMultiRunnable(String string, int n) {
            this.name = string;
            this.starttime = System.currentTimeMillis();
            this.runtime = n * 60 * 1000;
            try {
                this.con = StressMultiTest.this.openDefaultConnection();
                this.con.setAutoCommit(false);
            }
            catch (SQLException sQLException) {
                BaseTestCase.println(sQLException.toString());
            }
        }

        @Override
        public void run() {
            try {
                int n = 0;
                while (!StressMultiTest.this.complete) {
                    ++n;
                    int n2 = StressMultiTest.this.rnd.nextInt(100);
                    if (n2 < 10) {
                        var3_4 = "x";
                        switch (StressMultiTest.this.rnd.nextInt(4)) {
                            case 0: {
                                var3_4 = "a";
                                break;
                            }
                            case 1: {
                                var3_4 = "x";
                                break;
                            }
                            case 2: {
                                var3_4 = "y";
                                break;
                            }
                            case 3: {
                                var3_4 = "z";
                            }
                        }
                        this.create(var3_4);
                        BaseTestCase.println(this.name + " - Run " + n + " - Create " + var3_4 + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (n2 < 25) {
                        var3_4 = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            var3_4 = "main2";
                        }
                        this.roll(var3_4);
                        BaseTestCase.println(this.name + " - Run " + n + " - Roll " + var3_4 + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (n2 < 40) {
                        var3_4 = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            var3_4 = "main2";
                        }
                        this.insert(var3_4);
                        BaseTestCase.println(this.name + " - Run " + n + " - Insert " + var3_4 + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (n2 < 60) {
                        var3_4 = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            var3_4 = "main2";
                        }
                        this.update(var3_4);
                        BaseTestCase.println(this.name + " - Run " + n + " - Update " + var3_4 + " " + new Date(System.currentTimeMillis()).toString());
                    } else if (n2 <= 99) {
                        var3_4 = "main";
                        if (StressMultiTest.this.rnd.nextInt(2) == 1) {
                            var3_4 = "main2";
                        }
                        this.select(var3_4);
                        BaseTestCase.println(this.name + " - Run " + n + " - Select " + var3_4 + " " + new Date(System.currentTimeMillis()).toString());
                    }
                    if (this.starttime + this.runtime <= System.currentTimeMillis()) {
                        BaseTestCase.println(this.name + " - STOPPING - " + new Date(System.currentTimeMillis()).toString());
                        break;
                    }
                    Thread.sleep(StressMultiTest.this.rnd.nextInt(10));
                }
            }
            catch (Throwable throwable) {
                BaseTestCase.println("Exception in " + this.name + ": " + throwable);
                StressMultiTest.this.handleException(throwable, this.name + " - " + new Date(System.currentTimeMillis()).toString());
            }
            BaseTestCase.println(this.name + " terminated!");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(String string) throws SQLException {
            block6: {
                Statement statement = this.con.createStatement();
                try {
                    statement.execute("create table " + string + " (x int)");
                    statement.execute("insert into " + string + " values (1)");
                    statement.execute("insert into " + string + " values (1)");
                    statement.execute("insert into " + string + " values (1)");
                    statement.execute("insert into " + string + " values (1)");
                    statement.execute("insert into " + string + " values (1)");
                    statement.execute("drop table " + string);
                    this.con.commit();
                }
                catch (SQLException sQLException) {
                    String string2 = sQLException.getSQLState();
                    if (string2.equals("X0X08") || string2.equals("X0X05") || string2.equals("42X05") || string2.equals("42Y55") || string2.equals("42000") || string2.equals("40001") || string2.equals("40XL1") || string2.equals("40XL2") || string2.equals("42Y07")) break block6;
                    if (string2.equals("42Y55")) {
                        break block6;
                    }
                    throw sQLException;
                }
                finally {
                    statement = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void insert(String string) throws SQLException {
            block6: {
                Statement statement = this.con.createStatement();
                try {
                    statement.executeUpdate("insert into " + string + " values (random() * 1000 + 100, 'rand')");
                    this.con.commit();
                }
                catch (SQLException sQLException) {
                    String string2 = sQLException.getSQLState();
                    if (string2.equals("42000") || string2.equals("23505") || string2.equals("40001") || string2.equals("40XL1") || string2.equals("40XL2") || string2.equals("42Y07")) break block6;
                    if (string2.equals("42Y55")) {
                        break block6;
                    }
                    throw sQLException;
                }
                finally {
                    statement = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void roll(String string) throws SQLException {
            block6: {
                Statement statement = this.con.createStatement();
                this.con.setAutoCommit(false);
                try {
                    statement.executeUpdate("insert into " + string + " values (666, '666')");
                    this.con.rollback();
                }
                catch (SQLException sQLException) {
                    String string2 = sQLException.getSQLState();
                    if (string2.equals("X0X05") || string2.equals("42X05") || string2.equals("42Y55") || string2.equals("42000") || string2.equals("23505") || string2.equals("40001") || string2.equals("40XL1") || string2.equals("40XL2") || string2.equals("42Y07")) break block6;
                    if (string2.equals("42Y55")) {
                        break block6;
                    }
                    throw sQLException;
                }
                finally {
                    statement = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void select(String string) throws SQLException {
            block6: {
                Statement statement = this.con.createStatement();
                try {
                    ResultSet resultSet = statement.executeQuery("select * from " + string);
                    JDBC.assertDrainResults(resultSet);
                }
                catch (SQLException sQLException) {
                    String string2 = sQLException.getSQLState();
                    if (string2.equals("42Y55") || string2.equals("42000") || string2.equals("40001") || string2.equals("40XL1") || string2.equals("40XL2")) break block6;
                    if (string2.equals("42Y07")) {
                        break block6;
                    }
                    throw sQLException;
                }
                finally {
                    statement = null;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void update(String string) throws SQLException {
            block6: {
                Statement statement = this.con.createStatement();
                try {
                    statement.executeUpdate("update " + string + " main set y = 'zzz' where x = 5");
                }
                catch (SQLException sQLException) {
                    String string2 = sQLException.getSQLState();
                    if (string2.equals("42Y55") || string2.equals("42000") || string2.equals("40001") || string2.equals("40XL1") || string2.equals("40XL2")) break block6;
                    if (string2.equals("42Y07")) {
                        break block6;
                    }
                    throw sQLException;
                }
                finally {
                    statement = null;
                }
            }
        }
    }
}

