/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class connectionJdbc20 {
    public static void main(String[] stringArray) {
        System.out.println("Test connection20 starting");
        try {
            ij.getPropertyArg((String[])stringArray);
            Connection connection = ij.startJBMS();
            Statement statement = connection.createStatement();
            statement.execute("create table tab1(c1 char(100) for bit data,c2 varchar(100) for bit data,c3 long varchar for bit data,c4 char(100),c5 varchar(100),c6 long varchar)");
            Connection connection2 = statement.getConnection();
            if (connection.equals(connection2)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
            connectionJdbc20.load_data(connection2);
            ResultSet resultSet = statement.executeQuery("select c1,c2,c3,c4,c5,c6,c1 as c1_spare,c2 as c2_spare,c3 as c3_spare from tab1");
            for (int i = 0; i < 2; ++i) {
                while (resultSet.next()) {
                    for (int j = 1; j < 7; ++j) {
                        connectionJdbc20.get_using_object(resultSet, j);
                        connectionJdbc20.get_using_string(resultSet, j);
                        connectionJdbc20.get_using_ascii_stream(resultSet, j);
                        if (j >= 4) continue;
                        connectionJdbc20.get_using_binary_stream(resultSet, j + 6);
                        connectionJdbc20.get_using_bytes(resultSet, j + 6);
                    }
                }
                Statement statement2 = resultSet.getStatement();
                if (statement.equals(statement2)) {
                    System.out.println("Got Same Statement Object");
                } else {
                    System.out.println("Got Different Statement Object");
                }
                resultSet.close();
                resultSet = statement.executeQuery("select c1,c2,c3,c4,c5,c6,c1 as c1_spare,c2 as c2_spare,c3 as c3_spare from tab1");
            }
            statement.close();
            DatabaseMetaData databaseMetaData = connection.getMetaData();
            resultSet = databaseMetaData.getTypeInfo();
            while (resultSet.next()) {
                System.out.println(resultSet.getString(1));
            }
            statement = resultSet.getStatement();
            resultSet.close();
            System.out.println("Try to Get the connection back from metadata");
            connection2 = databaseMetaData.getConnection();
            if (connection.equals(connection2)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
            CallableStatement callableStatement = connection.prepareCall("select * from tab1");
            System.out.println(" Try to get the connection back from a callable stmt");
            connection2 = callableStatement.getConnection();
            if (connection.equals(connection2)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
            callableStatement.close();
            connection.close();
        }
        catch (SQLException sQLException) {
            connectionJdbc20.dumpSQLExceptions(sQLException);
            sQLException.printStackTrace();
        }
        catch (Throwable throwable) {
            System.out.println("FAIL -- unexpected exception: " + throwable);
            throwable.printStackTrace();
        }
        System.out.println("Test getConnection  finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load_data(Connection connection) throws Exception {
        try (PreparedStatement preparedStatement = null;){
            preparedStatement = connection.prepareStatement("insert into tab1 values(?,?,?,?,?,?)");
            String string = "C1XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String string2 = "C2XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String string3 = "C3XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String string4 = "C4XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String string5 = "C5XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String string6 = "C6XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            preparedStatement.setBytes(1, string.getBytes("US-ASCII"));
            preparedStatement.setBytes(2, string2.getBytes("US-ASCII"));
            preparedStatement.setBytes(3, string3.getBytes("US-ASCII"));
            preparedStatement.setString(4, string4);
            preparedStatement.setString(5, string5);
            preparedStatement.setString(6, string6);
            preparedStatement.execute();
            System.out.println("Try to get connection using preaparedstatement");
            Connection connection2 = preparedStatement.getConnection();
            if (connection.equals(connection2)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
        }
    }

    private static void dumpSQLExceptions(SQLException sQLException) {
        System.out.println("FAIL -- unexpected exception");
        while (sQLException != null) {
            System.out.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    private static void dumpExpectedSQLExceptions(SQLException sQLException) {
        System.out.println("PASS -- expected exception");
        while (sQLException != null) {
            System.out.println("SQLSTATE(" + sQLException.getSQLState() + "): " + sQLException);
            sQLException = sQLException.getNextException();
        }
    }

    private static int printbytearray(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n) {
            System.out.print("x" + Integer.toHexString(byArray[n3]));
            if (n3 > 0 && n3 % 20 == 0) {
                System.out.println("");
            }
            ++n3;
            ++n2;
        }
        return n2;
    }

    static void get_using_object(ResultSet resultSet, int n) throws Exception {
        System.out.println("getObject(" + n + ")");
        Object object = resultSet.getObject(n);
        if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            System.out.println("  as byte[] length " + byArray.length);
            connectionJdbc20.printbytearray(byArray, byArray.length, 0);
            System.out.println("");
        } else {
            System.out.println("  as String");
            System.out.println(object.toString());
        }
    }

    static void get_using_bytes(ResultSet resultSet, int n) throws Exception {
        System.out.println("getBytes(" + n + ")");
        byte[] byArray = resultSet.getBytes(n);
        connectionJdbc20.printbytearray(byArray, byArray.length, 0);
        System.out.println("");
    }

    static void get_using_string(ResultSet resultSet, int n) throws Exception {
        String string = resultSet.getString(n);
        System.out.println("getString(" + n + ") length " + string.length());
        System.out.println(string);
    }

    static void get_using_ascii_stream(ResultSet resultSet, int n) throws Exception {
        System.out.println("getAsciiStream(" + n + ")");
        int n2 = 0;
        InputStream inputStream = resultSet.getAsciiStream(n);
        byte[] byArray = new byte[200];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            n3 = connectionJdbc20.printbytearray(byArray, n2, n3);
        }
        System.out.println("");
    }

    static void get_using_binary_stream(ResultSet resultSet, int n) throws Exception {
        System.out.println("getBinaryStream(" + n + ")");
        int n2 = 0;
        InputStream inputStream = resultSet.getBinaryStream(n);
        byte[] byArray = new byte[200];
        int n3 = 0;
        while ((n2 = inputStream.read(byArray)) != -1) {
            n3 = connectionJdbc20.printbytearray(byArray, n2, n3);
        }
        System.out.println("");
    }
}

