/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.io.PrintStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Properties;
import junit.framework.TestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.XML;

public class EnvTest
extends TestCase {
    public EnvTest(String string) {
        super(string);
    }

    public void traceit(String string) {
        this.setName(string);
        PrintStream printStream = System.out;
        String string2 = "derby.tests.trace";
        if (Boolean.valueOf(EnvTest.getSystemProperties().getProperty(string2)).booleanValue()) {
            printStream.println(string);
        }
    }

    public static final Properties getSystemProperties() {
        return System.getProperties();
    }

    public void testJSR169() {
        this.traceit(String.valueOf(JDBC.vmSupportsJSR169()) + "_vmSupportsJSR169()");
    }

    public void testJDBC3() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC3()) + "_vmSupportsJDBC3()");
    }

    public void testJDBC4() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC4()) + "_vmSupportsJDBC4()");
    }

    public void testJDBC41() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC41()) + "_vmSupportsJDBC41()");
    }

    public void testJDBC42() {
        this.traceit(String.valueOf(JDBC.vmSupportsJDBC42()) + "_vmSupportsJDBC42()");
    }

    public void testHasServer() {
        this.traceit(String.valueOf(Derby.hasServer() + "_hasServer"));
    }

    public void testHasClient() {
        this.traceit(String.valueOf(Derby.hasClient() + "_hasClient"));
    }

    public void testHasEmbedded() {
        this.traceit(String.valueOf(Derby.hasEmbedded() + "_hasEmbedded"));
    }

    public void testHasTools() {
        this.traceit(String.valueOf(Derby.hasTools() + "_hasTools"));
    }

    public void testClasspathHasXalanAndJAXP() {
        this.traceit(String.valueOf(XML.classpathHasJAXP() + "_classpathHasJAXP"));
    }

    public void testClasspathMeetsXMLReqs() {
        this.traceit(String.valueOf(XML.classpathMeetsXMLReqs() + "_classpathMeetsXMLReqs"));
    }

    public void testHasLuceneCoreJar() {
        this.traceit(String.valueOf(JDBC.HAVE_LUCENE_CORE + "_hasLuceneCore"));
    }

    public void testHasLuceneQueryParserJar() {
        this.traceit(String.valueOf(JDBC.HAVE_LUCENE_QUERYPARSER + "_hasLuceneQueryParser"));
    }

    public void testHasLuceneAnalyzersJar() {
        this.traceit(String.valueOf(JDBC.HAVE_LUCENE_ANALYZERS + "_hasLuceneAnalyzers"));
    }

    public void testHasLDAPConfig() {
        Properties properties = EnvTest.getSystemProperties();
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(properties.getProperty("derbyTesting.ldapPassword"));
        arrayList.add(properties.getProperty("derbyTesting.ldapServer"));
        arrayList.add(properties.getProperty("derbyTesting.ldapPort"));
        arrayList.add(properties.getProperty("derbyTesting.dnString"));
        arrayList.add(properties.getProperty("derbyTesting.ldapContextFactory"));
        boolean bl = true;
        for (String string : arrayList) {
            if (string != null && string.length() != 0 && !string.isEmpty()) continue;
            bl = false;
            break;
        }
        this.traceit(String.valueOf(bl) + "_hasLDAPConfiguration");
    }

    public void testHasJNDISupport() {
        this.traceit(String.valueOf(JDBC.vmSupportsJNDI() + "_classpathMeetsJNDIReqs"));
    }

    public void testHasBasicEncryptionSupport() {
        try {
            MessageDigest.getInstance("SHA-256");
            this.traceit("true_hasBasicEncryptionAlgorithmSupport");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.traceit("false_hasBasicEncryptionAlgorithmSupport");
        }
    }

    public void testHasSubStandardEncryptionSupport() {
        try {
            MessageDigest.getInstance("SHA-1");
            this.traceit("true_hasSubstandardEncryptionAlgorithmSupport");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            this.traceit("false_hasSubStandardEncryptionAlgorithmSupport");
        }
    }
}

