/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.util.Properties;
import javax.sql.CommonDataSource;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import junit.framework.Test;
import org.apache.derby.authentication.UserAuthenticator;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCClient;
import org.apache.derbyTesting.junit.JDBCClientSetup;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LoginTimeoutTest
extends BaseJDBCTestCase {
    private static final String[][] SYSTEM_PROPERTIES = new String[][]{{"derby.connection.requireAuthentication", "true"}, {"derby.authentication.provider", LoginTimeoutTest.class.getName() + "$SluggishAuthenticator"}};
    private static final boolean SUCCEED = true;
    private static final boolean FAIL = false;
    private static final int LONG_TIMEOUT = 10;
    private static final String RUTH = "RUTH";
    private static final String RUTH_PASSWORD = "RUTHPASSWORD";
    private static final String LOGIN_TIMEOUT = "XBDA0";
    private static final String LOGIN_FAILED = "08004";

    public LoginTimeoutTest(String name) {
        super(name);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite();
        Object embedded = new BaseTestSuite(LoginTimeoutTest.class, "embedded LoginTimeoutTest");
        embedded = TestConfiguration.singleUseDatabaseDecorator((Test)embedded);
        embedded = new SystemPropertyTestSetup((Test)embedded, LoginTimeoutTest.systemProperties());
        suite.addTest((Test)embedded);
        if (Derby.hasServer() && Derby.hasClient()) {
            Object clientServer = new BaseTestSuite(LoginTimeoutTest.class, "client/server LoginTimeoutTest");
            clientServer = TestConfiguration.singleUseDatabaseDecorator((Test)clientServer);
            clientServer = new JDBCClientSetup((Test)clientServer, JDBCClient.DERBYNETCLIENT);
            clientServer = new NetworkServerTestSetup((Test)clientServer, LoginTimeoutTest.systemPropertiesArray(), new String[0], true);
            suite.addTest((Test)clientServer);
        }
        return suite;
    }

    private static Properties systemProperties() {
        Properties props = new Properties();
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            String[] raw = SYSTEM_PROPERTIES[i];
            props.put(raw[0], raw[1]);
        }
        return props;
    }

    private static String[] systemPropertiesArray() {
        String[] result = new String[SYSTEM_PROPERTIES.length];
        for (int i = 0; i < SYSTEM_PROPERTIES.length; ++i) {
            String[] raw = SYSTEM_PROPERTIES[i];
            result[i] = raw[0] + "=" + raw[1];
        }
        return result;
    }

    public void testBasic() throws Exception {
        SluggishAuthenticator.debugPrinting = TestConfiguration.getCurrent().isVerbose();
        Connection conn = this.openDefaultConnection(RUTH, RUTH_PASSWORD);
        conn.close();
        this.vetConnector(new DriverManagerConnector(this), true);
        this.vetConnector(new DataSourceConnector(JDBCDataSource.getDataSource()), true);
        this.vetConnector(new DataSourceConnector(J2EEDataSource.getConnectionPoolDataSource()), true);
        this.vetConnector(new DataSourceConnector(J2EEDataSource.getXADataSource()), true);
        if (LoginTimeoutTest.usingEmbedded()) {
            this.vetExceptionPassthrough();
        }
        if (LoginTimeoutTest.usingDerbyNetClient()) {
            this.vetServerTimeouts();
        }
    }

    private void vetConnector(Connector connector, boolean shouldSucceed) throws Exception {
        try {
            if (LoginTimeoutTest.usingEmbedded()) {
                SluggishAuthenticator.secondsToSleep = 4L;
            }
            this.tryTimeout(connector, 1, false);
            if (LoginTimeoutTest.usingEmbedded()) {
                SluggishAuthenticator.secondsToSleep = 2L;
            }
            this.tryTimeout(connector, 10, shouldSucceed);
            this.tryTimeout(connector, 0, shouldSucceed);
        }
        finally {
            connector.setLoginTimeout(0);
            SluggishAuthenticator.secondsToSleep = 2L;
        }
    }

    private void tryTimeout(Connector connector, int timeout, boolean shouldSucceed) throws Exception {
        LoginTimeoutTest.println("Setting timeout " + timeout + " on " + connector);
        connector.setLoginTimeout(timeout);
        this.tryTimeout(connector, shouldSucceed);
    }

    private void tryTimeout(Connector connector, boolean shouldSucceed) throws Exception {
        long startTime = System.currentTimeMillis();
        try {
            Connection conn = connector.getConnection(RUTH, RUTH_PASSWORD);
            LoginTimeoutTest.println("    Got a " + conn.getClass().getName());
            conn.close();
            if (!shouldSucceed) {
                long duration = System.currentTimeMillis() - startTime;
                String message = "Should not have been able to connect! \n         connector: " + connector + "        Experiment took " + duration + " milliseconds. \n         seconds sleep time was: " + SluggishAuthenticator.secondsToSleep;
                LoginTimeoutTest.fail((String)message);
            }
        }
        catch (SQLException se) {
            if (shouldSucceed) {
                LoginTimeoutTest.fail("Should have been able to connect!", se);
            }
            LoginTimeoutTest.assertTrue((String)("Didn't expect to see a " + se.getClass().getName()), (boolean)(se instanceof SQLTimeoutException));
            LoginTimeoutTest.assertSQLState(LOGIN_TIMEOUT, se);
        }
        long duration = System.currentTimeMillis() - startTime;
        LoginTimeoutTest.println("        Experiment took " + duration + " milliseconds.");
    }

    private void vetExceptionPassthrough() throws Exception {
        try {
            LoginTimeoutTest.println("Verifying that exceptions are not swallowed by the embedded login timer.");
            DriverManager.setLoginTimeout(10);
            SluggishAuthenticator.returnValue = false;
            try {
                Connection conn = this.openDefaultConnection(RUTH, RUTH_PASSWORD);
                conn.close();
                LoginTimeoutTest.fail((String)"Didn't expect to get a connection!");
            }
            catch (SQLException se) {
                LoginTimeoutTest.assertSQLState(LOGIN_FAILED, se);
            }
        }
        finally {
            DriverManager.setLoginTimeout(0);
            SluggishAuthenticator.returnValue = true;
        }
    }

    private void vetServerTimeouts() throws Exception {
        LoginTimeoutTest.println("Verifying behavior when timeouts are also set on the server.");
        Connection controlConnection = this.openDefaultConnection(RUTH, RUTH_PASSWORD);
        String createProc = "create procedure setLoginTimeout( timeout int ) language java parameter style java no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".setLoginTimeout'";
        LoginTimeoutTest.println(createProc);
        controlConnection.prepareStatement(createProc).execute();
        createProc = "create procedure setAuthenticatorSleep( seconds int ) language java parameter style java no sql\nexternal name '" + ((Object)((Object)this)).getClass().getName() + ".setAuthenticatorSleep'";
        controlConnection.prepareStatement(createProc).execute();
        LoginTimeoutTest.println(createProc);
        DriverManagerConnector connector = new DriverManagerConnector(this);
        this.vetServerTimeout(controlConnection, connector, 1, false);
        this.vetServerTimeout(controlConnection, connector, 10, true);
        this.vetServerTimeout(controlConnection, connector, 0, true);
        this.setServerTimeout(controlConnection, 0);
        controlConnection.prepareStatement("drop procedure setLoginTimeout").execute();
        controlConnection.close();
    }

    private void vetServerTimeout(Connection controlConnection, Connector connector, int serverTimeout, boolean shouldSucceed) throws Exception {
        this.setServerTimeout(controlConnection, serverTimeout);
        if (!shouldSucceed) {
            this.setServerAuthenticatorSleep(controlConnection, 4);
        } else {
            this.setServerAuthenticatorSleep(controlConnection, 2);
        }
        this.vetConnector(connector, shouldSucceed);
    }

    private void setServerTimeout(Connection conn, int seconds) throws Exception {
        CallableStatement cs = conn.prepareCall("call setLoginTimeout( ? )");
        cs.setInt(1, seconds);
        cs.execute();
        cs.close();
    }

    private void setServerAuthenticatorSleep(Connection conn, int seconds) throws Exception {
        CallableStatement cs = conn.prepareCall("call setAuthenticatorSleep( ? )");
        cs.setInt(1, seconds);
        cs.execute();
        cs.close();
    }

    public static void setLoginTimeout(int seconds) throws Exception {
        DriverManager.setLoginTimeout(seconds);
    }

    public static void setAuthenticatorSleep(int seconds) throws Exception {
        SluggishAuthenticator.secondsToSleep = seconds;
    }

    public static final class SluggishAuthenticator
    implements UserAuthenticator {
        public static boolean debugPrinting = false;
        private static final long MILLIS_PER_SECOND = 1000L;
        public static long secondsToSleep = 2L;
        public static boolean returnValue = true;

        public boolean authenticateUser(String userName, String userPassword, String databaseName, Properties info) throws SQLException {
            try {
                long sleepTime = secondsToSleep * 1000L;
                SluggishAuthenticator.printText("SluggishAuthenticator going to sleep for " + sleepTime + " milliseconds.");
                Thread.sleep(secondsToSleep * 1000L);
                SluggishAuthenticator.printText("...SluggishAuthenticator waking up after " + sleepTime + " milliseconds.");
            }
            catch (Exception e) {
                throw new SQLException(e.getMessage(), e);
            }
            return returnValue;
        }

        private static void printText(String text) {
            if (debugPrinting) {
                BaseTestCase.println(text);
            }
        }
    }

    public static final class DriverManagerConnector
    implements Connector {
        private BaseJDBCTestCase _test;

        public DriverManagerConnector(BaseJDBCTestCase test) {
            this._test = test;
        }

        @Override
        public Connection getConnection(String user, String password) throws SQLException {
            return this._test.openDefaultConnection(user, password);
        }

        @Override
        public void setLoginTimeout(int seconds) {
            DriverManager.setLoginTimeout(seconds);
        }

        public String toString() {
            return "DriverManagerConnector";
        }
    }

    public static interface Connector {
        public Connection getConnection(String var1, String var2) throws SQLException;

        public void setLoginTimeout(int var1) throws SQLException;
    }

    public static final class DataSourceConnector
    implements Connector {
        private CommonDataSource _dataSource;

        public DataSourceConnector(CommonDataSource dataSource) {
            this._dataSource = dataSource;
        }

        @Override
        public Connection getConnection(String user, String password) throws SQLException {
            if (this._dataSource instanceof DataSource) {
                return ((DataSource)this._dataSource).getConnection(user, password);
            }
            if (this._dataSource instanceof ConnectionPoolDataSource) {
                return ((ConnectionPoolDataSource)this._dataSource).getPooledConnection(user, password).getConnection();
            }
            if (this._dataSource instanceof XADataSource) {
                return ((XADataSource)this._dataSource).getXAConnection(user, password).getConnection();
            }
            throw new SQLException("Unknown data source type: " + this._dataSource.getClass().getName());
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            this._dataSource.setLoginTimeout(seconds);
        }

        public String toString() {
            return "DataSourceConnector( " + this._dataSource.getClass().getName() + " )";
        }
    }
}

