/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BlobSetMethodsTest
extends BaseJDBCTestCase {
    private static int BUFFER_SIZE = 1024;
    private static int UPDATE_SIZE = 100;

    public BlobSetMethodsTest(String string) {
        super(string);
    }

    protected void setUp() throws Exception {
        Connection connection = this.getConnection();
        Statement statement = connection.createStatement();
        statement.execute("create table blobtest (id integer, data Blob)");
        statement.close();
        connection.close();
    }

    public static Test suite() {
        return TestConfiguration.defaultSuite(BlobSetMethodsTest.class);
    }

    public void testSetBytesLargeBlob() throws SQLException {
        int n;
        int n2;
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into blobtest (id, data) values (?,?)");
        Blob blob = connection.createBlob();
        byte[] byArray = new byte[BUFFER_SIZE];
        for (n2 = 0; n2 < BUFFER_SIZE; ++n2) {
            byArray[n2] = (byte)(n2 % 255);
        }
        for (n2 = 0; n2 < 5; ++n2) {
            blob.setBytes(n2 * BUFFER_SIZE + 1, byArray);
        }
        BlobSetMethodsTest.assertEquals((long)(BUFFER_SIZE * 5), (long)blob.length());
        byte[] byArray2 = new byte[UPDATE_SIZE];
        for (int i = 0; i < UPDATE_SIZE; ++i) {
            byArray2[i] = 120;
        }
        blob.setBytes(BUFFER_SIZE + 1, byArray2);
        blob.setBytes(BUFFER_SIZE * 5 + 1, byArray2);
        BlobSetMethodsTest.assertEquals((long)(5 * BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        preparedStatement.setInt(1, 3);
        preparedStatement.setBlob(2, blob);
        preparedStatement.executeUpdate();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select data from blobtest where id = 3");
        BlobSetMethodsTest.assertEquals((boolean)true, (boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        byte[] byArray3 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        BlobSetMethodsTest.assertEquals((long)(5 * BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        for (n = 0; n < UPDATE_SIZE; ++n) {
            BlobSetMethodsTest.assertEquals((byte)byArray2[n], (byte)byArray3[n]);
        }
        byArray3 = blob.getBytes(5 * BUFFER_SIZE + 1, UPDATE_SIZE);
        for (n = 0; n < UPDATE_SIZE; ++n) {
            BlobSetMethodsTest.assertEquals((byte)byArray2[n], (byte)byArray3[n]);
        }
        blob.truncate(BUFFER_SIZE);
        BlobSetMethodsTest.assertEquals((String)"truncate failed", (long)BUFFER_SIZE, (long)blob.length());
        resultSet.close();
        connection.commit();
        statement.close();
        preparedStatement.close();
    }

    public void testSetBytesSmallBlob() throws SQLException {
        int n;
        Connection connection = this.getConnection();
        connection.setAutoCommit(false);
        PreparedStatement preparedStatement = connection.prepareStatement("insert into blobtest (id, data) values (?,?)");
        preparedStatement.setInt(1, 1);
        Blob blob = connection.createBlob();
        byte[] byArray = new byte[BUFFER_SIZE];
        for (int i = 0; i < BUFFER_SIZE; ++i) {
            byArray[i] = (byte)(i % 255);
        }
        blob.setBytes(1L, byArray);
        BlobSetMethodsTest.assertEquals((long)BUFFER_SIZE, (long)blob.length());
        preparedStatement.setBlob(2, blob);
        preparedStatement.executeUpdate();
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("select data from blobtest where id = 1");
        BlobSetMethodsTest.assertEquals((boolean)true, (boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        BlobSetMethodsTest.assertEquals((long)BUFFER_SIZE, (long)blob.length());
        byte[] byArray2 = new byte[UPDATE_SIZE];
        for (int i = 0; i < UPDATE_SIZE; ++i) {
            byArray2[i] = 120;
        }
        blob.setBytes(UPDATE_SIZE, byArray2);
        byte[] byArray3 = blob.getBytes(100L, UPDATE_SIZE);
        for (n = 0; n < UPDATE_SIZE; ++n) {
            BlobSetMethodsTest.assertEquals((byte)byArray2[n], (byte)byArray3[n]);
        }
        blob.setBytes(BUFFER_SIZE + 1, byArray2);
        BlobSetMethodsTest.assertEquals((long)(BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        byArray3 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        for (n = 0; n < UPDATE_SIZE; ++n) {
            BlobSetMethodsTest.assertEquals((byte)byArray2[n], (byte)byArray3[n]);
        }
        preparedStatement.setInt(1, 2);
        preparedStatement.setBlob(2, blob);
        preparedStatement.executeUpdate();
        resultSet = statement.executeQuery("select data from blobtest where id = 2");
        BlobSetMethodsTest.assertEquals((boolean)true, (boolean)resultSet.next());
        blob = resultSet.getBlob(1);
        BlobSetMethodsTest.assertEquals((long)(BUFFER_SIZE + UPDATE_SIZE), (long)blob.length());
        byArray3 = blob.getBytes(100L, UPDATE_SIZE);
        for (n = 0; n < UPDATE_SIZE; ++n) {
            BlobSetMethodsTest.assertEquals((byte)byArray2[n], (byte)byArray3[n]);
        }
        byArray3 = blob.getBytes(BUFFER_SIZE + 1, UPDATE_SIZE);
        for (n = 0; n < UPDATE_SIZE; ++n) {
            BlobSetMethodsTest.assertEquals((byte)byArray2[n], (byte)byArray3[n]);
        }
        blob = connection.createBlob();
        byArray = new byte[100];
        for (n = 0; n < 100; ++n) {
            byArray[n] = (byte)n;
        }
        blob.setBytes(1L, byArray);
        BlobSetMethodsTest.assertEquals((long)blob.length(), (long)100L);
        blob.truncate(50L);
        BlobSetMethodsTest.assertEquals((long)blob.length(), (long)50L);
        blob.setBytes(1L, byArray);
        BlobSetMethodsTest.assertEquals((String)"set failed", (long)blob.length(), (long)100L);
        blob.truncate(50L);
        BlobSetMethodsTest.assertEquals((String)"truncation failed", (long)blob.length(), (long)50L);
        resultSet.close();
        connection.commit();
        statement.close();
        preparedStatement.close();
    }

    @Override
    protected void tearDown() throws Exception {
        Connection connection = this.getConnection();
        connection.setAutoCommit(true);
        Statement statement = connection.createStatement();
        statement.execute("drop table blobtest");
        statement.close();
        super.tearDown();
    }
}

