/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.util.streams;

import java.io.InputStream;
import org.apache.derby.iapi.types.Resetable;
import org.apache.derbyTesting.functionTests.util.streams.ByteAlphabet;

public class LoopingAlphabetStream
extends InputStream
implements Resetable {
    private static final int MAX_BUF_SIZE = 32768;
    private static final byte SPACE = 32;
    private final long length;
    private final int trailingBlanks;
    private long remainingBlanks;
    private long remainingNonBlanks;
    private byte[] buffer = new byte[0];
    private final ByteAlphabet alphabet;

    public LoopingAlphabetStream(long l) {
        this(l, 0);
    }

    public LoopingAlphabetStream(long l, int n) {
        if ((long)n > l) {
            throw new IllegalArgumentException("Number of trailing blanks cannot be greater than the total length.");
        }
        this.length = l;
        this.trailingBlanks = n;
        this.remainingNonBlanks = l - (long)n;
        this.remainingBlanks = n;
        this.alphabet = ByteAlphabet.modernLatinLowercase();
        this.fillBuffer(this.alphabet.byteCount());
    }

    public LoopingAlphabetStream(long l, ByteAlphabet byteAlphabet) {
        this(l, byteAlphabet, 0);
    }

    public LoopingAlphabetStream(long l, ByteAlphabet byteAlphabet, int n) {
        this.length = l;
        this.trailingBlanks = n;
        this.remainingNonBlanks = l - (long)n;
        this.remainingBlanks = n;
        this.alphabet = byteAlphabet;
        this.fillBuffer(byteAlphabet.byteCount());
    }

    @Override
    public int read() {
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        if (this.remainingNonBlanks <= 0L) {
            --this.remainingBlanks;
            return 32;
        }
        --this.remainingNonBlanks;
        return this.alphabet.nextByte() & 0xFF;
    }

    @Override
    public int read(byte[] byArray, int n, int n2) {
        int n3;
        if (this.remainingBlanks <= 0L && this.remainingNonBlanks <= 0L) {
            return -1;
        }
        int n4 = (int)Math.min(this.remainingNonBlanks, (long)n2);
        this.fillBuffer(n4);
        int n5 = this.alphabet.nextByteToRead(0);
        if (n4 <= this.buffer.length - n5) {
            System.arraycopy(this.buffer, n5, byArray, n, n4);
            this.remainingNonBlanks -= (long)n4;
            n3 = n4;
            this.alphabet.nextByteToRead(n4);
        } else {
            int n6 = 0;
            for (n3 = 0; this.remainingNonBlanks > 0L && n3 < n4; n3 += n6) {
                n5 = this.alphabet.nextByteToRead(n6);
                n6 = Math.min(this.buffer.length - n5, n4 - n3);
                System.arraycopy(this.buffer, n5, byArray, n + n3, n6);
                this.remainingNonBlanks -= (long)n6;
            }
            n5 = this.alphabet.nextByteToRead(n6);
        }
        if (n3 < n2 && this.remainingBlanks > 0L) {
            n3 += this.fillBlanks(byArray, n + n3, n2 - n3);
        }
        return n3;
    }

    @Override
    public void reset() {
        this.remainingNonBlanks = this.length - (long)this.trailingBlanks;
        this.remainingBlanks = this.trailingBlanks;
        this.alphabet.reset();
    }

    @Override
    public int available() {
        return (int)(this.remainingNonBlanks + this.remainingBlanks);
    }

    private void fillBuffer(int n) {
        if (n > 32768) {
            n = 32768;
        }
        if (n <= this.buffer.length) {
            return;
        }
        int n2 = this.alphabet.nextByteToRead(0);
        this.alphabet.reset();
        this.buffer = new byte[n];
        for (int i = 0; i < n; ++i) {
            this.buffer[i] = this.alphabet.nextByte();
        }
        this.alphabet.reset();
        this.alphabet.nextByteToRead(n2);
    }

    private int fillBlanks(byte[] byArray, int n, int n2) {
        int n3;
        for (n3 = 0; n3 < n2 && this.remainingBlanks > 0L; ++n3) {
            byArray[n + n3] = 32;
            --this.remainingBlanks;
        }
        return n3;
    }

    public void resetStream() {
        this.reset();
    }

    public void initStream() {
        this.reset();
    }

    public void closeStream() {
    }
}

