/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derby.shared.common.error.StandardException;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;

public class T_Util {
    RawStoreFactory rsFactory;
    LockFactory lFactory;
    ContextService csFactory;
    private int openContainerMode;

    public T_Util(RawStoreFactory rawStoreFactory, LockFactory lockFactory, ContextService contextService) {
        this.rsFactory = rawStoreFactory;
        this.lFactory = lockFactory;
        this.csFactory = contextService;
        this.openContainerMode = 0;
    }

    public void setOpenMode(int n) {
        this.openContainerMode = n;
    }

    public void t_checkNullLockCount(Transaction transaction) throws T_Fail {
        if (this.lFactory.areLocksHeld(transaction.getCompatibilitySpace())) {
            throw T_Fail.testFailMsg("Previous action did not clean up all locks.");
        }
    }

    public static void t_checkPageNumber(Page page, long l) throws T_Fail {
        if (page.getPageNumber() != l) {
            throw T_Fail.testFailMsg("page number expected to be " + l + ", is " + page.getPageNumber());
        }
    }

    public static void t_checkRecordCount(Page page, int n, int n2) throws T_Fail, StandardException {
        if (page.recordCount() != n) {
            throw T_Fail.testFailMsg("recordCount() expected to be " + n + ", is " + page.recordCount());
        }
        if (page.nonDeletedRecordCount() != n2) {
            throw T_Fail.testFailMsg("nonDeletedRecordCount() expected to be " + n2 + ", is " + page.nonDeletedRecordCount());
        }
    }

    public static void t_checkFieldCount(Page page, int n, int n2) throws T_Fail, StandardException {
        if (page.fetchNumFieldsAtSlot(n) != n2) {
            throw T_Fail.testFailMsg("number of fields at slot " + n + " expected to be " + n2 + ", is " + page.fetchNumFieldsAtSlot(n));
        }
    }

    public static void t_checkFetch(Page page, RecordHandle recordHandle, String string, int n) throws T_Fail, StandardException {
        T_Util.t_checkFetch(page, recordHandle, T_Util.getStringFromData(string, n));
    }

    public static void t_checkFetch(Page page, RecordHandle recordHandle, String string) throws T_Fail, StandardException {
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        int n = page.getSlotNumber(recordHandle);
        RecordHandle recordHandle2 = page.fetchFromSlot(recordHandle, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (string == null || t_RawStoreRow.getStorableColumn(0).isNull()) {
            if (string == null && t_RawStoreRow.getStorableColumn(0).isNull()) {
                return;
            }
            throw T_Fail.testFailMsg("Record's value incorrect");
        }
        if (!t_RawStoreRow.toString().equals(string)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkFetch(ContainerHandle containerHandle, RecordHandle recordHandle, String string) throws T_Fail, StandardException {
        Page page = this.t_getPage(containerHandle, recordHandle.getPageNumber());
        try {
            T_Util.t_checkFetch(page, recordHandle, string);
        }
        finally {
            page.unlatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkFetchFail(ContainerHandle containerHandle, RecordHandle recordHandle) throws T_Fail, StandardException {
        Page page = this.t_getPage(containerHandle, recordHandle.getPageNumber());
        try {
            if (page.recordExists(recordHandle, true)) {
                throw T_Fail.testFailMsg("Record Exists");
            }
        }
        finally {
            page.unlatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkFetchDeleted(ContainerHandle containerHandle, RecordHandle recordHandle, String string) throws T_Fail, StandardException {
        Page page = this.t_getPage(containerHandle, recordHandle.getPageNumber());
        if (page == null) {
            throw T_Fail.testFailMsg("Page not found " + String.valueOf(recordHandle));
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        try {
            int n = page.getSlotNumber(recordHandle);
            if (page.fetchFromSlot(recordHandle, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false) != null) {
                throw T_Fail.testFailMsg("Record at slot " + n + " not deleted");
            }
        }
        finally {
            page.unlatch();
        }
    }

    public static void t_checkFetch(Page page, RecordHandle recordHandle, T_RawStoreRow t_RawStoreRow) throws T_Fail, StandardException {
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        int n = t_RawStoreRow.nColumns();
        T_RawStoreRow t_RawStoreRow2 = new T_RawStoreRow(n);
        for (int i = 0; i < n; ++i) {
            t_RawStoreRow2.setColumn(i, (String)null);
        }
        RecordHandle recordHandle2 = page.fetchFromSlot(recordHandle, page.getSlotNumber(recordHandle), (Object[])t_RawStoreRow2.getRow(), null, false);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!t_RawStoreRow2.toString().equals(t_RawStoreRow.toString())) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + t_RawStoreRow.toString() + ": - got :" + t_RawStoreRow2.toString());
        }
    }

    public static void t_checkFetchCol(Page page, RecordHandle recordHandle, int n, int n2, String string) throws T_Fail, StandardException {
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n2);
        for (int i = 0; i < n2; ++i) {
            t_RawStoreRow.setColumn(i, (String)null);
        }
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
        formatableBitSet.set(n);
        FetchDescriptor fetchDescriptor = new FetchDescriptor(n2, formatableBitSet, null);
        RecordHandle recordHandle2 = page.fetchFromSlot(recordHandle, page.getSlotNumber(recordHandle), (Object[])t_RawStoreRow.getRow(), fetchDescriptor, false);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        String string2 = t_RawStoreRow.getStorableColumn(n).toString();
        if (!string2.equals(string)) {
            throw T_Fail.testFailMsg("Record's value for column " + n + " incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
    }

    public static RecordHandle t_checkFetchFirst(Page page, String string) throws T_Fail, StandardException {
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        int n = 0;
        while (page.isDeletedAtSlot(n)) {
            ++n;
        }
        RecordHandle recordHandle = page.fetchFromSlot((RecordHandle)null, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!t_RawStoreRow.toString().equals(string)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
        return recordHandle;
    }

    public static RecordHandle t_checkFetchNext(Page page, RecordHandle recordHandle, String string) throws T_Fail, StandardException {
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        int n = page.getSlotNumber(recordHandle) + 1;
        while (page.isDeletedAtSlot(n)) {
            ++n;
        }
        RecordHandle recordHandle2 = page.fetchFromSlot((RecordHandle)null, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!t_RawStoreRow.toString().equals(string)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
        return recordHandle2;
    }

    public static RecordHandle t_checkFetchPrevious(Page page, RecordHandle recordHandle, String string) throws T_Fail, StandardException {
        int n;
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        for (n = page.getSlotNumber(recordHandle) - 1; page.isDeletedAtSlot(n) && n >= 0; --n) {
        }
        if (n == -1) {
            return null;
        }
        RecordHandle recordHandle2 = page.fetchFromSlot((RecordHandle)null, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
        if (recordHandle2 == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!t_RawStoreRow.toString().equals(string)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
        return recordHandle2;
    }

    public static RecordHandle t_checkFetchLast(Page page, String string) throws T_Fail, StandardException {
        int n;
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        for (n = page.recordCount() - 1; page.isDeletedAtSlot(n) && n >= 0; --n) {
        }
        if (n == -1) {
            return null;
        }
        RecordHandle recordHandle = page.fetchFromSlot((RecordHandle)null, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, false);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!t_RawStoreRow.toString().equals(string)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
        return recordHandle;
    }

    public static void t_checkFetchBySlot(Page page, int n, String string, boolean bl, boolean bl2) throws T_Fail, StandardException {
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        RecordHandle recordHandle = page.fetchFromSlot((RecordHandle)null, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, true);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!t_RawStoreRow.toString().equals(string)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + string + ": - got :" + t_RawStoreRow.toString());
        }
        if (page.isDeletedAtSlot(n) != bl) {
            throw T_Fail.testFailMsg("Record at slot " + n + " deleted=" + page.isDeletedAtSlot(n) + ", expect " + bl);
        }
    }

    public static void t_checkFetchColFromSlot(Page page, int n, int n2, DataValueDescriptor dataValueDescriptor, boolean bl, String string, int n3) throws StandardException, T_Fail {
        T_Util.t_checkFetchColFromSlot(page, n, n2, dataValueDescriptor, bl, T_Util.getStringFromData(string, n3));
    }

    public static void t_checkFetchColFromSlot(Page page, int n, int n2, DataValueDescriptor dataValueDescriptor, boolean bl, String string) throws StandardException, T_Fail {
        Object[] objectArray = new DataValueDescriptor[n2 + 1];
        objectArray[n2] = dataValueDescriptor;
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2 + 1);
        formatableBitSet.set(n2);
        RecordHandle recordHandle = page.fetchFromSlot(null, n, objectArray, new FetchDescriptor(objectArray.length, formatableBitSet, (Qualifier[][])null), true);
        if (recordHandle == null) {
            throw T_Fail.testFailMsg("Failed to fetch record: slot " + n + " field " + n2);
        }
        if (string == null) {
            if (!dataValueDescriptor.isNull()) {
                throw T_Fail.testFailMsg("Failed to fetch null column: slot " + n + " field " + n2 + " column is " + String.valueOf(dataValueDescriptor));
            }
        } else {
            if (dataValueDescriptor.isNull()) {
                throw T_Fail.testFailMsg("expect non null column, got null: slot " + n + " field " + n2);
            }
            if (!dataValueDescriptor.toString().equals(string)) {
                throw T_Fail.testFailMsg("expect " + string + " got " + dataValueDescriptor.toString() + ": slot " + n + " field " + n2);
            }
        }
    }

    public static void t_checkEmptyPage(Page page) throws T_Fail, StandardException {
        T_Util.t_checkRecordCount(page, 0, 0);
        try {
            page.fetchFromSlot((RecordHandle)null, 0, null, (FetchDescriptor)null, false);
            throw T_Fail.testFailMsg("fetchFromSlot() must throw exception on fetch from slot 0 on an empty page");
        }
        catch (StandardException standardException) {
            if (page.getRecordHandle(0) != null) {
                throw T_Fail.testFailMsg("obtained a RecordHandle for an empty page");
            }
            if (page.getRecordHandle(6) != null) {
                throw T_Fail.testFailMsg("obtained a RecordHandle for an empty page");
            }
            if (page.getAuxObject() != null) {
                throw T_Fail.testFailMsg("empty page has an aux object");
            }
            T_Util.t_readOnlySlotOutOfRange(page, 0);
            if (!page.spaceForInsert()) {
                throw T_Fail.testFailMsg("spaceForInsert() returned false on an empty page");
            }
            return;
        }
    }

    public static void t_readOnlySlotOutOfRange(Page page, int n) throws T_Fail, StandardException {
        try {
            page.fetchFromSlot((RecordHandle)null, n, (Object[])new DataValueDescriptor[0], (FetchDescriptor)null, true);
            throw T_Fail.testFailMsg("fetchFromSlot succeeded on out of range slot " + n);
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() > 20000) {
                throw standardException;
            }
            try {
                page.isDeletedAtSlot(n);
                throw T_Fail.testFailMsg("isDeletedAtSlot succeeded on out of range slot " + n);
            }
            catch (StandardException standardException2) {
                if (standardException2.getSeverity() > 20000) {
                    throw standardException2;
                }
                return;
            }
        }
    }

    public static void t_updateSlotOutOfRange(Page page, int n) throws T_Fail, StandardException {
        try {
            page.deleteAtSlot(n, false, (LogicalUndo)null);
            throw T_Fail.testFailMsg("deleteAtSlot succeeded on out of range slot " + n);
        }
        catch (StandardException standardException) {
            if (standardException.getSeverity() > 20000) {
                throw standardException;
            }
            try {
                page.deleteAtSlot(n, true, (LogicalUndo)null);
                throw T_Fail.testFailMsg("deleteAtSlot succeeded on out of range slot " + n);
            }
            catch (StandardException standardException2) {
                T_RawStoreRow t_RawStoreRow;
                block12: {
                    if (standardException2.getSeverity() > 20000) {
                        throw standardException2;
                    }
                    t_RawStoreRow = new T_RawStoreRow(null);
                    if (page.recordCount() != n) {
                        try {
                            page.insertAtSlot(n, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, (LogicalUndo)null, (byte)1, 100);
                            throw T_Fail.testFailMsg("insertAtSlot succeeded, on out of range slot " + n);
                        }
                        catch (StandardException standardException3) {
                            if (standardException3.getSeverity() <= 20000) break block12;
                            throw standardException3;
                        }
                    }
                }
                try {
                    page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null);
                    throw T_Fail.testFailMsg("updateAtSlot succeeded on out of range slot " + n);
                }
                catch (StandardException standardException4) {
                    if (standardException4.getSeverity() > 20000) {
                        throw standardException4;
                    }
                    return;
                }
            }
        }
    }

    public static void t_checkInvalidSavePoint(Transaction transaction, String string) throws T_Fail, StandardException {
        try {
            transaction.rollbackToSavePoint(string, null);
            throw T_Fail.testFailMsg("non existent save point did not cause exception on rollbackToSavePoint");
        }
        catch (StandardException standardException) {
            try {
                transaction.releaseSavePoint(string, null);
                throw T_Fail.testFailMsg("non existent save point did not cause exception on releaseSavePoint");
            }
            catch (StandardException standardException2) {
                return;
            }
        }
    }

    public void t_checkInvalidSavePoint(T_TWC t_TWC, String string) throws T_Fail, StandardException {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            T_Util.t_checkInvalidSavePoint(t_TWC.tran, string);
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public Transaction t_startTransaction() throws StandardException, T_Fail {
        Transaction transaction = this.rsFactory.startTransaction(this.csFactory.getCurrentContextManager(), "UserTransaction");
        if (transaction == null) {
            throw T_Fail.testFailMsg("Start a transaction");
        }
        this.t_checkNullLockCount(transaction);
        return transaction;
    }

    public Transaction t_startGlobalTransaction(int n, byte[] byArray, byte[] byArray2) throws StandardException, T_Fail {
        Transaction transaction = this.rsFactory.startGlobalTransaction(this.csFactory.getCurrentContextManager(), n, byArray, byArray2);
        if (transaction == null) {
            throw T_Fail.testFailMsg("Start a transaction");
        }
        this.t_checkNullLockCount(transaction);
        return transaction;
    }

    public T_TWC t_startTransactionWithContext() throws StandardException, T_Fail {
        T_TWC t_TWC = new T_TWC(this.csFactory, this.lFactory, this.rsFactory);
        t_TWC.startUserTransaction();
        return t_TWC;
    }

    public Transaction t_startInternalTransaction() throws StandardException, T_Fail {
        Transaction transaction = this.rsFactory.startInternalTransaction(this.csFactory.getCurrentContextManager());
        if (transaction == null) {
            throw T_Fail.testFailMsg("Failed to start an internal transaction");
        }
        this.t_checkNullLockCount(transaction);
        return transaction;
    }

    public void t_commit(Transaction transaction) throws StandardException, T_Fail {
        transaction.commit();
        this.t_checkNullLockCount(transaction);
    }

    public void t_commit(T_TWC t_TWC) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            this.t_commit(t_TWC.tran);
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public void t_close(T_TWC t_TWC) throws StandardException, T_Fail {
        t_TWC.tran.close();
        t_TWC.tran = null;
        t_TWC.cm = null;
    }

    public void t_abort(Transaction transaction) throws StandardException, T_Fail {
        transaction.abort();
        this.t_checkNullLockCount(transaction);
    }

    public void t_abort(T_TWC t_TWC) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            this.t_abort(t_TWC.tran);
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public long t_addContainer(Transaction transaction, long l) throws StandardException, T_Fail {
        long l2 = transaction.addContainer(l, 0L, 0, (Properties)null, 0);
        if (l2 < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long t_addContainer(T_TWC t_TWC, long l) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            long l2 = this.t_addContainer(t_TWC.tran, l);
            return l2;
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public long t_addContainer(Transaction transaction, long l, int n) throws StandardException, T_Fail {
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", Integer.toString(n));
        long l2 = transaction.addContainer(l, 0L, 0, properties, 0);
        if (l2 < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long t_addContainer(T_TWC t_TWC, long l, int n) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            long l2 = this.t_addContainer(t_TWC.tran, l, n);
            return l2;
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public long t_addContainer(Transaction transaction, long l, Properties properties) throws StandardException, T_Fail {
        long l2 = transaction.addContainer(l, 0L, 0, properties, 0);
        if (l2 < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return l2;
    }

    public long t_addContainer(Transaction transaction, long l, int n, int n2, int n3, boolean bl) throws StandardException, T_Fail {
        long l2;
        Properties properties = new Properties();
        properties.put("derby.storage.pageSize", Integer.toString(n));
        properties.put("derby.storage.pageReservedSpace", Integer.toString(n2));
        properties.put("derby.storage.minimumRecordSize", Integer.toString(n3));
        if (bl) {
            properties.put("derby.storage.reusableRecordId", "true");
        }
        if ((l2 = transaction.addContainer(l, 0L, 0, properties, 0)) < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long t_addContainer(T_TWC t_TWC, long l, int n, int n2, int n3) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            long l2 = this.t_addContainer(t_TWC.tran, l, n, n2, n3, false);
            return l2;
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public ContainerHandle t_openContainer(Transaction transaction, long l, long l2, boolean bl) throws StandardException, T_Fail {
        ContainerKey containerKey = new ContainerKey(l, l2);
        ContainerHandle containerHandle = transaction.openContainer(containerKey, bl ? 4 | this.openContainerMode : 8);
        if (containerHandle == null) {
            throw T_Fail.testFailMsg("ContainerHandle failed to open: (" + l + "," + l2 + ")");
        }
        return containerHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerHandle t_openContainer(T_TWC t_TWC, long l, long l2, boolean bl) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(t_TWC.cm);
        try {
            ContainerHandle containerHandle = this.t_openContainer(t_TWC.tran, l, l2, bl);
            return containerHandle;
        }
        finally {
            this.csFactory.resetCurrentContextManager(t_TWC.cm);
        }
    }

    public void t_dropContainer(Transaction transaction, long l, long l2) throws StandardException, T_Fail {
        transaction.dropContainer(new ContainerKey(l, l2));
    }

    public Page t_getLastPage(ContainerHandle containerHandle) throws T_Fail, StandardException {
        Page page = containerHandle.getFirstPage();
        if (page != null) {
            Page page2;
            while ((page2 = containerHandle.getNextPage(page.getPageNumber())) != null) {
                page.unlatch();
                page = page2;
            }
        }
        return page;
    }

    public Page t_getPage(ContainerHandle containerHandle, long l) throws T_Fail, StandardException {
        Page page = containerHandle.getPage(l);
        if (page == null) {
            throw T_Fail.testFailMsg("fail to get page " + l + " from container " + String.valueOf(containerHandle));
        }
        if (page.getPageNumber() != l) {
            throw T_Fail.testFailMsg("page expected to have page number " + l + ", has " + page.getPageNumber() + " Container " + String.valueOf(containerHandle));
        }
        return page;
    }

    public Page t_addPage(ContainerHandle containerHandle) throws T_Fail, StandardException {
        Page page = containerHandle.addPage();
        if (page == null) {
            throw T_Fail.testFailMsg("addPage() returned null");
        }
        return page;
    }

    public void t_removePage(ContainerHandle containerHandle, Page page) throws T_Fail, StandardException {
        long l = page.getPageNumber();
        containerHandle.removePage(page);
        Page page2 = containerHandle.getPage(l);
        if (page2 != null) {
            throw T_Fail.testFailMsg("got a deallcated page back");
        }
    }

    public void t_checkGetLatchedPage(ContainerHandle containerHandle, long l) throws StandardException, T_Fail {
        try {
            Page page = containerHandle.getPage(l);
            throw T_Fail.testFailMsg("got latched page");
        }
        catch (StandardException standardException) {
            if (!"XSDAO".equals(standardException.getSQLState())) {
                throw standardException;
            }
            return;
        }
    }

    public static RecordHandle t_insert(Page page, T_RawStoreRow t_RawStoreRow) throws T_Fail, StandardException {
        RecordHandle recordHandle = page.insert((Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, (byte)1, 100);
        return recordHandle;
    }

    public static RecordHandle t_insertAtSlot(Page page, int n, T_RawStoreRow t_RawStoreRow) throws T_Fail, StandardException {
        RecordHandle recordHandle = page.insertAtSlot(n, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, (LogicalUndo)null, (byte)1, 100);
        return recordHandle;
    }

    public static RecordHandle t_insertAtSlot(Page page, int n, T_RawStoreRow t_RawStoreRow, byte by) throws T_Fail, StandardException {
        RecordHandle recordHandle = page.insertAtSlot(n, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, (LogicalUndo)null, by, 100);
        return recordHandle;
    }

    public static RecordHandle t_insertAtSlot(Page page, int n, T_RawStoreRow t_RawStoreRow, byte by, int n2) throws T_Fail, StandardException {
        RecordHandle recordHandle = page.insertAtSlot(n, (Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, (LogicalUndo)null, by, n2);
        return recordHandle;
    }

    public RecordHandle t_insert(ContainerHandle containerHandle, T_RawStoreRow t_RawStoreRow) throws T_Fail, StandardException {
        Page page = containerHandle.getPageForInsert(0);
        boolean bl = false;
        if (page == null) {
            page = this.t_addPage(containerHandle);
            bl = true;
        } else if (!page.spaceForInsert((Object[])t_RawStoreRow.getRow(), (FormatableBitSet)null, 100)) {
            page.unlatch();
            page = this.t_addPage(containerHandle);
            bl = true;
        }
        RecordHandle recordHandle = T_Util.t_insert(page, t_RawStoreRow);
        page.unlatch();
        if (recordHandle == null) {
            if (bl) {
                throw T_Fail.testFailMsg("insert returned null on an empty page");
            }
            page = this.t_addPage(containerHandle);
            recordHandle = T_Util.t_insert(page, t_RawStoreRow);
            page.unlatch();
        }
        return recordHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_update(ContainerHandle containerHandle, RecordHandle recordHandle, T_RawStoreRow t_RawStoreRow) throws T_Fail, StandardException {
        Page page = this.t_getPage(containerHandle, recordHandle.getPageNumber());
        try {
            int n = page.getSlotNumber(recordHandle);
            if (page.updateAtSlot(n, (Object[])t_RawStoreRow.getRow(), null) == null) {
                throw T_Fail.testFailMsg("update failed");
            }
            T_Util.t_checkFetch(page, recordHandle, t_RawStoreRow);
        }
        finally {
            page.unlatch();
        }
    }

    public void t_checkUpdateCol(Page page, RecordHandle recordHandle, int n, int n2, String string) throws T_Fail, StandardException {
        if (!page.recordExists(recordHandle, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(n2);
        for (int i = 0; i < n2; ++i) {
            t_RawStoreRow.setColumn(i, (String)null);
        }
        t_RawStoreRow.setColumn(n, string);
        FormatableBitSet formatableBitSet = new FormatableBitSet(n2);
        formatableBitSet.set(n);
        int n3 = page.getSlotNumber(recordHandle);
        if (page.updateAtSlot(n3, (Object[])t_RawStoreRow.getRow(), formatableBitSet) == null) {
            throw T_Fail.testFailMsg("update failed");
        }
        T_Util.t_checkFetchCol(page, recordHandle, n, n2, string);
    }

    public void t_checkStringLengthFetch(Page page, int n, int n2) throws T_Fail, StandardException {
        T_RawStoreRow t_RawStoreRow = new T_RawStoreRow(null);
        page.fetchFromSlot((RecordHandle)null, n, (Object[])t_RawStoreRow.getRow(), (FetchDescriptor)null, true);
        String string = ((SQLChar)t_RawStoreRow.getStorableColumn(0)).getString();
        if (string == null && n2 < 0) {
            return;
        }
        if (string != null && n2 < 0) {
            throw T_Fail.testFailMsg("Expected null string, fetched one of length " + string.length());
        }
        if (string == null) {
            throw T_Fail.testFailMsg("Expected string length " + n2 + " got null string");
        }
        if (string.length() != n2) {
            throw T_Fail.testFailMsg("fetch string length incorrect expected " + n2 + " got " + string.length());
        }
    }

    public void t_genRandomFile(String string, String string2, int n) throws T_Fail {
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, string2);
            for (int i = 0; i < n; ++i) {
                byte by = (byte)(i & 0xFF);
                by = (byte)(by >= 32 && by <= 126 ? (int)by : 32);
                randomAccessFile.write(by);
            }
            randomAccessFile.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw T_Fail.testFailMsg("cannot create new file");
        }
        catch (IOException iOException) {
            throw T_Fail.testFailMsg("io error, test failed");
        }
    }

    public static String getStringFromData(String string, int n) {
        char[] cArray = new char[n];
        char[] cArray2 = string.toCharArray();
        System.arraycopy(cArray2, 0, cArray, 0, cArray2.length);
        return new String(cArray);
    }

    public static void t_wait(int n) {
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Properties setEncryptionParam(Properties properties) {
        String string = PropertyUtil.getSystemProperty((String)"testDataEncryption");
        String string2 = PropertyUtil.getSystemProperty((String)"testEncryptionProvider");
        if (string != null) {
            if (properties == null) {
                properties = new Properties();
            }
            properties.put("dataEncryption", "true");
            properties.put("bootPassword", string);
            if (string2 != null) {
                properties.put("encryptionProvider", string2);
            }
        }
        return properties;
    }
}

