/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.SecurityCheck;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;

public class ResultSetMiscTest
extends BaseJDBCTestCase {
    private final Object nogc = SecurityCheck.class;

    public ResultSetMiscTest(String name) {
        super(name);
    }

    public void testResultSetMetaData() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select i, s, r, d, dt, t, ts, c, v, dc, bi, cbd, vbd, lvbd, cl, bl from t");
        ResultSetMetaData met = rs.getMetaData();
        rs = stmt.executeQuery("select i, s, r, d, dt, t, ts, c, v, dc, bi, cbd, vbd, lvbd, cl, bl from t");
        met = rs.getMetaData();
        int colCount = met.getColumnCount();
        ResultSetMiscTest.assertEquals((int)16, (int)colCount);
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(1));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(1));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(1));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(1));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(1));
        ResultSetMiscTest.assertTrue((boolean)met.isSigned(1));
        ResultSetMiscTest.assertEquals((int)11, (int)met.getColumnDisplaySize(1));
        ResultSetMiscTest.assertEquals((String)"I", (String)met.getColumnLabel(1));
        ResultSetMiscTest.assertEquals((String)"I", (String)met.getColumnName(1));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(1));
        ResultSetMiscTest.assertEquals((int)4, (int)met.getColumnType(1));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getPrecision(1));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(1));
        ResultSetMiscTest.assertEquals((String)"INTEGER", (String)met.getColumnTypeName(1));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(1));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(1));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(1));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(2));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(2));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(2));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(2));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(2));
        ResultSetMiscTest.assertTrue((boolean)met.isSigned(2));
        ResultSetMiscTest.assertEquals((int)6, (int)met.getColumnDisplaySize(2));
        ResultSetMiscTest.assertEquals((String)"S", (String)met.getColumnLabel(2));
        ResultSetMiscTest.assertEquals((String)"S", (String)met.getColumnName(2));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(2));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(2));
        ResultSetMiscTest.assertEquals((int)5, (int)met.getColumnType(2));
        ResultSetMiscTest.assertEquals((int)5, (int)met.getPrecision(2));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(2));
        ResultSetMiscTest.assertEquals((String)"SMALLINT", (String)met.getColumnTypeName(2));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(2));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(2));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(2));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(3));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(3));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(3));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(3));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(3));
        ResultSetMiscTest.assertTrue((boolean)met.isSigned(3));
        ResultSetMiscTest.assertEquals((int)15, (int)met.getColumnDisplaySize(3));
        ResultSetMiscTest.assertEquals((String)"R", (String)met.getColumnLabel(3));
        ResultSetMiscTest.assertEquals((String)"R", (String)met.getColumnName(3));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(3));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(3));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(3));
        ResultSetMiscTest.assertEquals((int)7, (int)met.getColumnType(3));
        ResultSetMiscTest.assertEquals((int)7, (int)met.getPrecision(3));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(3));
        ResultSetMiscTest.assertEquals((String)"REAL", (String)met.getColumnTypeName(3));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(3));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(3));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(3));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(4));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(4));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(4));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(4));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(4));
        ResultSetMiscTest.assertTrue((boolean)met.isSigned(4));
        ResultSetMiscTest.assertEquals((int)24, (int)met.getColumnDisplaySize(4));
        ResultSetMiscTest.assertEquals((String)"D", (String)met.getColumnLabel(4));
        ResultSetMiscTest.assertEquals((String)"D", (String)met.getColumnName(4));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(4));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(4));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(4));
        ResultSetMiscTest.assertEquals((int)8, (int)met.getColumnType(4));
        ResultSetMiscTest.assertEquals((int)15, (int)met.getPrecision(4));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(4));
        ResultSetMiscTest.assertEquals((String)"DOUBLE", (String)met.getColumnTypeName(4));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(4));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(4));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(4));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(5));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(5));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(5));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(5));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(5));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(5));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getColumnDisplaySize(5));
        ResultSetMiscTest.assertEquals((String)"DT", (String)met.getColumnLabel(5));
        ResultSetMiscTest.assertEquals((String)"DT", (String)met.getColumnName(5));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(5));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(5));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(5));
        ResultSetMiscTest.assertEquals((int)91, (int)met.getColumnType(5));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getPrecision(5));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(5));
        ResultSetMiscTest.assertEquals((String)"DATE", (String)met.getColumnTypeName(5));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(1));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(1));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(1));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(7));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(7));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(7));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(7));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(7));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(7));
        ResultSetMiscTest.assertEquals((int)29, (int)met.getColumnDisplaySize(7));
        ResultSetMiscTest.assertEquals((String)"TS", (String)met.getColumnLabel(7));
        ResultSetMiscTest.assertEquals((String)"TS", (String)met.getColumnName(7));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(7));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(7));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(7));
        ResultSetMiscTest.assertEquals((int)93, (int)met.getColumnType(7));
        ResultSetMiscTest.assertEquals((int)29, (int)met.getPrecision(7));
        ResultSetMiscTest.assertEquals((int)9, (int)met.getScale(7));
        ResultSetMiscTest.assertEquals((String)"TIMESTAMP", (String)met.getColumnTypeName(7));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(7));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(7));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(7));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(8));
        ResultSetMiscTest.assertTrue((boolean)met.isCaseSensitive(8));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(8));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(8));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(8));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(8));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getColumnDisplaySize(8));
        ResultSetMiscTest.assertEquals((String)"C", (String)met.getColumnLabel(8));
        ResultSetMiscTest.assertEquals((String)"C", (String)met.getColumnName(8));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(8));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(8));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(8));
        ResultSetMiscTest.assertEquals((int)1, (int)met.getColumnType(8));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getPrecision(8));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(8));
        ResultSetMiscTest.assertEquals((String)"CHAR", (String)met.getColumnTypeName(8));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(8));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(8));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(8));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(9));
        ResultSetMiscTest.assertTrue((boolean)met.isCaseSensitive(9));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(9));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(9));
        ResultSetMiscTest.assertEquals((int)0, (int)met.isNullable(9));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(9));
        ResultSetMiscTest.assertEquals((int)40, (int)met.getColumnDisplaySize(9));
        ResultSetMiscTest.assertEquals((String)"V", (String)met.getColumnLabel(9));
        ResultSetMiscTest.assertEquals((String)"V", (String)met.getColumnName(9));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(9));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(9));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(9));
        ResultSetMiscTest.assertEquals((int)12, (int)met.getColumnType(9));
        ResultSetMiscTest.assertEquals((int)40, (int)met.getPrecision(9));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(9));
        ResultSetMiscTest.assertEquals((String)"VARCHAR", (String)met.getColumnTypeName(9));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(9));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(9));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(9));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(10));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(10));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(10));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(10));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(10));
        ResultSetMiscTest.assertTrue((boolean)met.isSigned(10));
        ResultSetMiscTest.assertEquals((int)12, (int)met.getColumnDisplaySize(10));
        ResultSetMiscTest.assertEquals((String)"DC", (String)met.getColumnLabel(10));
        ResultSetMiscTest.assertEquals((String)"DC", (String)met.getColumnName(10));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(10));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(10));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(10));
        ResultSetMiscTest.assertEquals((int)3, (int)met.getColumnType(10));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getPrecision(10));
        ResultSetMiscTest.assertEquals((int)2, (int)met.getScale(10));
        ResultSetMiscTest.assertEquals((String)"DECIMAL", (String)met.getColumnTypeName(10));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(10));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(10));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(10));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(11));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(11));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(11));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(11));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(11));
        ResultSetMiscTest.assertTrue((boolean)met.isSigned(11));
        ResultSetMiscTest.assertEquals((int)20, (int)met.getColumnDisplaySize(11));
        ResultSetMiscTest.assertEquals((String)"BI", (String)met.getColumnLabel(11));
        ResultSetMiscTest.assertEquals((String)"BI", (String)met.getColumnName(11));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(11));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(11));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(11));
        ResultSetMiscTest.assertEquals((int)-5, (int)met.getColumnType(11));
        ResultSetMiscTest.assertEquals((int)19, (int)met.getPrecision(11));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(11));
        ResultSetMiscTest.assertEquals((String)"BIGINT", (String)met.getColumnTypeName(11));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(11));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(11));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(11));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(12));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(12));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(12));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(12));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(12));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(12));
        ResultSetMiscTest.assertEquals((int)20, (int)met.getColumnDisplaySize(12));
        ResultSetMiscTest.assertEquals((String)"CBD", (String)met.getColumnLabel(12));
        ResultSetMiscTest.assertEquals((String)"CBD", (String)met.getColumnName(12));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(12));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(12));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(12));
        ResultSetMiscTest.assertEquals((int)-2, (int)met.getColumnType(12));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getPrecision(12));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(12));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertEquals((String)"CHAR () FOR BIT DATA", (String)met.getColumnTypeName(12));
        } else {
            ResultSetMiscTest.assertEquals((String)"CHAR FOR BIT DATA", (String)met.getColumnTypeName(12));
        }
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(12));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(12));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(12));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(13));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(13));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(13));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(13));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(13));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(13));
        ResultSetMiscTest.assertEquals((int)20, (int)met.getColumnDisplaySize(13));
        ResultSetMiscTest.assertEquals((String)"VBD", (String)met.getColumnLabel(13));
        ResultSetMiscTest.assertEquals((String)"VBD", (String)met.getColumnName(13));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(13));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(13));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(13));
        ResultSetMiscTest.assertEquals((int)-3, (int)met.getColumnType(13));
        ResultSetMiscTest.assertEquals((int)10, (int)met.getPrecision(13));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(13));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertEquals((String)"VARCHAR () FOR BIT DATA", (String)met.getColumnTypeName(13));
        } else {
            ResultSetMiscTest.assertEquals((String)"VARCHAR FOR BIT DATA", (String)met.getColumnTypeName(13));
        }
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(13));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(13));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(13));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(14));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(14));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(14));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(14));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(14));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(14));
        ResultSetMiscTest.assertEquals((int)65400, (int)met.getColumnDisplaySize(14));
        ResultSetMiscTest.assertEquals((String)"LVBD", (String)met.getColumnLabel(14));
        ResultSetMiscTest.assertEquals((String)"LVBD", (String)met.getColumnName(14));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(14));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(14));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(14));
        ResultSetMiscTest.assertEquals((int)-4, (int)met.getColumnType(14));
        ResultSetMiscTest.assertEquals((int)32700, (int)met.getPrecision(14));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(14));
        ResultSetMiscTest.assertEquals((String)"LONG VARCHAR FOR BIT DATA", (String)met.getColumnTypeName(14));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(14));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(14));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(14));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(15));
        ResultSetMiscTest.assertTrue((boolean)met.isCaseSensitive(15));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(15));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(15));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(15));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(15));
        ResultSetMiscTest.assertEquals((int)Integer.MAX_VALUE, (int)met.getColumnDisplaySize(15));
        ResultSetMiscTest.assertEquals((String)"CL", (String)met.getColumnLabel(15));
        ResultSetMiscTest.assertEquals((String)"CL", (String)met.getColumnName(15));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(15));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(15));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(15));
        ResultSetMiscTest.assertEquals((int)2005, (int)met.getColumnType(15));
        ResultSetMiscTest.assertEquals((int)Integer.MAX_VALUE, (int)met.getPrecision(15));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(15));
        ResultSetMiscTest.assertEquals((String)"CLOB", (String)met.getColumnTypeName(15));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(15));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(15));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(15));
        ResultSetMiscTest.assertFalse((boolean)met.isAutoIncrement(16));
        ResultSetMiscTest.assertFalse((boolean)met.isCaseSensitive(16));
        ResultSetMiscTest.assertTrue((boolean)met.isSearchable(16));
        ResultSetMiscTest.assertFalse((boolean)met.isCurrency(16));
        ResultSetMiscTest.assertEquals((int)1, (int)met.isNullable(16));
        ResultSetMiscTest.assertFalse((boolean)met.isSigned(16));
        ResultSetMiscTest.assertEquals((int)Integer.MAX_VALUE, (int)met.getColumnDisplaySize(16));
        ResultSetMiscTest.assertEquals((String)"BL", (String)met.getColumnLabel(16));
        ResultSetMiscTest.assertEquals((String)"BL", (String)met.getColumnName(16));
        ResultSetMiscTest.assertEquals((String)"T", (String)met.getTableName(16));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(16));
        ResultSetMiscTest.assertEquals((String)"", (String)met.getCatalogName(16));
        ResultSetMiscTest.assertEquals((int)2004, (int)met.getColumnType(16));
        ResultSetMiscTest.assertEquals((int)0x40000000, (int)met.getPrecision(16));
        ResultSetMiscTest.assertEquals((int)0, (int)met.getScale(16));
        ResultSetMiscTest.assertEquals((String)"BLOB", (String)met.getColumnTypeName(16));
        if (ResultSetMiscTest.usingEmbedded()) {
            ResultSetMiscTest.assertFalse((boolean)met.isReadOnly(16));
        }
        ResultSetMiscTest.assertFalse((boolean)met.isWritable(16));
        ResultSetMiscTest.assertFalse((boolean)met.isDefinitelyWritable(16));
    }

    public void testBug4810() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("create table bug4810(i int, b int)");
        stmt.executeUpdate("insert into bug4810 values (1,1), (1,2), (1,3), (1,4)");
        stmt.executeUpdate("insert into bug4810 values (1,1), (1,2), (1,3), (1,4)");
        con.commit();
        con.setAutoCommit(true);
        con.setTransactionIsolation(4);
        this.checkLocksForAutoCommitSelect(con, stmt, 0);
        this.checkLocksForAutoCommitSelect(con, stmt, 1);
        this.checkLocksForAutoCommitSelect(con, stmt, 2);
        stmt.execute("drop table bug4810");
        con.commit();
        stmt.close();
    }

    public void testDerby853() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.executeUpdate("create table derby853(d1 decimal(10,2), d2 double)");
        ResultSet rs = stmt.executeQuery("select d1 - d2 from derby853");
        ResultSetMetaData rsmd = rs.getMetaData();
        ResultSetMiscTest.assertEquals((int)0, (int)rsmd.getScale(1));
        ResultSetMiscTest.assertEquals((int)15, (int)rsmd.getPrecision(1));
        rs = stmt.executeQuery("select d2 - d1 from derby853");
        rsmd = rs.getMetaData();
        ResultSetMiscTest.assertEquals((int)0, (int)rsmd.getScale(1));
        ResultSetMiscTest.assertEquals((int)15, (int)rsmd.getPrecision(1));
        stmt.execute("drop table derby853");
        stmt.close();
    }

    public void testAutoCommit() throws SQLException {
        Connection conn = this.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("create table AutoCommitTable (num int)");
        s.executeUpdate("insert into AutoCommitTable values (1)");
        s.executeUpdate("insert into AutoCommitTable values (2)");
        int isolation = conn.getTransactionIsolation();
        conn.setTransactionIsolation(8);
        this.checkSingleRSAutoCommit(conn);
        this.checkSingleRSCloseCursorsAtCommit(conn);
        conn.setTransactionIsolation(isolation);
        s.executeUpdate("drop table AutoCommitTable");
        s.close();
    }

    public void testCorrelationNamesAndMetaDataCalls() throws SQLException {
        Connection conn = this.getConnection();
        Statement stmt = conn.createStatement();
        stmt.executeUpdate("create table s (a int, b int, c int, d int, e int, f int)");
        stmt.executeUpdate("insert into s values (0,1,2,3,4,5)");
        stmt.executeUpdate("insert into s values (10,11,12,13,14,15)");
        ResultSet rs = stmt.executeQuery("select * from s ss (f, e, d, c, b, a) where f = 0");
        rs.next();
        ResultSetMetaData met = rs.getMetaData();
        ResultSetMiscTest.assertEquals((String)"S", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(1));
        rs = stmt.executeQuery("select * from (select * from s) a");
        rs.next();
        met = rs.getMetaData();
        ResultSetMiscTest.assertEquals((String)"S", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(1));
        stmt.executeUpdate("create schema s1");
        stmt.executeUpdate("create table s1.t1 (c11 int, c12 int)");
        stmt.executeUpdate("insert into s1.t1 values (11, 12), (21, 22)");
        rs = stmt.executeQuery("select * from s1.t1 as abc");
        met = rs.getMetaData();
        ResultSetMiscTest.assertEquals((String)"T1", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"S1", (String)met.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"T1", (String)met.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"S1", (String)met.getSchemaName(2));
        rs = stmt.executeQuery("select abc.c11 from s1.t1 as abc");
        met = rs.getMetaData();
        ResultSetMiscTest.assertEquals((String)"T1", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"S1", (String)met.getSchemaName(1));
        rs = stmt.executeQuery("select bcd.a, abc.c11 from s1.t1 as abc, s as bcd");
        met = rs.getMetaData();
        ResultSetMiscTest.assertEquals((String)"S", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP", (String)met.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"T1", (String)met.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"S1", (String)met.getSchemaName(2));
        stmt.executeUpdate("create schema app1");
        stmt.executeUpdate("create table app1.t1 (c11 int, c12 int)");
        stmt.executeUpdate("insert into app1.t1 values (11, 12), (21, 22)");
        stmt.executeUpdate("create schema app2");
        stmt.executeUpdate("create table app2.t1 (c11 int, c12 int)");
        stmt.executeUpdate("insert into app2.t1 values (11, 12), (21, 22)");
        rs = stmt.executeQuery("select app1.t1.c11, app2.t1.c11 from app1.t1, app2.t1");
        met = rs.getMetaData();
        ResultSetMiscTest.assertEquals((String)"T1", (String)met.getTableName(1));
        ResultSetMiscTest.assertEquals((String)"APP1", (String)met.getSchemaName(1));
        ResultSetMiscTest.assertEquals((String)"T1", (String)met.getTableName(2));
        ResultSetMiscTest.assertEquals((String)"APP2", (String)met.getSchemaName(2));
        stmt.execute("drop table s");
        stmt.execute("drop table s1.t1");
        stmt.execute("drop schema s1 restrict");
        stmt.execute("drop table app1.t1");
        stmt.execute("drop table app2.t1");
        stmt.execute("drop schema app2 restrict");
        stmt.execute("drop schema app1 restrict");
    }

    public void testFloatMAX_VALUE(Connection conn) throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.execute("drop table jira1136");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        stmt.execute("create table jira1136 (f float)");
        stmt.execute("insert into jira1136 values (3.4028235E38)");
        PreparedStatement ps = conn.prepareStatement("select * from jira1136");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            ResultSetMiscTest.assertEquals((double)3.4028235E38, (double)rs.getFloat(1), (double)1.0E-5);
        }
    }

    private void checkSingleRSAutoCommit(Connection conn) throws SQLException {
        conn.setHoldability(1);
        Statement s = conn.createStatement(1003, 1007);
        ResultSet rs = s.executeQuery("select * from AutoCommitTable");
        while (rs.next()) {
        }
        ResultSetMiscTest.assertFalse((String)"Fail Auto-commit unsuccessful", (boolean)this.locksHeld());
        ResultSetMiscTest.assertFalse((String)"Final call of rs.next() should return false", (boolean)rs.next());
        rs.close();
        try {
            rs.next();
            ResultSetMiscTest.fail((String)"FAIL Error should have occured with rs.next() on a closed ResultSet");
        }
        catch (SQLException se) {
            ResultSetMiscTest.assertEquals((String)"XCL16", (String)se.getSQLState());
            ResultSetMiscTest.assertTrue((se.getMessage().indexOf("next") > 0 ? 1 : 0) != 0);
        }
    }

    private void checkSingleRSCloseCursorsAtCommit(Connection conn) throws SQLException {
        conn.setHoldability(2);
        conn.setTransactionIsolation(8);
        Statement s = conn.createStatement(1003, 1007);
        ResultSet rs = s.executeQuery("select * from AutoCommitTable");
        while (rs.next()) {
        }
        ResultSetMiscTest.assertFalse((String)"Fail Auto-commit unsuccessful", (boolean)this.locksHeld());
        try {
            rs.next();
            ResultSetMiscTest.fail((String)"FAIL. ResultSet not closed implicitly");
        }
        catch (SQLException e) {
            ResultSetMiscTest.assertEquals((String)"XCL16", (String)e.getSQLState());
        }
    }

    private void checkLocksForAutoCommitSelect(Connection conn, Statement stmt, int action) throws SQLException {
        ResultSet rs = stmt.executeQuery("select i,b from bug4810");
        rs.next();
        ResultSetMiscTest.assertEquals((int)1, (int)rs.getInt(1));
        ResultSetMiscTest.assertEquals((int)1, (int)rs.getInt(2));
        rs.next();
        ResultSetMiscTest.assertEquals((int)1, (int)rs.getInt(1));
        ResultSetMiscTest.assertEquals((int)2, (int)rs.getInt(2));
        if (action == 1) {
            conn.commit();
            ResultSetMiscTest.assertFalse((String)"Should not hold locks after commit", (boolean)this.locksHeld());
        } else if (action == 2) {
            conn.rollback();
            ResultSetMiscTest.assertFalse((String)"Should not hold locks after rollback", (boolean)this.locksHeld());
        } else if (action == 0) {
            ResultSetMiscTest.assertTrue((String)"Locks should be held with autocommit only", (boolean)this.locksHeld());
            try {
                rs.next();
                ResultSetMiscTest.assertEquals((int)1, (int)rs.getInt(1));
                ResultSetMiscTest.assertEquals((int)3, (int)rs.getInt(2));
            }
            catch (SQLException sqle) {
                ResultSetMiscTest.fail((String)("Unexpected exception" + sqle.getSQLState() + ":" + sqle.getMessage()));
            }
        }
        rs.close();
    }

    private boolean locksHeld() throws SQLException {
        Connection con2 = this.openDefaultConnection();
        Statement s2 = con2.createStatement();
        s2.execute("CALL WAIT_FOR_POST_COMMIT()");
        ResultSet rs2 = s2.executeQuery("SELECT 1 FROM SYSCS_DIAG.LOCK_TABLE");
        boolean hasLocks = rs2.next();
        rs2.close();
        s2.close();
        con2.close();
        return hasLocks;
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("ResultSetTest2");
        suite.addTest(ResultSetMiscTest.baseSuite("ResultSetTest2:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(ResultSetMiscTest.baseSuite("ResultSetTest2:client")));
        return suite;
    }

    public static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(ResultSetMiscTest.class);
        Test test = DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 1, 3);
        return new CleanDatabaseTestSetup(test){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("create table t (i int, s smallint, r real, d double precision, dt date, t time, ts timestamp, c char(10), v varchar(40) not null, dc dec(10,2),bi bigint, cbd char(10) for bit data,vbd varchar(10) for bit data,lvbd long varchar for bit data,cl clob(2G), bl blob(1G) )");
                s.execute("insert into t values(1,2,3.3,4.4,date('1990-05-05'),time('12:06:06'),timestamp('1990-07-07 07:07:07.000007'),'eight','nine', 10.1, 11," + Utilities.stringToHexLiteral("twelv") + "," + Utilities.stringToHexLiteral("3teen") + "," + Utilities.stringToHexLiteral("4teen") + ", null, null)");
                s.execute("CREATE PROCEDURE WAIT_FOR_POST_COMMIT() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.util.T_Access.waitForPostCommitToFinish' PARAMETER STYLE JAVA");
            }
        };
    }
}

