/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.XAConnection;
import javax.sql.XADataSource;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;
import junit.framework.Test;
import org.apache.derbyTesting.functionTests.util.DeadlockWatchdog;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.BaseTestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;
import org.apache.derbyTesting.junit.Utilities;
import org.apache.derbyTesting.junit.XATestUtil;

public class XATest
extends BaseJDBCTestCase {
    public static final String LOCKTIMEOUT = "40XL1";

    public XATest(String name) {
        super(name);
    }

    public void testSingleConnectionOnePhaseCommit() throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Xid xid = XATestUtil.getXid(0, 32, 46);
        xar.start(xid, 0);
        Connection conn = xac.getConnection();
        XATest.assertEquals((int)2, (int)conn.getHoldability());
        Statement s = conn.createStatement();
        XATest.assertEquals((int)2, (int)s.getResultSetHoldability());
        s.execute("create table foo (a int)");
        s.executeUpdate("insert into foo values (0)");
        ResultSet rs = s.executeQuery("select * from foo");
        JDBC.assertDrainResults(rs, 1);
        String[][] expectedRows = new String[][]{{"(0", "ACTIVE", "false", "APP", "UserTransaction"}};
        XATestUtil.checkXATransactionView(conn, expectedRows);
        s.close();
        xar.end(xid, 0x4000000);
        xar.commit(xid, true);
        conn.close();
        xac.close();
    }

    public void testInterleavingTransactions() throws SQLException, XAException {
        Statement s;
        Connection conn;
        XAConnection xac;
        block9: {
            String[][] expectedRows;
            Xid xid2;
            Xid xid1;
            XAResource xar;
            block8: {
                Statement preStatement = this.getConnection().createStatement();
                preStatement.execute("create table fooInterleaving (a int)");
                preStatement.execute("insert into fooInterleaving values (0)");
                preStatement.close();
                XADataSource xads = J2EEDataSource.getXADataSource();
                xac = xads.getXAConnection("sku", "testxa");
                xar = xac.getXAResource();
                xid1 = XATestUtil.getXid(1, 93, 18);
                xid2 = XATestUtil.getXid(2, 45, 77);
                xar.start(xid1, 0);
                conn = xac.getConnection();
                s = conn.createStatement();
                s.executeUpdate("insert into APP.fooInterleaving values (1)");
                xar.end(xid1, 0x2000000);
                xar.start(xid2, 0);
                s.executeUpdate("insert into APP.fooInterleaving values (2)");
                xar.end(xid2, 0x2000000);
                xar.start(xid1, 0x8000000);
                s.executeUpdate("insert into APP.fooInterleaving values (3)");
                xar.end(xid1, 0x2000000);
                xar.start(xid2, 0x8000000);
                s.executeUpdate("insert into APP.fooInterleaving values (4)");
                expectedRows = new String[][]{{"(1", "ACTIVE", "false", "SKU", "UserTransaction"}, {"(2", "ACTIVE", "false", "SKU", "UserTransaction"}};
                XATestUtil.checkXATransactionView(conn, expectedRows);
                try {
                    xar.prepare(xid1);
                    XATest.fail((String)"FAIL - prepare on suspended transaction");
                }
                catch (XAException e) {
                    if (e.errorCode == -6) break block8;
                    XATestUtil.dumpXAException("FAIL - prepare on suspended transaction", e);
                }
            }
            XATestUtil.checkXATransactionView(conn, expectedRows);
            xar.end(xid2, 0x4000000);
            xar.end(xid1, 0x4000000);
            xar.prepare(xid1);
            xar.prepare(xid2);
            expectedRows = new String[][]{{"(1", "PREPARED", "false", "SKU", "UserTransaction"}, {"(2", "PREPARED", "false", "SKU", "UserTransaction"}};
            XATestUtil.checkXATransactionView(conn, expectedRows);
            Xid[] recoveredStart = xar.recover(0x1000000);
            XATest.assertEquals((int)2, (int)recoveredStart.length);
            Xid[] recovered = xar.recover(0);
            XATest.assertEquals((int)0, (int)recovered.length);
            Xid[] recoveredEnd = xar.recover(0x800000);
            XATest.assertEquals((int)0, (int)recoveredEnd.length);
            for (int i = 0; i < recoveredStart.length; ++i) {
                Xid xid = recoveredStart[i];
                if (xid.getFormatId() == 1) {
                    xar.commit(xid, false);
                    continue;
                }
                if (xid.getFormatId() == 2) {
                    xar.rollback(xid);
                    continue;
                }
                XATest.fail((String)"FAIL: unknown xact");
            }
            Xid xid3 = XATestUtil.getXid(3, 2, 101);
            xar.start(xid3, 0);
            expectedRows = new String[][]{{"(3", "IDLE", "NULL", "SKU", "UserTransaction"}};
            XATestUtil.checkXATransactionView(conn, expectedRows);
            ResultSet rs = s.executeQuery("select * from APP.fooInterleaving");
            expectedRows = new String[][]{{"0"}, {"1"}, {"3"}};
            JDBC.assertFullResultSet(rs, expectedRows);
            rs.close();
            xar.end(xid3, 0x4000000);
            int pr = xar.prepare(xid3);
            if (pr != 3) {
                XATest.fail((String)("FAIL - prepare on read only xact returned " + pr));
            }
            try {
                xar.commit(xid3, true);
                XATest.fail((String)"FAIL - 2pc commit on read-only xact");
            }
            catch (XAException e) {
                if (e.errorCode == -4) break block9;
                throw e;
            }
        }
        s.close();
        conn.close();
        xac.close();
    }

    public void testNoTransaction() throws SQLException, XAException {
        block29: {
            Xid xid11;
            XAResource xar;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            block20: {
                                                XADataSource xads = J2EEDataSource.getXADataSource();
                                                XAConnection xac = xads.getXAConnection();
                                                xar = xac.getXAResource();
                                                xid11 = XATestUtil.getXid(11, 3, 128);
                                                try {
                                                    xar.start(xid11, 0x200000);
                                                }
                                                catch (XAException e) {
                                                    if (e.errorCode == -4) break block20;
                                                    throw e;
                                                }
                                            }
                                            try {
                                                xar.start(xid11, 0x8000000);
                                            }
                                            catch (XAException e) {
                                                if (e.errorCode == -4) break block21;
                                                throw e;
                                            }
                                        }
                                        try {
                                            xar.end(xid11, 0x4000000);
                                        }
                                        catch (XAException e) {
                                            if (e.errorCode == -4) break block22;
                                            throw e;
                                        }
                                    }
                                    try {
                                        xar.end(xid11, 0x20000000);
                                    }
                                    catch (XAException e) {
                                        if (e.errorCode == -4) break block23;
                                        throw e;
                                    }
                                }
                                try {
                                    xar.end(xid11, 0x2000000);
                                }
                                catch (XAException e) {
                                    if (e.errorCode == -4) break block24;
                                    throw e;
                                }
                            }
                            try {
                                xar.prepare(xid11);
                            }
                            catch (XAException e) {
                                if (e.errorCode == -4) break block25;
                                throw e;
                            }
                        }
                        try {
                            xar.commit(xid11, false);
                        }
                        catch (XAException e) {
                            if (e.errorCode == -4) break block26;
                            throw e;
                        }
                    }
                    try {
                        xar.commit(xid11, true);
                    }
                    catch (XAException e) {
                        if (e.errorCode == -4) break block27;
                        throw e;
                    }
                }
                try {
                    xar.rollback(xid11);
                }
                catch (XAException e) {
                    if (e.errorCode == -4) break block28;
                    throw e;
                }
            }
            try {
                xar.forget(xid11);
            }
            catch (XAException e) {
                if (e.errorCode == -4) break block29;
                throw e;
            }
        }
    }

    public void testMorph() throws SQLException, XAException {
        Xid xid3;
        ResultSet rs;
        String[][] expectedRows;
        Statement s;
        Connection conn;
        XAResource xar;
        XAConnection xac;
        block27: {
            block26: {
                Xid xid;
                block25: {
                    Statement preStatement = this.getConnection().createStatement();
                    preStatement.execute("create table fooMorph (a int)");
                    preStatement.executeUpdate("insert into APP.fooMorph values (0)");
                    preStatement.executeUpdate("insert into APP.fooMorph values (1)");
                    preStatement.executeUpdate("insert into APP.fooMorph values (2)");
                    preStatement.executeUpdate("insert into APP.fooMorph values (3)");
                    preStatement.executeUpdate("insert into APP.fooMorph values (4)");
                    preStatement.close();
                    XADataSource xads = J2EEDataSource.getXADataSource();
                    xac = xads.getXAConnection();
                    xar = xac.getXAResource();
                    conn = xac.getConnection();
                    conn.setAutoCommit(false);
                    s = conn.createStatement();
                    s.executeUpdate("insert into APP.fooMorph values (2001)");
                    XATestUtil.checkXATransactionView(conn, null);
                    conn.commit();
                    conn.setAutoCommit(true);
                    s.executeUpdate("insert into APP.fooMorph values (2002)");
                    XATestUtil.checkXATransactionView(conn, null);
                    xid = XATestUtil.getXid(1001, 66, 13);
                    xar.start(xid, 0);
                    expectedRows = new String[][]{{"(1", "IDLE", "NULL", "APP", "UserTransaction"}};
                    XATestUtil.checkXATransactionView(conn, expectedRows);
                    s.executeUpdate("insert into APP.fooMorph values (2003)");
                    try {
                        conn.commit();
                        XATest.fail((String)"FAIL: commit allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        conn.rollback();
                        XATest.fail((String)"FAIL: roll back allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        conn.setAutoCommit(true);
                        XATest.fail((String)"FAIL: setAutoCommit(true) allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        conn.setSavepoint();
                        XATest.fail((String)"FAIL: setSavepoint() allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    try {
                        conn.setSavepoint("badsavepoint");
                        XATest.fail((String)"FAIL: setSavepoint(String) allowed in global xact");
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                    conn.setAutoCommit(false);
                    s.executeQuery("select * from APP.fooMorph where A >= 2000").close();
                    s.close();
                    s = conn.createStatement();
                    XATest.assertEquals((int)2, (int)s.getResultSetHoldability());
                    rs = s.executeQuery("select * from APP.fooMorph where A >= 2000");
                    expectedRows = new String[][]{{"2001"}, {"2002"}, {"2003"}};
                    rs.close();
                    xar.end(xid, 0x4000000);
                    xar.prepare(xid);
                    try {
                        xar.start(xid, 0);
                        XATest.fail((String)"FAIL - start with duplicate XID");
                    }
                    catch (XAException e) {
                        if (e.errorCode == -8) break block25;
                        throw e;
                    }
                }
                Xid xid2 = XATestUtil.getXid(1002, 23, 3);
                xar.start(xid2, 0);
                try {
                    conn.commit();
                    XATest.fail((String)"FAIL: commit allowed in global xact");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    conn.rollback();
                    XATest.fail((String)"FAIL: roll back allowed in global xact");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                try {
                    conn.setAutoCommit(true);
                    XATest.fail((String)"FAIL: setAutoCommit(true) allowed in global xact");
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                conn.setAutoCommit(false);
                xar.end(xid2, 0x2000000);
                conn = xac.getConnection();
                s = conn.createStatement();
                s.executeUpdate("insert into APP.fooMorph values (2005)");
                conn.commit();
                conn.setAutoCommit(false);
                s.executeUpdate("insert into APP.fooMorph values (2006)");
                conn.rollback();
                s.executeUpdate("insert into APP.fooMorph values (2007)");
                conn.commit();
                expectedRows = new String[][]{{"(1", "PREPARED", "false", "APP", "UserTransaction"}, {"(1", "IDLE", "NULL", "APP", "UserTransaction"}};
                XATestUtil.checkXATransactionView(conn, expectedRows);
                xar.commit(xid, false);
                xar.end(xid2, 0x4000000);
                xar.rollback(xid2);
                XATestUtil.checkXATransactionView(conn, null);
                rs = s.executeQuery("select * from APP.fooMorph where A >= 2000");
                expectedRows = new String[][]{{"2001"}, {"2002"}, {"2003"}, {"2005"}, {"2007"}};
                JDBC.assertFullResultSet(rs, expectedRows);
                rs.close();
                conn.rollback();
                conn.close();
                conn = xac.getConnection();
                conn.setAutoCommit(false);
                s = conn.createStatement();
                s.executeUpdate("delete from app.fooMorph");
                rs = s.executeQuery("select * from APP.fooMorph");
                JDBC.assertEmpty(rs);
                rs.close();
                conn = xac.getConnection();
                conn.setAutoCommit(false);
                s = conn.createStatement();
                rs = s.executeQuery("select * from APP.fooMorph where A >= 2000");
                expectedRows = new String[][]{{"2001"}, {"2002"}, {"2003"}, {"2005"}, {"2007"}};
                JDBC.assertFullResultSet(rs, expectedRows);
                xid3 = XATestUtil.getXid(1003, 27, 9);
                try {
                    xar.start(xid3, 0);
                    XATest.fail((String)"FAIL XAResource.start on a global transaction with an active local transaction (autocommit false)");
                }
                catch (XAException xae) {
                    if (xae.errorCode == -9) break block26;
                    throw xae;
                }
            }
            conn.commit();
            xar.start(xid3, 0);
            if (XATest.usingEmbedded()) {
                try {
                    xac.getConnection();
                    XATest.fail((String)"FAIL: getConnection with active global xact");
                }
                catch (SQLException sqle) {
                    XATest.assertSQLState("XJ059", sqle);
                }
            }
            s = conn.createStatement();
            s.executeUpdate("delete from APP.fooMorph");
            rs = s.executeQuery("select * from APP.fooMorph where A >= 2000");
            JDBC.assertEmpty(rs);
            rs.close();
            try {
                xar.end(xid3, 0x20000000);
            }
            catch (XAException e) {
                if (e.errorCode == 100) break block27;
                throw e;
            }
        }
        xar.rollback(xid3);
        conn = xac.getConnection();
        s = conn.createStatement();
        rs = s.executeQuery("select * from APP.fooMorph where A >= 2000");
        expectedRows = new String[][]{{"2001"}, {"2002"}, {"2003"}, {"2005"}, {"2007"}};
        JDBC.assertFullResultSet(rs, expectedRows);
        rs.close();
        s.close();
        conn.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby4310PreparedStatement() throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        XAConnection xaconn = xads.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        Xid xid = XATestUtil.getXid(1, 93, 18);
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE TABLE foo4310_PS (I INT)");
        conn.createStatement().executeUpdate("insert into APP.foo4310_PS values (0)");
        conn.createStatement().executeUpdate("insert into APP.foo4310_PS values (1)");
        conn.createStatement().executeUpdate("insert into APP.foo4310_PS values (2)");
        conn.commit();
        PreparedStatement ps = conn.prepareStatement("SELECT * FROM APP.foo4310_PS");
        ps.executeQuery().close();
        xar.start(xid, 0);
        xar.end(xid, 0x4000000);
        Connection conn2 = this.getConnection();
        Statement s2 = conn2.createStatement();
        s2.execute("DROP TABLE foo4310_PS");
        conn2.commit();
        conn2.close();
        try {
            ps.close();
        }
        finally {
            xar.rollback(xid);
            conn.close();
            xaconn.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDerby4310CallableStatement() throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        XAConnection xaconn = xads.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        Xid xid = XATestUtil.getXid(1, 93, 18);
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        s.executeUpdate("CREATE PROCEDURE ZA() LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbcapi.XATest.zeroArg' PARAMETER STYLE JAVA");
        conn.commit();
        CallableStatement cs = conn.prepareCall("CALL ZA()");
        cs.execute();
        xar.start(xid, 0);
        xar.end(xid, 0x4000000);
        Connection conn2 = this.getConnection();
        Statement s2 = conn2.createStatement();
        s2.execute("DROP PROCEDURE ZA");
        conn2.commit();
        conn2.close();
        try {
            cs.close();
        }
        finally {
            xar.rollback(xid);
            conn.close();
            xaconn.close();
        }
    }

    public void testDerby966() throws SQLException, XAException {
        Statement preStatement = this.getConnection().createStatement();
        preStatement.execute("create table foo966 (a int)");
        preStatement.executeUpdate("insert into APP.foo966 values (0)");
        preStatement.executeUpdate("insert into APP.foo966 values (1)");
        preStatement.executeUpdate("insert into APP.foo966 values (2)");
        preStatement.executeUpdate("insert into APP.foo966 values (3)");
        preStatement.executeUpdate("insert into APP.foo966 values (4)");
        preStatement.executeUpdate("insert into APP.foo966 values (2001)");
        preStatement.executeUpdate("insert into APP.foo966 values (2002)");
        preStatement.executeUpdate("insert into APP.foo966 values (2003)");
        preStatement.executeUpdate("insert into APP.foo966 values (2005)");
        preStatement.executeUpdate("insert into APP.foo966 values (2007)");
        preStatement.close();
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection xac = xads.getXAConnection();
        XAResource xar = xac.getXAResource();
        Xid xid = XATestUtil.getXid(996, 9, 48);
        Connection conn = xac.getConnection();
        XATest.assertEquals((int)1, (int)conn.getHoldability());
        Statement sdh = conn.createStatement();
        XATest.assertEquals((int)1, (int)sdh.getResultSetHoldability());
        XATest.checkHeldRS(conn, sdh, sdh.executeQuery("select * from app.foo966"));
        PreparedStatement psdh = conn.prepareStatement("SELECT * FROM APP.foo966");
        PreparedStatement psdh_d = conn.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99");
        XATest.assertEquals((int)1, (int)psdh.getResultSetHoldability());
        XATest.checkHeldRS(conn, psdh, psdh.executeQuery());
        Statement shh = conn.createStatement(1003, 1007, 1);
        XATest.assertEquals((int)1, (int)shh.getResultSetHoldability());
        XATest.checkHeldRS(conn, shh, shh.executeQuery("select * from app.foo966"));
        PreparedStatement pshh = conn.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 1);
        PreparedStatement pshh_d = conn.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 1);
        XATest.assertEquals((int)1, (int)shh.getResultSetHoldability());
        XATest.checkHeldRS(conn, pshh, pshh.executeQuery());
        Statement sch = conn.createStatement(1003, 1007, 2);
        XATest.assertEquals((int)2, (int)sch.getResultSetHoldability());
        XATest.checkHeldRS(conn, sch, sch.executeQuery("select * from app.foo966"));
        PreparedStatement psch = conn.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 2);
        PreparedStatement psch_d = conn.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 2);
        XATest.assertEquals((int)2, (int)psch_d.getResultSetHoldability());
        XATest.checkHeldRS(conn, psch, psch.executeQuery());
        conn.setHoldability(2);
        Statement sdc = conn.createStatement();
        XATest.assertEquals((int)2, (int)sdc.getResultSetHoldability());
        XATest.checkHeldRS(conn, sdc, sdc.executeQuery("select * from app.foo966"));
        PreparedStatement psdc = conn.prepareStatement("SELECT * FROM APP.foo966");
        PreparedStatement psdc_d = conn.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99");
        XATest.assertEquals((int)2, (int)psdc.getResultSetHoldability());
        XATest.checkHeldRS(conn, psdc, psdc.executeQuery());
        Statement shc = conn.createStatement(1003, 1007, 1);
        XATest.assertEquals((int)2, (int)psdc.getResultSetHoldability());
        XATest.checkHeldRS(conn, shc, shc.executeQuery("select * from app.foo966"));
        PreparedStatement pshc = conn.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 1);
        PreparedStatement pshc_d = conn.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 1);
        XATest.assertEquals((int)1, (int)pshc.getResultSetHoldability());
        XATest.checkHeldRS(conn, pshc, pshc.executeQuery());
        Statement scc = conn.createStatement(1003, 1007, 2);
        XATest.assertEquals((int)2, (int)scc.getResultSetHoldability());
        XATest.checkHeldRS(conn, scc, scc.executeQuery("select * from app.foo966"));
        PreparedStatement pscc = conn.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 2);
        PreparedStatement pscc_d = conn.prepareStatement("DELETE FROM APP.foo966 WHERE A < -99", 1003, 1007, 2);
        XATest.assertEquals((int)2, (int)pscc.getResultSetHoldability());
        XATest.checkHeldRS(conn, pscc, pscc.executeQuery());
        conn.setHoldability(1);
        ResultSet rs = sdh.executeQuery("SELECT * FROM APP.foo966");
        rs.next();
        XATest.assertEquals((int)0, (int)rs.getInt(1));
        conn.commit();
        rs.next();
        XATest.assertEquals((int)1, (int)rs.getInt(1));
        rs.close();
        rs = sdh.executeQuery("SELECT * FROM APP.foo966");
        xar.start(xid, 0);
        sdh.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        shh.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        sch.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        ArrayList<ResultSet> openRS = new ArrayList<ResultSet>();
        openRS.add(sdh.executeQuery("SELECT * FROM APP.foo966"));
        openRS.add(shh.executeQuery("SELECT * FROM APP.foo966"));
        openRS.add(sch.executeQuery("SELECT * FROM APP.foo966"));
        openRS.add(psdh.executeQuery());
        openRS.add(pshh.executeQuery());
        openRS.add(psch.executeQuery());
        psdh_d.executeUpdate();
        pshh_d.executeUpdate();
        psch_d.executeUpdate();
        sdc.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        shc.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        scc.executeUpdate("DELETE FROM APP.foo966 where A < -99");
        openRS.add(sdc.executeQuery("SELECT * FROM APP.foo966"));
        openRS.add(shc.executeQuery("SELECT * FROM APP.foo966"));
        openRS.add(scc.executeQuery("SELECT * FROM APP.foo966"));
        openRS.add(psdc.executeQuery());
        openRS.add(pshc.executeQuery());
        openRS.add(pscc.executeQuery());
        psdc_d.executeUpdate();
        pshc_d.executeUpdate();
        pscc_d.executeUpdate();
        int orsCount = 0;
        for (ResultSet ors : openRS) {
            ors.clearWarnings();
            ++orsCount;
        }
        XATest.assertEquals((String)"Incorrect number of open result sets", (int)12, (int)orsCount);
        try {
            conn.setHoldability(1);
            XATest.fail((String)"FAIL - set holdability in global xact.");
        }
        catch (SQLException sqle) {
            XATest.assertSQLState("XJ05C", sqle);
        }
        Statement sglobalhold = conn.createStatement(1003, 1007, 1);
        XATest.assertEquals((int)2, (int)sglobalhold.getResultSetHoldability());
        sglobalhold.close();
        if (!XATest.usingDerbyNetClient()) {
            PreparedStatement psglobalhold = conn.prepareStatement("SELECT * FROM APP.foo966", 1003, 1007, 1);
            XATest.assertEquals((int)2, (int)psglobalhold.getResultSetHoldability());
            psglobalhold.close();
            XATest.assertEquals((int)2, (int)sdh.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)sch.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)psdh.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)pshh.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)psch.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)sdc.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)shc.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)scc.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)psdh_d.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)pshh_d.getResultSetHoldability());
            XATest.assertEquals((int)2, (int)psch_d.getResultSetHoldability());
        }
        xar.end(xid, 0x4000000);
        if (xar.prepare(xid) != 3) {
            XATest.fail((String)"FAIL prepare didn't indicate r/o");
        }
        int crsCount = 0;
        for (ResultSet crs : openRS) {
            try {
                crs.clearWarnings();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            ++crsCount;
        }
        XATest.assertEquals((String)"After global transaction closed ResultSets ", (int)12, (int)crsCount);
        XATest.assertEquals((int)1, (int)sdh.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)shh.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)sch.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)psdh.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)pshh.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)psch.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)sdc.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)shc.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)scc.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)psdh_d.getResultSetHoldability());
        XATest.assertEquals((int)1, (int)pshh_d.getResultSetHoldability());
        XATest.assertEquals((int)2, (int)psch_d.getResultSetHoldability());
        conn.rollback();
        conn.close();
    }

    public void testXATempTableD4731_RawStore() throws SQLException, XAException {
        this.doXATempTableD4731Work(true, false, XATestUtil.getXid(997, 9, 49));
    }

    public void xtestXATempTableD4735_Assert() throws SQLException, XAException {
        this.doXATempTableD4731Work(false, false, XATestUtil.getXid(999, 11, 51));
        this.doXATempTableD4731Work(false, true, XATestUtil.getXid(1000, 12, 52));
    }

    public void testXATempTableD4743() throws SQLException, XAException {
        this.doXATempTableD4731Work(true, true, XATestUtil.getXid(998, 10, 50));
    }

    public void testXALockTimeout() throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        XAConnection xaconn = xads.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        Xid xid = XATestUtil.getXid(998, 10, 50);
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        xar.start(xid, 0);
        s.executeUpdate("INSERT INTO TABLT VALUES(2)");
        XAConnection xaconn2 = xads.getXAConnection();
        XAResource xar2 = xaconn2.getXAResource();
        Xid xid2 = XATestUtil.getXid(999, 11, 51);
        Connection conn2 = xaconn2.getConnection();
        conn2.setTransactionIsolation(8);
        xar2.start(xid2, 0);
        Statement s2 = conn2.createStatement();
        s2.executeUpdate("INSERT INTO TABLT VALUES(3)");
        this.assertGlobalXactCount(2);
        try {
            ResultSet rs = s2.executeQuery("SELECT * FROM TABLT");
            XATest.fail((String)"Should have gotten lock timeout error: 40XL1");
        }
        catch (SQLException se) {
            XATest.assertSQLState(LOCKTIMEOUT, se);
        }
        this.assertGlobalXactCount(1);
        XATest.assertConnOK(conn);
        XATest.assertConnOK(conn2);
        xar.end(xid, 0x4000000);
        xar.prepare(xid);
        xar.commit(xid, false);
        try {
            xar2.end(xid2, 0x4000000);
            XATest.fail((String)"Should have gotten exception ending xid2");
        }
        catch (XAException xae) {
            XATest.assertEquals((int)106, (int)xae.errorCode);
        }
        Statement drops = this.createStatement();
        drops.executeUpdate("DROP TABLE TABLT");
        this.assertGlobalXactCount(0);
        xar2.rollback(xid2);
        xar.start(xid, 0);
        s.executeUpdate("CREATE TABLE TABLT (I INT)");
        s.executeUpdate("INSERT INTO TABLT VALUES(1)");
        xar.end(xid, 0x4000000);
        xar.prepare(xid);
        xar.commit(xid, false);
        xar2.start(xid2, 0);
        s2.executeUpdate("INSERT INTO TABLT VALUES(2)");
        xar2.end(xid2, 0x4000000);
        xar.prepare(xid2);
        xar.commit(xid2, false);
        this.assertGlobalXactCount(0);
        conn.close();
        xaconn.close();
        conn2.close();
        xaconn2.close();
    }

    public void testDerby6879() throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        J2EEDataSource.setBeanProperty(xads, "databaseName", "wombat");
        Connection conn = J2EEDataSource.getConnectionPoolDataSource().getPooledConnection().getConnection();
        conn.setAutoCommit(false);
        Statement s = conn.createStatement();
        s.execute("LOCK TABLE TABLT IN EXCLUSIVE MODE");
        XAConnection xaconn2 = xads.getXAConnection();
        XAResource xar2 = xaconn2.getXAResource();
        xar2.setTransactionTimeout(2);
        Xid xid2 = XATestUtil.getXid(6879, 11, 51);
        Connection conn2 = xaconn2.getConnection();
        conn2.setTransactionIsolation(8);
        xar2.start(xid2, 0);
        Statement s2 = conn2.createStatement();
        this.assertGlobalXactCount(1);
        DeadlockWatchdog wd = new DeadlockWatchdog(30000L);
        wd.start();
        try {
            ResultSet rs = s2.executeQuery("SELECT * FROM TABLT");
            XATest.fail((String)"Should have gotten lock timeout error: 40XL1");
        }
        catch (SQLException se) {
            XATest.assertSQLState(LOCKTIMEOUT, se);
        }
        wd.stop();
        try {
            xar2.end(xid2, 0x4000000);
            XATest.fail((String)"Should have gotten exception ending xid2");
        }
        catch (XAException xae) {
            XATest.assertTrue((xae.errorCode >= -9 || xae.errorCode <= -2 ? 1 : 0) != 0);
        }
        conn.commit();
        conn.close();
        conn2.close();
        xaconn2.close();
    }

    private void doXATempTableD4731Work(boolean doLoggedWorkInXact, boolean access_temp_table_after_xaendandcommit, Xid xid) throws SQLException, XAException {
        XADataSource xads = J2EEDataSource.getXADataSource();
        XAConnection xaconn = xads.getXAConnection();
        XAResource xar = xaconn.getXAResource();
        xar.start(xid, 0);
        Connection conn = xaconn.getConnection();
        Statement s = conn.createStatement();
        if (doLoggedWorkInXact) {
            this.makeARealTable(s);
        }
        s.executeUpdate("DECLARE GLOBAL TEMPORARY TABLE SESSION.T1 ( XWSID INT, XCTID INT, XIID CHAR(26), XVID SMALLINT, XLID CHAR(8) FOR BIT DATA) ON COMMIT DELETE ROWS NOT LOGGED ON ROLLBACK DELETE ROWS");
        PreparedStatement ps = conn.prepareStatement("INSERT INTO SESSION.T1 VALUES (?,?,?,?,?)");
        ps.setInt(1, 1);
        ps.setInt(2, 1);
        ps.setString(3, "hello");
        ps.setShort(4, (short)1);
        ps.setBytes(5, new byte[]{0, 1});
        ps.executeUpdate();
        ResultSet rs = s.executeQuery("SELECT count(*) FROM SESSION.t1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1"}});
        rs.close();
        xar.end(xid, 0x4000000);
        XATest.assertEquals((int)(doLoggedWorkInXact ? 0 : 3), (int)xar.prepare(xid));
        if (doLoggedWorkInXact) {
            xar.commit(xid, false);
        }
        if (access_temp_table_after_xaendandcommit) {
            XATest.assertStatementError("42X05", s, "SELECT count(*) FROM SESSION.t1");
            conn.commit();
        }
        s.close();
        conn.close();
        xaconn.close();
    }

    private void makeARealTable(Statement s) throws SQLException {
        try {
            s.executeUpdate("DROP TABLE REALTABLE1");
        }
        catch (SQLException se) {
            s.executeUpdate("CREATE TABLE REALTABLE1 (i int)");
        }
    }

    private static void checkHeldRS(Connection conn, Statement s, ResultSet rs) throws SQLException {
        if (!XATest.usingDerbyNetClient() && s.getConnection() != conn) {
            XATest.fail((String)"FAIL - mismatched statement & Connection");
        }
        if (rs.getStatement() != s) {
            XATest.fail((String)("FAIL - mismatched statement & ResultSet  Statement class " + String.valueOf(s.getClass()) + " ResultSet' Statements class " + String.valueOf(rs.getStatement().getClass())));
        }
        boolean held = 1 == s.getResultSetHoldability();
        rs.next();
        XATest.assertEquals((int)0, (int)rs.getInt(1));
        conn.commit();
        try {
            rs.next();
        }
        catch (SQLException sqle) {
            boolean ok;
            boolean bl = ok = !held;
            if (ok) {
                XATest.assertSQLState("XCL16", sqle);
            }
            XATest.fail((String)"Held cursor closed on commit");
        }
        rs.close();
        conn.commit();
    }

    public static void zeroArg() {
    }

    public static Test baseSuite(String name) {
        BaseTestSuite suite = new BaseTestSuite(name);
        suite.addTestSuite(XATest.class);
        return new CleanDatabaseTestSetup((Test)suite){

            @Override
            protected void decorateSQL(Statement s) throws SQLException {
                XATestUtil.createXATransactionView(s);
                s.executeUpdate("CREATE TABLE TABLT (I INT)");
                s.executeUpdate("INSERT INTO TABLT VALUES(1)");
            }
        };
    }

    private static void assertConnOK(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("VALUES(1)");
        JDBC.assertSingleValueResultSet(rs, "1");
    }

    private void assertGlobalXactCount(int expectedCount) throws SQLException {
        Connection conn = this.openDefaultConnection();
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT COUNT(*) FROM syscs_diag.transaction_table WHERE GLOBAL_XID IS NOT NULL");
        rs.next();
        int count = rs.getInt(1);
        if (TestConfiguration.getCurrent().isVerbose()) {
            System.out.println("assertGlobalXactCount(" + expectedCount + "): Full Transaction Table ...");
            Utilities.showResultSet(s.executeQuery("SELECT * FROM syscs_diag.transaction_table"));
        }
        XATest.assertTrue((String)("Expected " + expectedCount + "global transactions but saw " + count), (expectedCount == count ? 1 : 0) != 0);
    }

    public static Test suite() {
        BaseTestSuite suite = new BaseTestSuite("XATest");
        if (JDBC.vmSupportsJSR169()) {
            return suite;
        }
        suite.addTest(XATest.baseSuite("XATest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(XATest.baseSuite("XATest:client")));
        Test test = DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 3, 5);
        test = XATest.decorateWithPolicy(test);
        return test;
    }

    private static Test decorateWithPolicy(Test test) {
        return test;
    }
}

