/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.revwalk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.eclipse.jgit.errors.IncorrectObjectTypeException;
import org.eclipse.jgit.errors.MissingObjectException;
import org.eclipse.jgit.lib.AnyObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectIdSubclassMap;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.revwalk.RevCommit;
import org.eclipse.jgit.revwalk.RevFlag;
import org.eclipse.jgit.revwalk.RevWalk;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class RevWalkUtils {
    private RevWalkUtils() {
    }

    public static int count(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        return RevWalkUtils.find(walk, start, end).size();
    }

    public static List<RevCommit> find(RevWalk walk, RevCommit start, RevCommit end) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        walk.reset();
        walk.markStart(start);
        if (end != null) {
            walk.markUninteresting(end);
        }
        ArrayList<RevCommit> commits = new ArrayList<RevCommit>();
        for (RevCommit c : walk) {
            commits.add(c);
        }
        return commits;
    }

    public static List<Ref> findBranchesReachableFrom(RevCommit commit, RevWalk revWalk, Collection<Ref> refs) throws MissingObjectException, IncorrectObjectTypeException, IOException {
        ArrayList<Ref> result = new ArrayList<Ref>();
        revWalk.markStart(Arrays.asList(commit.getParents()));
        ObjectIdSubclassMap cutOff = new ObjectIdSubclassMap();
        int SKEW = 86400;
        for (Ref ref : refs) {
            RevCommit current;
            RevCommit headCommit = revWalk.parseCommit(ref.getObjectId());
            if (headCommit.getCommitTime() + 86400 < commit.getCommitTime()) continue;
            ArrayList<ObjectId> maybeCutOff = new ArrayList<ObjectId>(cutOff.size());
            revWalk.resetRetain(new RevFlag[0]);
            revWalk.markStart(headCommit);
            Ref found = null;
            while ((current = revWalk.next()) != null) {
                if (AnyObjectId.equals(current, commit)) {
                    found = ref;
                    break;
                }
                if (cutOff.contains(current)) break;
                maybeCutOff.add(current.toObjectId());
            }
            if (found != null) {
                result.add(ref);
                continue;
            }
            for (ObjectId id : maybeCutOff) {
                cutOff.addIfAbsent(id);
            }
        }
        return result;
    }
}

