/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.pool2;

import java.io.PrintWriter;
import java.time.Duration;
import java.util.Deque;
import org.apache.commons.pool2.PooledObjectState;

public interface PooledObject<T>
extends Comparable<PooledObject<T>> {
    public boolean allocate();

    @Override
    public int compareTo(PooledObject<T> var1);

    public boolean deallocate();

    public boolean endEvictionTest(Deque<PooledObject<T>> var1);

    public boolean equals(Object var1);

    default public Duration getActiveTime() {
        return Duration.ofMillis(this.getActiveTimeMillis());
    }

    public long getActiveTimeMillis();

    default public long getBorrowedCount() {
        return -1L;
    }

    public long getCreateTime();

    default public Duration getIdleTime() {
        return Duration.ofMillis(this.getIdleTimeMillis());
    }

    public long getIdleTimeMillis();

    public long getLastBorrowTime();

    public long getLastReturnTime();

    public long getLastUsedTime();

    public T getObject();

    public PooledObjectState getState();

    public int hashCode();

    public void invalidate();

    public void markAbandoned();

    public void markReturning();

    public void printStackTrace(PrintWriter var1);

    public void setLogAbandoned(boolean var1);

    default public void setRequireFullStackTrace(boolean requireFullStackTrace) {
    }

    public boolean startEvictionTest();

    public String toString();

    public void use();
}

