/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.scheduler.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.BeforeBeanDiscovery;
import javax.enterprise.inject.spi.BeforeShutdown;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.spi.activation.Deactivatable;
import org.apache.deltaspike.core.util.ClassDeactivationUtils;
import org.apache.deltaspike.core.util.ClassUtils;
import org.apache.deltaspike.core.util.ProxyUtils;
import org.apache.deltaspike.core.util.ServiceUtils;
import org.apache.deltaspike.scheduler.api.Scheduled;
import org.apache.deltaspike.scheduler.impl.SchedulerBaseConfig;
import org.apache.deltaspike.scheduler.spi.Scheduler;
import org.apache.deltaspike.scheduler.spi.SchedulerControl;

public class SchedulerExtension
implements Extension,
Deactivatable {
    private static final Logger LOG = Logger.getLogger(SchedulerExtension.class.getName());
    private static Set<String> classNamesToVeto = new HashSet<String>();
    private Boolean isActivated = true;
    private Set<Class> foundManagedJobClasses = new HashSet<Class>();
    private Scheduler scheduler;
    private Class jobClass;

    public SchedulerExtension() {
        classNamesToVeto.add("org.apache.deltaspike.scheduler.impl.DynamicExpressionObserverJob");
    }

    protected void init(@Observes BeforeBeanDiscovery beforeBeanDiscovery) {
        this.isActivated = ClassDeactivationUtils.isActivated(this.getClass());
        if (this.isActivated.booleanValue()) {
            String jobClassName = SchedulerBaseConfig.JobCustomization.JOB_CLASS_NAME;
            this.jobClass = ClassUtils.tryToLoadClassForName((String)jobClassName);
            if (this.jobClass == null) {
                this.isActivated = false;
            }
        }
    }

    public <X> void findScheduledJobs(@Observes ProcessAnnotatedType<X> pat, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        Class beanClass = pat.getAnnotatedType().getJavaClass();
        if (Scheduler.class.isAssignableFrom(beanClass) || this.isInternalUnmanagedClass(beanClass)) {
            pat.veto();
            return;
        }
        if (!this.jobClass.isAssignableFrom(beanClass) && !Runnable.class.isAssignableFrom(beanClass)) {
            return;
        }
        Scheduled scheduled = (Scheduled)pat.getAnnotatedType().getAnnotation(Scheduled.class);
        if (scheduled != null && scheduled.onStartup()) {
            this.foundManagedJobClasses.add(beanClass);
        }
    }

    private <X> boolean isInternalUnmanagedClass(Class<X> beanClass) {
        return classNamesToVeto.contains(beanClass.getName());
    }

    public <X> void validateJobs(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        Class configuredJobClass = this.jobClass;
        this.jobClass = this.resolveFinalJobType();
        if (this.jobClass == null) {
            afterBeanDiscovery.addDefinitionError((Throwable)new IllegalStateException("Please only annotate classes with @" + Scheduled.class.getName() + " of type " + configuredJobClass.getName() + " or of type " + Runnable.class.getName() + ", but not both!"));
            return;
        }
    }

    public <X> void scheduleJobs(@Observes AfterDeploymentValidation afterDeploymentValidation, BeanManager beanManager) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        SchedulerControl schedulerControl = (SchedulerControl)BeanProvider.getContextualReference(SchedulerControl.class, (boolean)true, (Annotation[])new Annotation[0]);
        if (schedulerControl != null && !schedulerControl.isSchedulerEnabled()) {
            LOG.info("Scheduler has been disabled by " + ProxyUtils.getUnproxiedClass(schedulerControl.getClass()));
            return;
        }
        this.initScheduler(afterDeploymentValidation);
        if (this.scheduler == null) {
            return;
        }
        ArrayList<String> foundJobNames = new ArrayList<String>();
        for (Class jobClass : this.foundManagedJobClasses) {
            if (foundJobNames.contains(jobClass.getSimpleName())) {
                afterDeploymentValidation.addDeploymentProblem((Throwable)new IllegalStateException("Multiple Job-Classes found with name " + jobClass.getSimpleName()));
            }
            foundJobNames.add(jobClass.getSimpleName());
            this.scheduler.registerNewJob(jobClass);
        }
    }

    protected Class resolveFinalJobType() {
        HashSet<Class<Runnable>> foundTypes = new HashSet<Class<Runnable>>();
        for (Class foundJobClass : this.foundManagedJobClasses) {
            if (this.jobClass.isAssignableFrom(foundJobClass)) {
                foundTypes.add(this.jobClass);
                continue;
            }
            if (!Runnable.class.isAssignableFrom(foundJobClass)) continue;
            foundTypes.add(Runnable.class);
        }
        if (foundTypes.size() > 1) {
            return null;
        }
        if (foundTypes.size() == 1) {
            return (Class)foundTypes.iterator().next();
        }
        return this.jobClass;
    }

    public <X> void stopScheduler(@Observes BeforeShutdown beforeShutdown) {
        if (!this.isActivated.booleanValue()) {
            return;
        }
        if (this.scheduler != null) {
            this.scheduler.stop();
            this.scheduler = null;
        }
    }

    private void initScheduler(AfterDeploymentValidation afterDeploymentValidation) {
        List availableSchedulers = ServiceUtils.loadServiceImplementations(Scheduler.class, (boolean)true);
        this.scheduler = SchedulerExtension.findScheduler(availableSchedulers, this.jobClass);
        if (this.scheduler != null) {
            try {
                this.scheduler.start();
            }
            catch (Throwable t) {
                afterDeploymentValidation.addDeploymentProblem(t);
            }
        } else if (!this.foundManagedJobClasses.isEmpty()) {
            LOG.warning(this.foundManagedJobClasses.size() + " scheduling-jobs found, but there is no configured scheduler");
        }
    }

    private static Scheduler findScheduler(List<Scheduler> availableSchedulers, Class jobClass) {
        for (Scheduler scheduler : availableSchedulers) {
            for (Type interfaceClass : scheduler.getClass().getGenericInterfaces()) {
                if (!(interfaceClass instanceof ParameterizedType) || !Scheduler.class.isAssignableFrom((Class)((ParameterizedType)interfaceClass).getRawType()) || !jobClass.isAssignableFrom((Class)((ParameterizedType)interfaceClass).getActualTypeArguments()[0])) continue;
                return scheduler;
            }
            if (!(scheduler.getClass().getGenericSuperclass() instanceof ParameterizedType)) continue;
            ParameterizedType parameterizedType = (ParameterizedType)scheduler.getClass().getGenericSuperclass();
            for (Type typeArgument : parameterizedType.getActualTypeArguments()) {
                if (!jobClass.isAssignableFrom((Class)typeArgument)) continue;
                return scheduler;
            }
        }
        return null;
    }

    Scheduler getScheduler() {
        return this.scheduler;
    }
}

