/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.proxy.api;

import jakarta.enterprise.context.Dependent;
import jakarta.enterprise.context.spi.CreationalContext;
import jakarta.enterprise.inject.spi.AnnotatedType;
import jakarta.enterprise.inject.spi.Bean;
import jakarta.enterprise.inject.spi.BeanManager;
import jakarta.enterprise.inject.spi.InjectionTarget;
import jakarta.enterprise.inject.spi.PassivationCapable;
import jakarta.enterprise.inject.spi.configurator.BeanConfigurator;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.deltaspike.core.api.provider.BeanProvider;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.proxy.api.DeltaSpikeProxyFactory;
import org.apache.deltaspike.proxy.spi.DeltaSpikeProxy;
import org.apache.deltaspike.proxy.spi.invocation.DeltaSpikeProxyInvocationHandler;

public class DeltaSpikeProxyBeanConfigurator<T, H extends InvocationHandler> {
    private final Class<T> proxyClass;
    private final Class<H> delegateInvocationHandlerClass;
    private final Method[] delegateMethods;
    private final Class<T> targetClass;
    private final BeanManager beanManager;
    private final BeanConfigurator<T> beanConfigurator;
    private volatile DeltaSpikeProxyInvocationHandler deltaSpikeProxyInvocationHandler;
    private volatile InjectionTarget<T> injectionTarget;
    private volatile Bean<H> handlerBean;
    private volatile CreationalContext<?> creationalContextOfDependentHandler;

    public DeltaSpikeProxyBeanConfigurator(Class<T> targetClass, Class<H> delegateInvocationHandlerClass, DeltaSpikeProxyFactory proxyFactory, BeanManager beanManager, BeanConfigurator<T> beanConfigurator) {
        this.targetClass = targetClass;
        this.delegateInvocationHandlerClass = delegateInvocationHandlerClass;
        this.proxyClass = proxyFactory.getProxyClass(beanManager, targetClass);
        this.delegateMethods = proxyFactory.getDelegateMethods(targetClass);
        this.beanManager = beanManager;
        if (!targetClass.isInterface()) {
            AnnotatedType annotatedType = beanManager.createAnnotatedType(this.targetClass);
            this.injectionTarget = beanManager.getInjectionTargetFactory(annotatedType).createInjectionTarget(null);
        }
        this.beanConfigurator = beanConfigurator;
    }

    public DeltaSpikeProxyBeanConfigurator delegateCreateWith() {
        this.beanConfigurator.createWith(c -> this.create((CreationalContext)c));
        return this;
    }

    public DeltaSpikeProxyBeanConfigurator delegateDestroyWith() {
        this.beanConfigurator.destroyWith((i, c) -> this.destroy((T)i, (CreationalContext<T>)c));
        return this;
    }

    protected T create(CreationalContext creationalContext) {
        try {
            this.lazyInit();
            T instance = this.proxyClass.newInstance();
            DeltaSpikeProxy deltaSpikeProxy = (DeltaSpikeProxy)instance;
            deltaSpikeProxy.setInvocationHandler(this.deltaSpikeProxyInvocationHandler);
            if (this.delegateInvocationHandlerClass != null) {
                H delegateInvocationHandler = this.instantiateDelegateInvocationHandler();
                deltaSpikeProxy.setDelegateInvocationHandler((InvocationHandler)delegateInvocationHandler);
                deltaSpikeProxy.setDelegateMethods(this.delegateMethods);
            }
            if (this.injectionTarget != null) {
                this.injectionTarget.inject(instance, creationalContext);
                this.injectionTarget.postConstruct(instance);
            }
            return instance;
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException((Throwable)e);
            return null;
        }
    }

    protected void destroy(T instance, CreationalContext<T> creationalContext) {
        if (this.injectionTarget != null) {
            this.injectionTarget.preDestroy(instance);
        }
        if (this.creationalContextOfDependentHandler != null) {
            this.creationalContextOfDependentHandler.release();
        }
        creationalContext.release();
    }

    private void lazyInit() {
        if (this.deltaSpikeProxyInvocationHandler == null) {
            this.init();
        }
    }

    private synchronized void init() {
        if (this.deltaSpikeProxyInvocationHandler == null) {
            Set handlerBeans = BeanProvider.getBeanDefinitions(this.delegateInvocationHandlerClass, (boolean)false, (boolean)true, (BeanManager)this.beanManager);
            if (handlerBeans.size() != 1) {
                StringBuilder beanInfo = new StringBuilder();
                for (Bean bean : handlerBeans) {
                    if (beanInfo.length() != 0) {
                        beanInfo.append(", ");
                    }
                    beanInfo.append(bean);
                    if (!(bean instanceof PassivationCapable)) continue;
                    beanInfo.append(" bean-id: ").append(((PassivationCapable)bean).getId());
                }
                throw new IllegalStateException(handlerBeans.size() + " beans found for " + this.delegateInvocationHandlerClass + " found beans: " + beanInfo.toString());
            }
            this.handlerBean = (Bean)handlerBeans.iterator().next();
            this.deltaSpikeProxyInvocationHandler = (DeltaSpikeProxyInvocationHandler)BeanProvider.getContextualReference((BeanManager)this.beanManager, DeltaSpikeProxyInvocationHandler.class, (boolean)false, (Annotation[])new Annotation[0]);
        }
    }

    protected H instantiateDelegateInvocationHandler() {
        CreationalContext creationalContext = this.beanManager.createCreationalContext(this.handlerBean);
        InvocationHandler handlerInstance = (InvocationHandler)this.beanManager.getReference(this.handlerBean, this.delegateInvocationHandlerClass, creationalContext);
        if (this.handlerBean.getScope().equals(Dependent.class)) {
            this.creationalContextOfDependentHandler = creationalContext;
        }
        return (H)handlerInstance;
    }
}

