/*
 * Decompiled with CFR 0.152.
 */
package org.apache.deltaspike.core.impl.config.converter;

import java.lang.reflect.Constructor;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import org.apache.deltaspike.core.api.config.Config;
import org.apache.deltaspike.core.impl.config.converter.CtInjectionBeanConverter;
import org.apache.deltaspike.core.impl.config.converter.FieldInjectionBeanConverter;

public final class BeanConverterFactory {
    private final ConcurrentMap<Class<?>, BiFunction<Config, String, ?>> beanConverters = new ConcurrentHashMap();

    public <N> BiFunction<Config, String, N> detectConverter(Class<N> clazz) {
        BiFunction beanConverter = (FieldInjectionBeanConverter<N>)this.beanConverters.get(clazz);
        if (beanConverter == null) {
            List paramConstructors = Arrays.stream(clazz.getConstructors()).filter(ct -> ct.getParameterTypes().length > 0).collect(Collectors.toList());
            if (paramConstructors.size() > 1) {
                throw new IllegalStateException("Cannot handle beans with multiple non-default ct");
            }
            beanConverter = paramConstructors.size() == 0 ? new FieldInjectionBeanConverter<N>(clazz) : new CtInjectionBeanConverter<N>(clazz, (Constructor)paramConstructors.get(0));
            this.beanConverters.putIfAbsent(clazz, beanConverter);
        }
        return beanConverter;
    }
}

