/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.meta.etcd.service;

import io.etcd.jetcd.ByteSequence;
import io.etcd.jetcd.Client;
import io.etcd.jetcd.KeyValue;
import io.etcd.jetcd.kv.GetResponse;
import io.etcd.jetcd.options.GetOption;
import io.etcd.jetcd.options.PutOption;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.exception.MetaException;
import org.apache.eventmesh.api.meta.MetaService;
import org.apache.eventmesh.api.meta.MetaServiceListener;
import org.apache.eventmesh.api.meta.dto.EventMeshDataInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshRegisterInfo;
import org.apache.eventmesh.api.meta.dto.EventMeshUnRegisterInfo;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.ThreadPoolFactory;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.IPUtils;
import org.apache.eventmesh.common.utils.JsonUtils;
import org.apache.eventmesh.meta.etcd.factory.EtcdClientFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EtcdMetaService
implements MetaService {
    private static final Logger log = LoggerFactory.getLogger(EtcdMetaService.class);
    private final AtomicBoolean initStatus = new AtomicBoolean(false);
    private final AtomicBoolean startStatus = new AtomicBoolean(false);
    private static final String KEY_PREFIX = "/eventMesh/registry/";
    private String serverAddr;
    private String username;
    private String password;
    private String instanceIp;
    private String group;
    private Client etcdClient;
    private ConcurrentMap<String, EventMeshRegisterInfo> eventMeshRegisterInfoMap;
    private ScheduledExecutorService etcdRegistryMonitorExecutorService;

    public void init() throws MetaException {
        if (!this.initStatus.compareAndSet(false, true)) {
            return;
        }
        this.eventMeshRegisterInfoMap = new ConcurrentHashMap<String, EventMeshRegisterInfo>(ConfigurationContextUtil.KEYS.size());
        for (String key : ConfigurationContextUtil.KEYS) {
            CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
            if (null == commonConfiguration) continue;
            if (StringUtils.isBlank((CharSequence)commonConfiguration.getMetaStorageAddr())) {
                throw new MetaException("namesrvAddr cannot be null");
            }
            this.serverAddr = commonConfiguration.getMetaStorageAddr();
            this.username = commonConfiguration.getEventMeshMetaStoragePluginUsername();
            this.password = commonConfiguration.getEventMeshMetaStoragePluginPassword();
            this.instanceIp = IPUtils.getLocalAddress();
            this.group = commonConfiguration.getMeshGroup();
            break;
        }
        this.etcdRegistryMonitorExecutorService = ThreadPoolFactory.createSingleScheduledExecutor((String)"EtcdRegistryMonitorThread");
    }

    public void start() throws MetaException {
        if (!this.startStatus.compareAndSet(false, true)) {
            return;
        }
        try {
            Properties properties = new Properties();
            properties.setProperty("serverAddr", this.serverAddr);
            properties.setProperty("username", this.username);
            properties.setProperty("password", this.password);
            this.etcdClient = EtcdClientFactory.createClient(properties);
            this.etcdRegistryMonitorExecutorService.scheduleAtFixedRate(new EventMeshEtcdRegisterMonitor(), 15000L, 15000L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][start] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    public void shutdown() throws MetaException {
        if (!this.initStatus.compareAndSet(true, false)) {
            return;
        }
        if (!this.startStatus.compareAndSet(true, false)) {
            return;
        }
        try {
            if (this.etcdClient != null) {
                this.etcdClient.close();
            }
            if (this.etcdRegistryMonitorExecutorService != null && !this.etcdRegistryMonitorExecutorService.isShutdown()) {
                this.etcdRegistryMonitorExecutorService.shutdown();
            }
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][shutdown] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
        log.info("EtcdRegistryService closed");
    }

    public List<EventMeshDataInfo> findEventMeshInfoByCluster(String clusterName) throws MetaException {
        ArrayList<EventMeshDataInfo> eventMeshDataInfoList = new ArrayList<EventMeshDataInfo>();
        try {
            String keyPrefix = clusterName == null ? KEY_PREFIX : "/eventMesh/registry//" + clusterName;
            ByteSequence keyByteSequence = ByteSequence.from((byte[])keyPrefix.getBytes(Constants.DEFAULT_CHARSET));
            GetOption getOption = GetOption.newBuilder().withPrefix(keyByteSequence).build();
            List keyValues = ((GetResponse)this.etcdClient.getKVClient().get(keyByteSequence, getOption).get()).getKvs();
            if (CollectionUtils.isNotEmpty((Collection)keyValues)) {
                for (KeyValue kv : keyValues) {
                    EventMeshDataInfo eventMeshDataInfo = (EventMeshDataInfo)JsonUtils.parseObject((String)new String(kv.getValue().getBytes(), Constants.DEFAULT_CHARSET), EventMeshDataInfo.class);
                    eventMeshDataInfoList.add(eventMeshDataInfo);
                }
            }
        }
        catch (InterruptedException e) {
            log.error("[EtcdRegistryService][findEventMeshInfoByCluster] InterruptedException", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][findEventMeshInfoByCluster] error, clusterName: {}", (Object)clusterName, (Object)e);
            throw new MetaException(e.getMessage());
        }
        return eventMeshDataInfoList;
    }

    public List<EventMeshDataInfo> findAllEventMeshInfo() throws MetaException {
        try {
            return this.findEventMeshInfoByCluster(null);
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][findEventMeshInfoByCluster] error", (Throwable)e);
            throw new MetaException(e.getMessage());
        }
    }

    public void registerMetadata(Map<String, String> metadataMap) {
        for (Map.Entry eventMeshRegisterInfo : this.eventMeshRegisterInfoMap.entrySet()) {
            EventMeshRegisterInfo registerInfo = (EventMeshRegisterInfo)eventMeshRegisterInfo.getValue();
            registerInfo.setMetadata(metadataMap);
            this.register(registerInfo);
        }
    }

    public Map<String, String> getMetaData(String key, boolean fuzzyEnabled) {
        return null;
    }

    public void getMetaDataWithListener(MetaServiceListener metaServiceListener, String key) {
    }

    public void updateMetaData(Map<String, String> metadataMap) {
        String etcdMetaKey = this.instanceIp + "-" + this.group;
        ByteSequence key = ByteSequence.from((String)etcdMetaKey, (Charset)StandardCharsets.UTF_8);
        ByteSequence value = ByteSequence.from((String)Objects.requireNonNull(JsonUtils.toJSONString(metadataMap)), (Charset)StandardCharsets.UTF_8);
        this.etcdClient.getKVClient().put(key, value);
    }

    public void removeMetaData(String key) {
    }

    public boolean register(EventMeshRegisterInfo eventMeshRegisterInfo) throws MetaException {
        String eventMeshClusterName = eventMeshRegisterInfo.getEventMeshClusterName();
        String eventMeshName = eventMeshRegisterInfo.getEventMeshName();
        String endPoint = eventMeshRegisterInfo.getEndPoint();
        try {
            ByteSequence etcdKey = this.getEtcdKey(eventMeshClusterName, eventMeshName, endPoint);
            EventMeshDataInfo eventMeshDataInfo = new EventMeshDataInfo(eventMeshClusterName, eventMeshName, endPoint, System.currentTimeMillis(), eventMeshRegisterInfo.getMetadata());
            ByteSequence etcdValue = ByteSequence.from((byte[])Objects.requireNonNull(JsonUtils.toJSONString((Object)eventMeshDataInfo)).getBytes(Constants.DEFAULT_CHARSET));
            this.etcdClient.getKVClient().put(etcdKey, etcdValue, PutOption.newBuilder().withLeaseId(this.getLeaseId()).build());
            this.eventMeshRegisterInfoMap.put(eventMeshName, eventMeshRegisterInfo);
            log.info("EventMesh successfully registered to etcd, eventMeshClusterName: {}, eventMeshName: {}", (Object)eventMeshClusterName, (Object)eventMeshName);
            return true;
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][register] error, eventMeshClusterName: {}, eventMeshName: {}", new Object[]{eventMeshClusterName, eventMeshName, e});
            throw new MetaException(e.getMessage());
        }
    }

    public boolean unRegister(EventMeshUnRegisterInfo eventMeshUnRegisterInfo) throws MetaException {
        String eventMeshClusterName = eventMeshUnRegisterInfo.getEventMeshClusterName();
        String eventMeshName = eventMeshUnRegisterInfo.getEventMeshName();
        try {
            ByteSequence etcdKey = this.getEtcdKey(eventMeshClusterName, eventMeshName, eventMeshUnRegisterInfo.getEndPoint());
            this.etcdClient.getKVClient().delete(etcdKey);
            this.eventMeshRegisterInfoMap.remove(eventMeshName);
            log.info("EventMesh successfully logout to etcd, eventMeshClusterName: {}, eventMeshName: {}", (Object)eventMeshClusterName, (Object)eventMeshName);
            return true;
        }
        catch (Exception e) {
            log.error("[EtcdRegistryService][unRegister] error, eventMeshClusterName: {}, eventMeshName: {}", new Object[]{eventMeshClusterName, eventMeshName, e});
            throw new MetaException(e.getMessage());
        }
    }

    public long getLeaseId() {
        return EtcdClientFactory.getLeaseId(this.serverAddr);
    }

    private ByteSequence getEtcdKey(String eventMeshClusterName, String eventMeshName, String endPoint) {
        StringBuilder etcdKey = new StringBuilder(KEY_PREFIX).append(eventMeshClusterName);
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{eventMeshName})) {
            etcdKey.append("/").append(eventMeshName);
        }
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{endPoint})) {
            etcdKey.append("/").append(endPoint);
        }
        return ByteSequence.from((byte[])etcdKey.toString().getBytes(Constants.DEFAULT_CHARSET));
    }

    public Client getEtcdClient() {
        return this.etcdClient;
    }

    private class EventMeshEtcdRegisterMonitor
    implements Runnable {
        private EventMeshEtcdRegisterMonitor() {
        }

        @Override
        public void run() {
            if (EtcdMetaService.this.eventMeshRegisterInfoMap.size() > 0) {
                for (Map.Entry eventMeshRegisterInfoEntry : EtcdMetaService.this.eventMeshRegisterInfoMap.entrySet()) {
                    EventMeshRegisterInfo eventMeshRegisterInfo = (EventMeshRegisterInfo)eventMeshRegisterInfoEntry.getValue();
                    ByteSequence etcdKey = EtcdMetaService.this.getEtcdKey(eventMeshRegisterInfo.getEventMeshClusterName(), eventMeshRegisterInfo.getEventMeshName(), eventMeshRegisterInfo.getEndPoint());
                    List keyValues = null;
                    try {
                        keyValues = ((GetResponse)EtcdMetaService.this.etcdClient.getKVClient().get(etcdKey).get()).getKvs();
                    }
                    catch (InterruptedException e) {
                        log.error("get etcdKey[{}] failed[InterruptedException]", (Object)etcdKey, (Object)e);
                        Thread.currentThread().interrupt();
                    }
                    catch (ExecutionException e) {
                        log.error("get etcdKey[{}] failed", (Object)etcdKey, (Object)e);
                    }
                    if (!CollectionUtils.isEmpty(keyValues)) continue;
                    log.warn("eventMeshRegisterInfo [{}] is not matched in Etcd , try to register again", (Object)eventMeshRegisterInfo.getEventMeshName());
                    EtcdClientFactory.renewalLeaseId(EtcdClientFactory.getEtcdLeaseId(EtcdMetaService.this.serverAddr));
                    EtcdMetaService.this.register(eventMeshRegisterInfo);
                }
            }
        }
    }
}

