/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.common.profiler.trace;

import com.navercorp.pinpoint.common.trace.AnnotationKey;
import com.navercorp.pinpoint.common.trace.AnnotationKeyLocator;
import com.navercorp.pinpoint.common.util.apache.IntHashMap;
import com.navercorp.pinpoint.common.util.apache.IntHashMapUtils;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;

public class AnnotationKeyRegistry
implements AnnotationKeyLocator {
    private final IntHashMap<AnnotationKey> codeLookupTable;
    private final Map<String, AnnotationKey> nameLookupTable;
    private final IntHashMap<AnnotationKey> apiErrorLookupTable;

    private AnnotationKeyRegistry(HashMap<Integer, AnnotationKey> buildMap) {
        Objects.requireNonNull(buildMap, "buildMap");
        this.codeLookupTable = IntHashMapUtils.copy(buildMap);
        this.nameLookupTable = this.buildNameTable(buildMap.values());
        this.apiErrorLookupTable = this.buildApiMetaDataError(buildMap.values());
    }

    private Map<String, AnnotationKey> buildNameTable(Collection<AnnotationKey> buildMap) {
        HashMap<String, AnnotationKey> nameLookupTable = new HashMap<String, AnnotationKey>();
        for (AnnotationKey annotationKey : buildMap) {
            AnnotationKey exist = nameLookupTable.put(annotationKey.getName(), annotationKey);
            if (exist == null) continue;
            AnnotationKeyRegistry.throwDuplicatedAnnotationKey(annotationKey, exist);
        }
        return nameLookupTable;
    }

    private static void throwDuplicatedAnnotationKey(AnnotationKey annotationKey, AnnotationKey exist) {
        throw new IllegalStateException("already exist. annotationKey:" + annotationKey + ", exist:" + exist);
    }

    private IntHashMap<AnnotationKey> buildApiMetaDataError(Collection<AnnotationKey> buildMap) {
        IntHashMap table = new IntHashMap();
        for (AnnotationKey annotationKey : buildMap) {
            if (!annotationKey.isErrorApiMetadata()) continue;
            table.put(annotationKey.getCode(), (Object)annotationKey);
        }
        return table;
    }

    public AnnotationKey findAnnotationKey(int code) {
        AnnotationKey annotationKey = (AnnotationKey)this.codeLookupTable.get(code);
        if (annotationKey == null) {
            return AnnotationKey.UNKNOWN;
        }
        return annotationKey;
    }

    public AnnotationKey findAnnotationKeyByName(String keyName) {
        AnnotationKey annotationKey = this.nameLookupTable.get(keyName);
        if (annotationKey == null) {
            throw new NoSuchElementException(keyName);
        }
        return annotationKey;
    }

    public AnnotationKey findApiErrorCode(int annotationCode) {
        return (AnnotationKey)this.apiErrorLookupTable.get(annotationCode);
    }

    static class Builder {
        private final HashMap<Integer, AnnotationKey> buildMap = new HashMap();

        Builder() {
        }

        void addAnnotationKey(AnnotationKey annotationKey) {
            Objects.requireNonNull(annotationKey, "annotationKey");
            int code = annotationKey.getCode();
            AnnotationKey exist = this.buildMap.put(code, annotationKey);
            if (exist != null) {
                AnnotationKeyRegistry.throwDuplicatedAnnotationKey(annotationKey, exist);
            }
        }

        AnnotationKeyRegistry build() {
            return new AnnotationKeyRegistry(this.buildMap);
        }
    }
}

