/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.retry.rocketmq;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import java.util.Objects;
import org.apache.eventmesh.api.SendCallback;
import org.apache.eventmesh.api.SendResult;
import org.apache.eventmesh.api.exception.OnExceptionContext;
import org.apache.eventmesh.api.producer.Producer;
import org.apache.eventmesh.common.protocol.http.common.ProtocolKey;
import org.apache.eventmesh.retry.api.conf.RetryConfiguration;
import org.apache.eventmesh.retry.api.strategy.RetryStrategy;
import org.apache.rocketmq.common.MixAll;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RocketMQRetryStrategyImpl
implements RetryStrategy {
    private static final Logger log = LoggerFactory.getLogger(RocketMQRetryStrategyImpl.class);

    public void retry(RetryConfiguration configuration) {
        this.sendMessageBack(configuration);
    }

    private void sendMessageBack(RetryConfiguration configuration) {
        CloudEvent event = configuration.getEvent();
        String topic = configuration.getTopic();
        final String consumerGroupName = configuration.getConsumerGroupName();
        String retryTopicName = MixAll.getRetryTopic((String)consumerGroupName);
        final String bizSeqNo = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.BIZSEQNO.getKey())).toString();
        final String uniqueId = Objects.requireNonNull(event.getExtension(ProtocolKey.ClientInstanceKey.UNIQUEID.getKey())).toString();
        CloudEvent retryEvent = CloudEventBuilder.from((CloudEvent)event).withExtension("topic", topic).withSubject(retryTopicName).build();
        Producer producer = configuration.getProducer();
        producer.publish(retryEvent, new SendCallback(){

            public void onSuccess(SendResult sendResult) {
                log.info("consumer:{} consume success,, bizSeqno:{}, uniqueId:{}", new Object[]{consumerGroupName, bizSeqNo, uniqueId});
            }

            public void onException(OnExceptionContext context) {
                log.warn("consumer:{} consume fail, sendMessageBack, bizSeqno:{}, uniqueId:{}", new Object[]{consumerGroupName, bizSeqNo, uniqueId, context.getException()});
            }
        });
    }
}

