/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.kafka.admin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.eventmesh.api.admin.AbstractAdmin;
import org.apache.eventmesh.api.admin.TopicProperties;
import org.apache.eventmesh.common.config.ConfigService;
import org.apache.eventmesh.storage.kafka.config.ClientConfiguration;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ListOffsetsResult;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.TopicPartitionInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaAdmin
extends AbstractAdmin {
    private static final Logger log = LoggerFactory.getLogger(KafkaAdmin.class);
    private static final Properties kafkaProps = new Properties();
    private static final Map<String, Integer> topicProps = new HashMap<String, Integer>();

    public KafkaAdmin() {
        super(new AtomicBoolean(false));
        ConfigService configService = ConfigService.getInstance();
        ClientConfiguration clientConfiguration = (ClientConfiguration)configService.buildConfigInstance(ClientConfiguration.class);
        kafkaProps.put("bootstrap.servers", clientConfiguration.getNamesrvAddr());
        topicProps.put("partitionNum", clientConfiguration.getPartitions());
        topicProps.put("replicationFactorNum", Integer.valueOf(clientConfiguration.getReplicationFactors()));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<TopicProperties> getTopic() {
        try (Admin client = Admin.create((Properties)kafkaProps);){
            Set topicList = (Set)client.listTopics().names().get(10L, TimeUnit.SECONDS);
            Map topicDescriptionFutures = client.describeTopics((Collection)topicList).values();
            ArrayList<TopicProperties> result = new ArrayList<TopicProperties>();
            for (Map.Entry entry : topicDescriptionFutures.entrySet()) {
                String topicName = (String)entry.getKey();
                TopicDescription topicDescription = (TopicDescription)((KafkaFuture)entry.getValue()).get(10L, TimeUnit.SECONDS);
                long messageCount = topicDescription.partitions().stream().mapToInt(TopicPartitionInfo::partition).mapToLong(partition -> {
                    try {
                        return this.getMsgCount(topicName, partition, client);
                    }
                    catch (TimeoutException e) {
                        log.error("Failed to get msg offset when listing topics. Kafka response timed out in {} seconds.", (Object)10);
                        throw new RuntimeException(e);
                    }
                    catch (InterruptedException | ExecutionException e) {
                        log.error("Failed to get msg offset when listing topics.", (Throwable)e);
                        throw new RuntimeException(e);
                    }
                }).sum();
                result.add(new TopicProperties(topicName, messageCount));
            }
            result.sort(Comparator.comparing(t -> t.name));
            ArrayList<TopicProperties> arrayList = result;
            return arrayList;
        }
        catch (TimeoutException e) {
            log.error("Failed to list topics. Kafka response timed out in {} seconds.", (Object)10);
            throw new RuntimeException(e);
        }
        catch (Exception e) {
            log.error("Failed to list topics.", (Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private long getMsgCount(String topicName, int partition, Admin client) throws ExecutionException, InterruptedException, TimeoutException {
        TopicPartition topicPartition = new TopicPartition(topicName, partition);
        long earliestOffset = this.getOffset(topicPartition, OffsetSpec.earliest(), client);
        long latestOffset = this.getOffset(topicPartition, OffsetSpec.latest(), client);
        return latestOffset - earliestOffset;
    }

    private long getOffset(TopicPartition topicPartition, OffsetSpec offsetSpec, Admin client) throws ExecutionException, InterruptedException, TimeoutException {
        Map<TopicPartition, OffsetSpec> offsetSpecMap = Collections.singletonMap(topicPartition, offsetSpec);
        Map offsetResultMap = (Map)client.listOffsets(offsetSpecMap).all().get(10L, TimeUnit.SECONDS);
        return ((ListOffsetsResult.ListOffsetsResultInfo)offsetResultMap.get(topicPartition)).offset();
    }

    public void createTopic(String topicName) {
        try (Admin client = Admin.create((Properties)kafkaProps);){
            NewTopic newTopic = new NewTopic(topicName, topicProps.get("partitionNum").intValue(), topicProps.get("replicationFactorNum").shortValue());
            client.createTopics(Collections.singletonList(newTopic)).all().get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error("Failed to create topic. Kafka response timed out in {} seconds.", (Object)10);
        }
        catch (Exception e) {
            log.error("Failed to create topic.", (Throwable)e);
        }
    }

    public void deleteTopic(String topicName) {
        try (Admin client = Admin.create((Properties)kafkaProps);){
            client.deleteTopics(Collections.singletonList(topicName)).all().get(10L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error("Failed to delete topic. Kafka response timed out in {} seconds.", (Object)10);
        }
        catch (Exception e) {
            log.error("Failed to delete topic.", (Throwable)e);
        }
    }
}

