/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.storage.rocketmq.cloudevent.impl;

import io.cloudevents.CloudEventData;
import io.cloudevents.SpecVersion;
import io.cloudevents.core.format.EventFormat;
import io.cloudevents.core.message.MessageWriter;
import io.cloudevents.rw.CloudEventContextWriter;
import io.cloudevents.rw.CloudEventRWException;
import io.cloudevents.rw.CloudEventWriter;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.storage.rocketmq.cloudevent.impl.RocketMQHeaders;
import org.apache.rocketmq.common.message.Message;

public final class RocketMQMessageWriter<R>
implements MessageWriter<CloudEventWriter<Message>, Message>,
CloudEventWriter<Message> {
    private final Message message = new Message();

    public RocketMQMessageWriter(String topic) {
        this.message.setTopic(topic);
    }

    public RocketMQMessageWriter(String topic, String keys) {
        this.message.setTopic(topic);
        if (StringUtils.isNotEmpty((CharSequence)keys)) {
            this.message.setKeys(keys);
        }
    }

    public RocketMQMessageWriter(String topic, String keys, String tags) {
        this.message.setTopic(topic);
        if (StringUtils.isNotEmpty((CharSequence)tags)) {
            this.message.setTags(tags);
        }
        if (StringUtils.isNotEmpty((CharSequence)keys)) {
            this.message.setKeys(keys);
        }
    }

    public CloudEventContextWriter withContextAttribute(@Nonnull String name, @Nonnull String value) throws CloudEventRWException {
        this.message.putUserProperty(name, value);
        return this;
    }

    public RocketMQMessageWriter<R> create(SpecVersion version) {
        this.message.putUserProperty(RocketMQHeaders.SPEC_VERSION, version.toString());
        return this;
    }

    public Message setEvent(@Nonnull EventFormat format, @Nonnull byte[] value) throws CloudEventRWException {
        this.message.putUserProperty(RocketMQHeaders.CONTENT_TYPE, format.serializedContentType());
        this.message.setBody(value);
        return this.message;
    }

    public Message end(CloudEventData data) throws CloudEventRWException {
        this.message.setBody(data.toBytes());
        return this.message;
    }

    public Message end() {
        return this.message;
    }
}

