/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.workflow;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import org.apache.eventmesh.client.selector.Selector;
import org.apache.eventmesh.client.selector.SelectorFactory;
import org.apache.eventmesh.client.selector.ServiceInstance;
import org.apache.eventmesh.client.workflow.config.EventMeshWorkflowClientConfig;
import org.apache.eventmesh.common.protocol.workflow.protos.ExecuteRequest;
import org.apache.eventmesh.common.protocol.workflow.protos.ExecuteResponse;
import org.apache.eventmesh.common.protocol.workflow.protos.WorkflowGrpc;
import org.apache.eventmesh.common.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshWorkflowClient {
    private static final Logger log = LoggerFactory.getLogger(EventMeshWorkflowClient.class);
    private final transient EventMeshWorkflowClientConfig clientConfig;

    public EventMeshWorkflowClient(EventMeshWorkflowClientConfig clientConfig) {
        this.clientConfig = clientConfig;
    }

    public WorkflowGrpc.WorkflowBlockingStub getWorkflowClient() throws Exception {
        Selector selector = SelectorFactory.get(this.clientConfig.getSelectorType());
        if (selector == null) {
            throw new Exception(String.format("selector=%s not register.please check it.", this.clientConfig.getSelectorType()));
        }
        ServiceInstance instance = selector.selectOne(this.clientConfig.getServerName());
        if (instance == null) {
            throw new Exception("workflow server is not running.please check it.");
        }
        ManagedChannel channel = ManagedChannelBuilder.forAddress((String)instance.getHost(), (int)instance.getPort()).usePlaintext().build();
        return WorkflowGrpc.newBlockingStub((Channel)channel);
    }

    public ExecuteResponse execute(ExecuteRequest request) throws Exception {
        WorkflowGrpc.WorkflowBlockingStub workflowClient = this.getWorkflowClient();
        ExecuteResponse response = workflowClient.execute(request);
        LogUtils.info((Logger)log, (String)"received response:{}", (Object)response);
        return response;
    }
}

