/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.kafka.source.connector;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.apache.eventmesh.connector.kafka.source.config.KafkaSourceConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SourceConnectorContext;
import org.apache.eventmesh.openconnect.api.source.Source;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordOffset;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.RecordPartition;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.clients.consumer.KafkaConsumer;

public class KafkaSourceConnector
implements Source {
    private KafkaSourceConfig sourceConfig;
    private KafkaConsumer<String, String> kafkaConsumer;
    private int pollTimeOut = 100;

    public Class<? extends Config> configClass() {
        return KafkaSourceConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sourceConfig = (KafkaSourceConfig)config;
        this.doInit();
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SourceConnectorContext sourceConnectorContext = (SourceConnectorContext)connectorContext;
        this.sourceConfig = (KafkaSourceConfig)sourceConnectorContext.getSourceConfig();
        this.doInit();
    }

    private void doInit() {
        Properties props = new Properties();
        props.put("bootstrap.servers", this.sourceConfig.getConnectorConfig().getBootstrapServers());
        props.put("key.deserializer", this.sourceConfig.getConnectorConfig().getKeyConverter());
        props.put("value.deserializer", this.sourceConfig.getConnectorConfig().getValueConverter());
        props.put("group.id", this.sourceConfig.getConnectorConfig().getGroupID());
        props.put("enable.auto.commit", this.sourceConfig.getConnectorConfig().getEnableAutoCommit());
        props.put("max.poll.records", this.sourceConfig.getConnectorConfig().getMaxPollRecords());
        props.put("auto.commit.interval.ms", this.sourceConfig.getConnectorConfig().getAutoCommitIntervalMS());
        props.put("session.timeout.ms", this.sourceConfig.getConnectorConfig().getSessionTimeoutMS());
        this.pollTimeOut = this.sourceConfig.getConnectorConfig().getPollTimeOut();
        this.kafkaConsumer = new KafkaConsumer(props);
    }

    public void start() throws Exception {
        this.kafkaConsumer.subscribe(Collections.singleton(this.sourceConfig.getConnectorConfig().getTopic()));
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sourceConfig.getConnectorConfig().getConnectorName();
    }

    public void stop() {
        this.kafkaConsumer.unsubscribe();
    }

    public List<ConnectRecord> poll() {
        ConsumerRecords records = this.kafkaConsumer.poll(Duration.ofMillis(this.pollTimeOut));
        ArrayList<ConnectRecord> connectRecords = new ArrayList<ConnectRecord>(records.count());
        for (ConsumerRecord record : records) {
            Long timestamp = System.currentTimeMillis();
            String key = (String)record.key();
            String value = (String)record.value();
            RecordPartition recordPartition = KafkaSourceConnector.convertToRecordPartition(record.topic(), record.partition());
            RecordOffset recordOffset = KafkaSourceConnector.convertToRecordOffset(record.offset());
            ConnectRecord connectRecord = new ConnectRecord(recordPartition, recordOffset, timestamp, (Object)value);
            connectRecord.addExtension("key", (Object)key);
            connectRecords.add(connectRecord);
        }
        this.kafkaConsumer.commitAsync();
        return connectRecords;
    }

    public static RecordOffset convertToRecordOffset(Long offset) {
        HashMap<String, String> offsetMap = new HashMap<String, String>();
        offsetMap.put("queueOffset", offset + "");
        return new RecordOffset(offsetMap);
    }

    public static RecordPartition convertToRecordPartition(String topic, int partition) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("topic", topic);
        map.put("partition", String.valueOf(partition));
        return new RecordPartition(map);
    }
}

