/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.auth.token.impl.auth;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.JwtParser;
import io.jsonwebtoken.Jwts;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.api.acl.AclProperties;
import org.apache.eventmesh.api.exception.AclException;
import org.apache.eventmesh.common.config.CommonConfiguration;
import org.apache.eventmesh.common.utils.ConfigurationContextUtil;
import org.apache.eventmesh.common.utils.TypeUtils;

public class AuthTokenUtils {
    public static void authTokenByPublicKey(AclProperties aclProperties) {
        block10: {
            String token = aclProperties.getToken();
            if (StringUtils.isNotBlank((CharSequence)token)) {
                if (!AuthTokenUtils.authAccess(aclProperties)) {
                    throw new AclException("group:" + aclProperties.getExtendedField("group ") + " has no auth to access the topic:" + aclProperties.getTopic());
                }
                String publicKeyUrl = null;
                token = token.replace("Bearer ", "");
                for (String key : ConfigurationContextUtil.KEYS) {
                    CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
                    if (null == commonConfiguration) continue;
                    if (StringUtils.isBlank((CharSequence)commonConfiguration.getEventMeshSecurityPublickey())) {
                        throw new AclException("publicKeyUrl cannot be null");
                    }
                    publicKeyUrl = commonConfiguration.getEventMeshSecurityPublickey();
                }
                byte[] validationKeyBytes = new byte[]{};
                try {
                    validationKeyBytes = Files.readAllBytes(Paths.get(publicKeyUrl, new String[0]));
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(validationKeyBytes);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    PublicKey validationKey = kf.generatePublic(spec);
                    JwtParser signedParser = Jwts.parserBuilder().setSigningKey((Key)validationKey).build();
                    Jws signJwt = signedParser.parseClaimsJws(token);
                    String sub = (String)((Claims)signJwt.getBody()).get("sub", String.class);
                    if (!sub.contains(aclProperties.getExtendedField("group").toString()) && !sub.contains("pulsar-admin")) {
                        throw new AclException("group:" + aclProperties.getExtendedField("group ") + " has no auth to access eventMesh:" + aclProperties.getTopic());
                    }
                    break block10;
                }
                catch (IOException e) {
                    throw new AclException("public key read error!", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AclException("no such RSA algorithm!", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    throw new AclException("invalid public key spec!", (Throwable)e);
                }
                catch (JwtException e) {
                    throw new AclException("invalid token!", (Throwable)e);
                }
            }
            throw new AclException("invalid token!");
        }
    }

    public static void helloTaskAuthTokenByPublicKey(AclProperties aclProperties) {
        block9: {
            String token = aclProperties.getToken();
            if (StringUtils.isNotBlank((CharSequence)token)) {
                String publicKeyUrl = null;
                token = token.replace("Bearer ", "");
                for (String key : ConfigurationContextUtil.KEYS) {
                    CommonConfiguration commonConfiguration = ConfigurationContextUtil.get((String)key);
                    if (null == commonConfiguration) continue;
                    if (StringUtils.isBlank((CharSequence)commonConfiguration.getEventMeshSecurityPublickey())) {
                        throw new AclException("publicKeyUrl cannot be null");
                    }
                    publicKeyUrl = commonConfiguration.getEventMeshSecurityPublickey();
                }
                byte[] validationKeyBytes = new byte[]{};
                try {
                    validationKeyBytes = Files.readAllBytes(Paths.get(publicKeyUrl, new String[0]));
                    X509EncodedKeySpec spec = new X509EncodedKeySpec(validationKeyBytes);
                    KeyFactory kf = KeyFactory.getInstance("RSA");
                    PublicKey validationKey = kf.generatePublic(spec);
                    JwtParser signedParser = Jwts.parserBuilder().setSigningKey((Key)validationKey).build();
                    Jws signJwt = signedParser.parseClaimsJws(token);
                    String sub = (String)((Claims)signJwt.getBody()).get("sub", String.class);
                    if (!sub.contains(aclProperties.getExtendedField("group").toString()) && !sub.contains("pulsar-admin")) {
                        throw new AclException("group:" + aclProperties.getExtendedField("group ") + " has no auth to access eventMesh:" + aclProperties.getTopic());
                    }
                    break block9;
                }
                catch (IOException e) {
                    throw new AclException("public key read error!", (Throwable)e);
                }
                catch (NoSuchAlgorithmException e) {
                    throw new AclException("no such RSA algorithm!", (Throwable)e);
                }
                catch (InvalidKeySpecException e) {
                    throw new AclException("invalid public key spec!", (Throwable)e);
                }
                catch (JwtException e) {
                    throw new AclException("invalid token!", (Throwable)e);
                }
            }
            throw new AclException("invalid token!");
        }
    }

    public static boolean authAccess(AclProperties aclProperties) {
        String topic = aclProperties.getTopic();
        Object topics = aclProperties.getExtendedField("topics");
        if (!(topics instanceof Set)) {
            return false;
        }
        Set groupTopics = TypeUtils.castSet((Object)topics, String.class);
        return groupTopics.contains(topic);
    }
}

