/*
 * Decompiled with CFR 0.152.
 */
package io.pravega.client.state.impl;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import io.pravega.client.segment.impl.Segment;
import io.pravega.client.state.InitialUpdate;
import io.pravega.client.state.Revision;
import io.pravega.client.state.Revisioned;
import io.pravega.client.state.RevisionedStreamClient;
import io.pravega.client.state.StateSynchronizer;
import io.pravega.client.state.Update;
import io.pravega.client.state.impl.RevisionImpl;
import io.pravega.client.state.impl.UpdateOrInit;
import io.pravega.client.stream.TruncatedDataException;
import io.pravega.common.util.Retry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import javax.annotation.concurrent.GuardedBy;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StateSynchronizerImpl<StateT extends Revisioned>
implements StateSynchronizer<StateT> {
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private static final Logger log = LoggerFactory.getLogger(StateSynchronizerImpl.class);
    @SuppressFBWarnings(justification="generated code")
    @Generated
    private final Object $lock = new Object[0];
    private static final Retry.RetryWithBackoff RETRY_INDEFINITELY = Retry.withExpBackoff((long)1L, (int)1, (int)Integer.MAX_VALUE);
    private final RevisionedStreamClient<UpdateOrInit<StateT>> client;
    @GuardedBy(value="$lock")
    private StateT currentState;
    private Segment segment;

    public StateSynchronizerImpl(Segment segment, RevisionedStreamClient<UpdateOrInit<StateT>> client) {
        this.segment = segment;
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StateT getState() {
        Object object = this.$lock;
        synchronized (object) {
            return this.currentState;
        }
    }

    private Revision getRevisionToReadFrom(boolean useState) {
        Revision revision;
        StateT state = this.getState();
        if (!useState || state == null) {
            revision = this.client.getMark();
            if (revision == null) {
                revision = this.client.fetchOldestRevision();
            }
        } else {
            revision = state.getRevision();
        }
        return revision;
    }

    @Override
    public void fetchUpdates() {
        Revision revision = this.getRevisionToReadFrom(true);
        log.trace("Fetching updates after {} ", (Object)revision);
        try {
            Iterator<Map.Entry<Revision, UpdateOrInit<StateT>>> iter = this.client.readFrom(revision);
            while (iter.hasNext()) {
                Map.Entry<Revision, UpdateOrInit<StateT>> entry = iter.next();
                log.trace("Found entry {} ", entry.getValue());
                if (entry.getValue().isInit()) {
                    InitialUpdate<StateT> init = entry.getValue().getInit();
                    this.updateCurrentState(init.create(this.segment.getScopedStreamName(), entry.getKey()));
                    continue;
                }
                this.applyUpdates(entry.getKey().asImpl(), entry.getValue().getUpdates());
            }
        }
        catch (TruncatedDataException e) {
            log.info("{} encountered truncation on segment {}, Details: {}", new Object[]{this, this.segment, e.getMessage()});
            RETRY_INDEFINITELY.retryingOn(TruncatedDataException.class).throwingOn(RuntimeException.class).run(() -> this.handleTruncation());
        }
    }

    private Void handleTruncation() {
        Revision revision = this.getRevisionToReadFrom(false);
        log.info("{} encountered truncation, attempting to read from revision {}", (Object)this, (Object)revision);
        boolean foundInit = false;
        Iterator<Map.Entry<Revision, UpdateOrInit<StateT>>> iter = this.client.readFrom(revision);
        Revision currentRevision = null;
        while (!foundInit && iter.hasNext()) {
            Map.Entry<Revision, UpdateOrInit<StateT>> entry = iter.next();
            currentRevision = entry.getKey();
            if (!entry.getValue().isInit()) continue;
            log.trace("Found entry {} ", entry.getValue());
            InitialUpdate<StateT> init = entry.getValue().getInit();
            foundInit = true;
            this.updateCurrentState(init.create(this.segment.getScopedStreamName(), currentRevision));
        }
        if (!foundInit) {
            throw new IllegalStateException(String.format("Data was truncated but there is no Init state after the truncation point. Last read revision is %s", currentRevision));
        }
        this.fetchUpdates();
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyUpdates(Revision readRevision, List<? extends Update<StateT>> updates) {
        int i = 0;
        for (Update<StateT> update : updates) {
            StateT state;
            StateT StateT = state = this.getState();
            synchronized (StateT) {
                RevisionImpl newRevision = new RevisionImpl(this.segment, readRevision.asImpl().getOffsetInSegment(), i++);
                if (newRevision.compareTo(state.getRevision()) > 0) {
                    this.updateCurrentState(update.applyTo(state, newRevision));
                }
            }
        }
    }

    @Override
    public void updateState(StateSynchronizer.UpdateGenerator<StateT> updateGenerator) {
        this.conditionallyWrite(state -> {
            ArrayList update = new ArrayList();
            updateGenerator.accept(state, update);
            return update.isEmpty() ? null : new UpdateOrInit(update);
        });
    }

    @Override
    public <ReturnT> ReturnT updateState(StateSynchronizer.UpdateGeneratorFunction<StateT, ReturnT> updateGenerator) {
        AtomicReference result = new AtomicReference();
        this.conditionallyWrite(state -> {
            ArrayList update = new ArrayList();
            result.set(updateGenerator.apply(state, update));
            return update.isEmpty() ? null : new UpdateOrInit(update);
        });
        return (ReturnT)result.get();
    }

    @Override
    public void updateStateUnconditionally(Update<StateT> update) {
        log.trace("Unconditionally Writing {} ", update);
        this.client.writeUnconditionally(new UpdateOrInit<StateT>(Collections.singletonList(update)));
    }

    @Override
    public void updateStateUnconditionally(List<? extends Update<StateT>> update) {
        log.trace("Unconditionally Writing {} ", update);
        this.client.writeUnconditionally(new UpdateOrInit(update));
    }

    @Override
    public void initialize(InitialUpdate<StateT> initial) {
        Revision result = this.client.writeConditionally(this.client.fetchOldestRevision(), new UpdateOrInit<StateT>(initial));
        if (result == null) {
            this.fetchUpdates();
        } else {
            this.updateCurrentState(initial.create(this.segment.getScopedStreamName(), result));
        }
    }

    @Override
    public long bytesWrittenSinceCompaction() {
        Revision mark = this.client.getMark();
        StateT state = this.getState();
        long compaction = mark == null ? 0L : mark.asImpl().getOffsetInSegment();
        long current = state == null ? 0L : state.getRevision().asImpl().getOffsetInSegment();
        return Math.max(0L, current - compaction);
    }

    @Override
    public void compact(Function<StateT, InitialUpdate<StateT>> compactor) {
        AtomicReference<Object> compactedVersion = new AtomicReference<Object>(null);
        this.conditionallyWrite(state -> {
            InitialUpdate init = (InitialUpdate)compactor.apply(state);
            if (init == null) {
                compactedVersion.set(null);
                return null;
            }
            compactedVersion.set(state.getRevision());
            return new UpdateOrInit(init);
        });
        Revision newMark = compactedVersion.get();
        if (newMark != null) {
            Revision oldMark = this.client.getMark();
            if (oldMark == null || oldMark.compareTo(newMark) < 0) {
                this.client.compareAndSetMark(oldMark, newMark);
                log.info("Compacted state is written at {} the oldMark is {}", (Object)newMark, (Object)oldMark);
            }
            if (oldMark != null) {
                this.client.truncateToRevision(oldMark);
            }
        }
    }

    private void conditionallyWrite(Function<StateT, UpdateOrInit<StateT>> generator) {
        block5: {
            Revision newRevision;
            UpdateOrInit<StateT> toWrite;
            while (true) {
                StateT state;
                if ((state = this.getState()) == null) {
                    this.fetchUpdates();
                    state = this.getState();
                    if (state == null) {
                        throw new IllegalStateException("Write was called before the state was initialized.");
                    }
                }
                log.trace("Conditionally Writing {} ", state);
                Revision revision = state.getRevision();
                toWrite = generator.apply(state);
                if (toWrite == null) {
                    log.debug("Conditional write to segment {} completed as there is nothing to update after revision {}", (Object)this.segment, (Object)revision);
                    break block5;
                }
                newRevision = this.client.writeConditionally(revision, toWrite);
                log.trace("Conditional write returned {} ", (Object)newRevision);
                if (newRevision != null) break;
                this.fetchUpdates();
            }
            if (!toWrite.isInit()) {
                this.applyUpdates(newRevision, toWrite.getUpdates());
            }
            log.debug("Conditional write to segment {} completed with revision {}", (Object)this.segment, (Object)newRevision);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isNewer(Revision revision) {
        Object object = this.$lock;
        synchronized (object) {
            boolean result;
            boolean bl = result = this.currentState == null || this.currentState.getRevision().compareTo(revision) < 0;
            if (!result) {
                log.debug("In memory state {} is newer than the provided revision {}", (Object)this.currentState.getRevision(), (Object)revision);
            }
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentState(StateT newValue) {
        Object object = this.$lock;
        synchronized (object) {
            if (newValue != null && this.isNewer(newValue.getRevision())) {
                log.trace("Updating new state to {} ", (Object)newValue.getRevision());
                this.currentState = newValue;
            }
        }
    }

    @Override
    public void close() {
        log.info("Closing stateSynchronizer {}", (Object)this);
        this.client.close();
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "StateSynchronizerImpl(currentState=" + this.currentState + ", segment=" + this.segment + ")";
    }
}

