/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.lark.sink.config;

import com.lark.oapi.service.im.v1.enums.ReceiveIdTypeEnum;
import org.apache.commons.lang3.StringUtils;

public class SinkConnectorConfig {
    private String connectorName = "larkSink";
    private String appId;
    private String appSecret;
    private String receiveIdType = "open_id";
    private String receiveId;
    private String sinkAsync = "true";
    private String maxRetryTimes = "3";
    private String retryDelayInMills = "1000";

    public void validateSinkConfiguration() {
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{this.appId, this.appSecret, this.receiveId})) {
            throw new IllegalArgumentException("appId or appSecret or receiveId is blank,please check it.");
        }
        if (!StringUtils.containsAny((CharSequence)this.receiveIdType, (CharSequence[])new CharSequence[]{ReceiveIdTypeEnum.CHAT_ID.getValue(), ReceiveIdTypeEnum.EMAIL.getValue(), ReceiveIdTypeEnum.OPEN_ID.getValue(), ReceiveIdTypeEnum.USER_ID.getValue(), ReceiveIdTypeEnum.UNION_ID.getValue()})) {
            throw new IllegalArgumentException(String.format("sinkConnectorConfig.receiveIdType=[%s], Invalid.", this.receiveIdType));
        }
    }

    public String getConnectorName() {
        return this.connectorName;
    }

    public String getAppId() {
        return this.appId;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getReceiveIdType() {
        return this.receiveIdType;
    }

    public String getReceiveId() {
        return this.receiveId;
    }

    public String getSinkAsync() {
        return this.sinkAsync;
    }

    public String getMaxRetryTimes() {
        return this.maxRetryTimes;
    }

    public String getRetryDelayInMills() {
        return this.retryDelayInMills;
    }

    public void setConnectorName(String connectorName) {
        this.connectorName = connectorName;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setReceiveIdType(String receiveIdType) {
        this.receiveIdType = receiveIdType;
    }

    public void setReceiveId(String receiveId) {
        this.receiveId = receiveId;
    }

    public void setSinkAsync(String sinkAsync) {
        this.sinkAsync = sinkAsync;
    }

    public void setMaxRetryTimes(String maxRetryTimes) {
        this.maxRetryTimes = maxRetryTimes;
    }

    public void setRetryDelayInMills(String retryDelayInMills) {
        this.retryDelayInMills = retryDelayInMills;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SinkConnectorConfig)) {
            return false;
        }
        SinkConnectorConfig other = (SinkConnectorConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$connectorName = this.getConnectorName();
        String other$connectorName = other.getConnectorName();
        if (this$connectorName == null ? other$connectorName != null : !this$connectorName.equals(other$connectorName)) {
            return false;
        }
        String this$appId = this.getAppId();
        String other$appId = other.getAppId();
        if (this$appId == null ? other$appId != null : !this$appId.equals(other$appId)) {
            return false;
        }
        String this$appSecret = this.getAppSecret();
        String other$appSecret = other.getAppSecret();
        if (this$appSecret == null ? other$appSecret != null : !this$appSecret.equals(other$appSecret)) {
            return false;
        }
        String this$receiveIdType = this.getReceiveIdType();
        String other$receiveIdType = other.getReceiveIdType();
        if (this$receiveIdType == null ? other$receiveIdType != null : !this$receiveIdType.equals(other$receiveIdType)) {
            return false;
        }
        String this$receiveId = this.getReceiveId();
        String other$receiveId = other.getReceiveId();
        if (this$receiveId == null ? other$receiveId != null : !this$receiveId.equals(other$receiveId)) {
            return false;
        }
        String this$sinkAsync = this.getSinkAsync();
        String other$sinkAsync = other.getSinkAsync();
        if (this$sinkAsync == null ? other$sinkAsync != null : !this$sinkAsync.equals(other$sinkAsync)) {
            return false;
        }
        String this$maxRetryTimes = this.getMaxRetryTimes();
        String other$maxRetryTimes = other.getMaxRetryTimes();
        if (this$maxRetryTimes == null ? other$maxRetryTimes != null : !this$maxRetryTimes.equals(other$maxRetryTimes)) {
            return false;
        }
        String this$retryDelayInMills = this.getRetryDelayInMills();
        String other$retryDelayInMills = other.getRetryDelayInMills();
        return !(this$retryDelayInMills == null ? other$retryDelayInMills != null : !this$retryDelayInMills.equals(other$retryDelayInMills));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SinkConnectorConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $connectorName = this.getConnectorName();
        result = result * 59 + ($connectorName == null ? 43 : $connectorName.hashCode());
        String $appId = this.getAppId();
        result = result * 59 + ($appId == null ? 43 : $appId.hashCode());
        String $appSecret = this.getAppSecret();
        result = result * 59 + ($appSecret == null ? 43 : $appSecret.hashCode());
        String $receiveIdType = this.getReceiveIdType();
        result = result * 59 + ($receiveIdType == null ? 43 : $receiveIdType.hashCode());
        String $receiveId = this.getReceiveId();
        result = result * 59 + ($receiveId == null ? 43 : $receiveId.hashCode());
        String $sinkAsync = this.getSinkAsync();
        result = result * 59 + ($sinkAsync == null ? 43 : $sinkAsync.hashCode());
        String $maxRetryTimes = this.getMaxRetryTimes();
        result = result * 59 + ($maxRetryTimes == null ? 43 : $maxRetryTimes.hashCode());
        String $retryDelayInMills = this.getRetryDelayInMills();
        result = result * 59 + ($retryDelayInMills == null ? 43 : $retryDelayInMills.hashCode());
        return result;
    }

    public String toString() {
        return "SinkConnectorConfig(connectorName=" + this.getConnectorName() + ", appId=" + this.getAppId() + ", appSecret=" + this.getAppSecret() + ", receiveIdType=" + this.getReceiveIdType() + ", receiveId=" + this.getReceiveId() + ", sinkAsync=" + this.getSinkAsync() + ", maxRetryTimes=" + this.getMaxRetryTimes() + ", retryDelayInMills=" + this.getRetryDelayInMills() + ")";
    }
}

