/*
 * Decompiled with CFR 0.152.
 */
package com.github.shyiko.mysql.binlog.event.deserialization;

import com.github.shyiko.mysql.binlog.event.GtidEventData;
import com.github.shyiko.mysql.binlog.event.MySqlGtid;
import com.github.shyiko.mysql.binlog.event.deserialization.EventDataDeserializer;
import com.github.shyiko.mysql.binlog.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.UUID;

public class GtidEventDataDeserializer
implements EventDataDeserializer<GtidEventData> {
    @Override
    public GtidEventData deserialize(ByteArrayInputStream inputStream) throws IOException {
        byte flags = (byte)inputStream.readInteger(1);
        long sourceIdMostSignificantBits = GtidEventDataDeserializer.readLongBigEndian(inputStream);
        long sourceIdLeastSignificantBits = GtidEventDataDeserializer.readLongBigEndian(inputStream);
        long transactionId = inputStream.readLong(8);
        return new GtidEventData(new MySqlGtid(new UUID(sourceIdMostSignificantBits, sourceIdLeastSignificantBits), transactionId), flags);
    }

    private static long readLongBigEndian(ByteArrayInputStream input) throws IOException {
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result = result << 8 | (long)(input.read() & 0xFF);
        }
        return result;
    }
}

