/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.openconnect.util;

import io.cloudevents.CloudEvent;
import io.cloudevents.core.builder.CloudEventBuilder;
import io.cloudevents.core.impl.BaseCloudEventBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.time.OffsetDateTime;
import java.util.Objects;
import java.util.Optional;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.KeyValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudEventUtil {
    private static final Logger log = LoggerFactory.getLogger(CloudEventUtil.class);

    public static CloudEvent convertRecordToEvent(ConnectRecord connectRecord) {
        BaseCloudEventBuilder cloudEventBuilder = CloudEventBuilder.v1().withData((byte[])connectRecord.getData());
        Optional.ofNullable(connectRecord.getExtensions()).ifPresent(arg_0 -> CloudEventUtil.lambda$convertRecordToEvent$1((CloudEventBuilder)cloudEventBuilder, connectRecord, arg_0));
        return cloudEventBuilder.build();
    }

    public static ConnectRecord convertEventToRecord(CloudEvent event) {
        byte[] body = Objects.requireNonNull(event.getData()).toBytes();
        log.info("handle receive events {}", (Object)new String(event.getData().toBytes()));
        ConnectRecord connectRecord = new ConnectRecord(null, null, Long.valueOf(System.currentTimeMillis()), (Object)body);
        for (String extensionName : event.getExtensionNames()) {
            connectRecord.addExtension(extensionName, (Object)Objects.requireNonNull(event.getExtension(extensionName)).toString());
        }
        connectRecord.addExtension("id", (Object)event.getId());
        connectRecord.addExtension("topic", (Object)event.getSubject());
        connectRecord.addExtension("source", (Object)event.getSource().toString());
        connectRecord.addExtension("type", (Object)event.getType());
        connectRecord.addExtension("datacontenttype", (Object)event.getDataContentType());
        return connectRecord;
    }

    public static boolean validateExtensionType(Object obj) {
        return obj instanceof String || obj instanceof Number || obj instanceof Boolean || obj instanceof URI || obj instanceof OffsetDateTime || obj instanceof byte[];
    }

    private static /* synthetic */ void lambda$convertRecordToEvent$1(CloudEventBuilder cloudEventBuilder, ConnectRecord connectRecord, KeyValue extensions) {
        extensions.keySet().forEach(key -> {
            switch (key) {
                case "id": {
                    cloudEventBuilder.withId(connectRecord.getExtension(key));
                    break;
                }
                case "topic": {
                    cloudEventBuilder.withSubject(connectRecord.getExtension(key));
                    break;
                }
                case "source": {
                    try {
                        cloudEventBuilder.withSource(new URI(connectRecord.getExtension(key)));
                        break;
                    }
                    catch (URISyntaxException e) {
                        throw new RuntimeException(e);
                    }
                }
                case "type": {
                    cloudEventBuilder.withType(connectRecord.getExtension(key));
                    break;
                }
                default: {
                    if (!CloudEventUtil.validateExtensionType(connectRecord.getExtensionObj(key))) break;
                    cloudEventBuilder.withExtension(key, connectRecord.getExtension(key));
                }
            }
        });
    }
}

