/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.connector.openfunction.sink.connector;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.eventmesh.connector.openfunction.sink.config.OpenFunctionSinkConfig;
import org.apache.eventmesh.openconnect.api.config.Config;
import org.apache.eventmesh.openconnect.api.connector.ConnectorContext;
import org.apache.eventmesh.openconnect.api.connector.SinkConnectorContext;
import org.apache.eventmesh.openconnect.api.sink.Sink;
import org.apache.eventmesh.openconnect.offsetmgmt.api.data.ConnectRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenFunctionSinkConnector
implements Sink {
    private static final Logger log = LoggerFactory.getLogger(OpenFunctionSinkConnector.class);
    private OpenFunctionSinkConfig sinkConfig;
    private BlockingQueue<ConnectRecord> queue;
    private volatile boolean isRunning = false;

    public Class<? extends Config> configClass() {
        return OpenFunctionSinkConfig.class;
    }

    public void init(Config config) throws Exception {
        this.sinkConfig = (OpenFunctionSinkConfig)config;
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    public void init(ConnectorContext connectorContext) throws Exception {
        SinkConnectorContext sinkConnectorContext = (SinkConnectorContext)connectorContext;
        this.sinkConfig = (OpenFunctionSinkConfig)sinkConnectorContext.getSinkConfig();
        this.queue = new LinkedBlockingQueue<ConnectRecord>(1000);
    }

    public void start() throws Exception {
        this.isRunning = true;
    }

    public void commit(ConnectRecord record) {
    }

    public String name() {
        return this.sinkConfig.getSinkConnectorConfig().getConnectorName();
    }

    public void stop() {
    }

    public void put(List<ConnectRecord> sinkRecords) {
        for (ConnectRecord connectRecord : sinkRecords) {
            try {
                this.queue.put(connectRecord);
            }
            catch (InterruptedException e) {
                Thread currentThread = Thread.currentThread();
                log.warn("[OpenFunctionSinkConnector] Interrupting thread {} due to exception {}", (Object)currentThread.getName(), (Object)e.getMessage());
                currentThread.interrupt();
            }
        }
    }

    public BlockingQueue<ConnectRecord> queue() {
        return this.queue;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

