/*
 * Decompiled with CFR 0.152.
 */
package com.navercorp.pinpoint.bootstrap.plugin.reactor;

import com.navercorp.pinpoint.bootstrap.context.AsyncContext;
import com.navercorp.pinpoint.bootstrap.interceptor.AroundInterceptor;
import com.navercorp.pinpoint.bootstrap.logging.PLogger;
import com.navercorp.pinpoint.bootstrap.logging.PLoggerFactory;
import com.navercorp.pinpoint.bootstrap.plugin.reactor.ReactorContextAccessorUtils;

public class CoreSubscriberConstructorInterceptor
implements AroundInterceptor {
    private final PLogger logger = PLoggerFactory.getLogger(this.getClass());
    private final boolean isDebug = this.logger.isDebugEnabled();

    @Override
    public void before(Object target, Object[] args) {
    }

    @Override
    public void after(Object target, Object[] args, Object result, Throwable throwable) {
        block5: {
            if (this.isDebug) {
                this.logger.afterInterceptor(target, args, result, throwable);
            }
            if (throwable != null) {
                return;
            }
            try {
                AsyncContext actualAsyncContext = ReactorContextAccessorUtils.findAsyncContext(args, 0);
                if (actualAsyncContext != null) {
                    this.setReactorContextToTarget(actualAsyncContext, target);
                }
            }
            catch (Throwable th) {
                if (!this.logger.isWarnEnabled()) break block5;
                this.logger.warn("AFTER. Caused:{}", (Object)th.getMessage(), (Object)th);
            }
        }
    }

    protected void setReactorContextToTarget(AsyncContext asyncContext, Object target) {
        ReactorContextAccessorUtils.setAsyncContext(asyncContext, target);
    }
}

