/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.client.grpc.producer;

import io.cloudevents.CloudEvent;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.eventmesh.client.grpc.config.EventMeshGrpcClientConfig;
import org.apache.eventmesh.client.grpc.producer.CloudEventProducer;
import org.apache.eventmesh.client.grpc.producer.EventMeshMessageProducer;
import org.apache.eventmesh.common.EventMeshMessage;
import org.apache.eventmesh.common.protocol.grpc.cloudevents.PublisherServiceGrpc;
import org.apache.eventmesh.common.protocol.grpc.common.Response;
import org.apache.eventmesh.common.utils.LogUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventMeshGrpcProducer
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(EventMeshGrpcProducer.class);
    private static final String PROTOCOL_TYPE = "eventmeshmessage";
    private final transient EventMeshGrpcClientConfig clientConfig;
    private final transient ManagedChannel channel;
    private PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient;
    private CloudEventProducer cloudEventProducer;
    private EventMeshMessageProducer eventMeshMessageProducer;

    public EventMeshGrpcProducer(EventMeshGrpcClientConfig clientConfig) {
        this.clientConfig = clientConfig;
        this.channel = ManagedChannelBuilder.forAddress((String)clientConfig.getServerAddr(), (int)clientConfig.getServerPort()).usePlaintext().build();
        this.publisherClient = PublisherServiceGrpc.newBlockingStub((Channel)this.channel);
        this.cloudEventProducer = new CloudEventProducer(clientConfig, this.publisherClient);
        this.eventMeshMessageProducer = new EventMeshMessageProducer(clientConfig, this.publisherClient);
    }

    public <T> Response publish(T message) {
        LogUtils.info((Logger)log, (String)"Publish message ", (Object)message.toString());
        if (message instanceof CloudEvent) {
            return this.cloudEventProducer.publish((CloudEvent)message);
        }
        if (message instanceof EventMeshMessage) {
            return this.eventMeshMessageProducer.publish((EventMeshMessage)message);
        }
        throw new IllegalArgumentException("Not support message " + message.getClass().getName());
    }

    public <T> Response publish(List<T> messageList) {
        LogUtils.info((Logger)log, (String)"BatchPublish message :{}", messageList);
        if (CollectionUtils.isEmpty(messageList)) {
            return null;
        }
        T target = messageList.get(0);
        if (target instanceof CloudEvent) {
            return this.cloudEventProducer.publish(messageList);
        }
        if (target instanceof EventMeshMessage) {
            return this.eventMeshMessageProducer.publish((List<EventMeshMessage>)messageList);
        }
        throw new IllegalArgumentException("Not support message " + target.getClass().getName());
    }

    public <T> T requestReply(T message, long timeout) {
        if (message instanceof CloudEvent) {
            CloudEvent cloudEvent = this.cloudEventProducer.requestReply((CloudEvent)message, timeout);
            return (T)cloudEvent;
        }
        if (message instanceof EventMeshMessage) {
            return (T)this.eventMeshMessageProducer.requestReply((EventMeshMessage)message, timeout);
        }
        throw new IllegalArgumentException("Not support message " + message.getClass().getName());
    }

    @Override
    public void close() {
        this.channel.shutdown();
    }

    public EventMeshGrpcClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public ManagedChannel getChannel() {
        return this.channel;
    }

    public PublisherServiceGrpc.PublisherServiceBlockingStub getPublisherClient() {
        return this.publisherClient;
    }

    public CloudEventProducer getCloudEventProducer() {
        return this.cloudEventProducer;
    }

    public EventMeshMessageProducer getEventMeshMessageProducer() {
        return this.eventMeshMessageProducer;
    }

    public void setPublisherClient(PublisherServiceGrpc.PublisherServiceBlockingStub publisherClient) {
        this.publisherClient = publisherClient;
    }

    public void setCloudEventProducer(CloudEventProducer cloudEventProducer) {
        this.cloudEventProducer = cloudEventProducer;
    }

    public void setEventMeshMessageProducer(EventMeshMessageProducer eventMeshMessageProducer) {
        this.eventMeshMessageProducer = eventMeshMessageProducer;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventMeshGrpcProducer)) {
            return false;
        }
        EventMeshGrpcProducer other = (EventMeshGrpcProducer)o;
        if (!other.canEqual(this)) {
            return false;
        }
        PublisherServiceGrpc.PublisherServiceBlockingStub this$publisherClient = this.getPublisherClient();
        PublisherServiceGrpc.PublisherServiceBlockingStub other$publisherClient = other.getPublisherClient();
        if (this$publisherClient == null ? other$publisherClient != null : !this$publisherClient.equals(other$publisherClient)) {
            return false;
        }
        CloudEventProducer this$cloudEventProducer = this.getCloudEventProducer();
        CloudEventProducer other$cloudEventProducer = other.getCloudEventProducer();
        if (this$cloudEventProducer == null ? other$cloudEventProducer != null : !this$cloudEventProducer.equals(other$cloudEventProducer)) {
            return false;
        }
        EventMeshMessageProducer this$eventMeshMessageProducer = this.getEventMeshMessageProducer();
        EventMeshMessageProducer other$eventMeshMessageProducer = other.getEventMeshMessageProducer();
        return !(this$eventMeshMessageProducer == null ? other$eventMeshMessageProducer != null : !this$eventMeshMessageProducer.equals(other$eventMeshMessageProducer));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventMeshGrpcProducer;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        PublisherServiceGrpc.PublisherServiceBlockingStub $publisherClient = this.getPublisherClient();
        result = result * 59 + ($publisherClient == null ? 43 : $publisherClient.hashCode());
        CloudEventProducer $cloudEventProducer = this.getCloudEventProducer();
        result = result * 59 + ($cloudEventProducer == null ? 43 : $cloudEventProducer.hashCode());
        EventMeshMessageProducer $eventMeshMessageProducer = this.getEventMeshMessageProducer();
        result = result * 59 + ($eventMeshMessageProducer == null ? 43 : $eventMeshMessageProducer.hashCode());
        return result;
    }

    public String toString() {
        return "EventMeshGrpcProducer(clientConfig=" + this.getClientConfig() + ", channel=" + this.getChannel() + ", publisherClient=" + this.getPublisherClient() + ", cloudEventProducer=" + this.getCloudEventProducer() + ", eventMeshMessageProducer=" + this.getEventMeshMessageProducer() + ")";
    }
}

