/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.controller;

import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Objects;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.ConfigurationHandler;
import org.apache.eventmesh.runtime.admin.handler.DeleteWebHookConfigHandler;
import org.apache.eventmesh.runtime.admin.handler.EventHandler;
import org.apache.eventmesh.runtime.admin.handler.GrpcClientHandler;
import org.apache.eventmesh.runtime.admin.handler.HTTPClientHandler;
import org.apache.eventmesh.runtime.admin.handler.InsertWebHookConfigHandler;
import org.apache.eventmesh.runtime.admin.handler.MetaHandler;
import org.apache.eventmesh.runtime.admin.handler.MetricsHandler;
import org.apache.eventmesh.runtime.admin.handler.QueryRecommendEventMeshHandler;
import org.apache.eventmesh.runtime.admin.handler.QueryWebHookConfigByIdHandler;
import org.apache.eventmesh.runtime.admin.handler.QueryWebHookConfigByManufacturerHandler;
import org.apache.eventmesh.runtime.admin.handler.RedirectClientByIpPortHandler;
import org.apache.eventmesh.runtime.admin.handler.RedirectClientByPathHandler;
import org.apache.eventmesh.runtime.admin.handler.RedirectClientBySubSystemHandler;
import org.apache.eventmesh.runtime.admin.handler.RejectAllClientHandler;
import org.apache.eventmesh.runtime.admin.handler.RejectClientByIpPortHandler;
import org.apache.eventmesh.runtime.admin.handler.RejectClientBySubSystemHandler;
import org.apache.eventmesh.runtime.admin.handler.ShowClientBySystemHandler;
import org.apache.eventmesh.runtime.admin.handler.ShowClientHandler;
import org.apache.eventmesh.runtime.admin.handler.ShowListenClientByTopicHandler;
import org.apache.eventmesh.runtime.admin.handler.TCPClientHandler;
import org.apache.eventmesh.runtime.admin.handler.TopicHandler;
import org.apache.eventmesh.runtime.admin.handler.UpdateWebHookConfigHandler;
import org.apache.eventmesh.runtime.boot.EventMeshGrpcServer;
import org.apache.eventmesh.runtime.boot.EventMeshHTTPServer;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.meta.MetaStorage;
import org.apache.eventmesh.webhook.admin.AdminWebHookConfigOperationManager;
import org.apache.eventmesh.webhook.api.WebHookConfigOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientManageController {
    private static final Logger log = LoggerFactory.getLogger(ClientManageController.class);
    private final EventMeshTCPServer eventMeshTCPServer;
    private final transient EventMeshHTTPServer eventMeshHTTPServer;
    private final transient EventMeshGrpcServer eventMeshGrpcServer;
    private final transient MetaStorage eventMeshMetaStorage;
    private AdminWebHookConfigOperationManager adminWebHookConfigOperationManage;

    public ClientManageController(EventMeshTCPServer eventMeshTCPServer, EventMeshHTTPServer eventMeshHTTPServer, EventMeshGrpcServer eventMeshGrpcServer, MetaStorage eventMeshMetaStorage) {
        this.eventMeshTCPServer = eventMeshTCPServer;
        this.eventMeshHTTPServer = eventMeshHTTPServer;
        this.eventMeshGrpcServer = eventMeshGrpcServer;
        this.eventMeshMetaStorage = eventMeshMetaStorage;
    }

    public void start() throws IOException {
        int port = this.eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshServerAdminPort();
        HttpServer server = HttpServer.create(new InetSocketAddress(port), 0);
        HttpHandlerManager httpHandlerManager = new HttpHandlerManager();
        this.initClientHandler(this.eventMeshTCPServer, this.eventMeshHTTPServer, this.eventMeshGrpcServer, this.eventMeshMetaStorage, httpHandlerManager);
        httpHandlerManager.registerHttpHandler(server);
        server.start();
        log.info("ClientManageController start success, port:{}", (Object)port);
    }

    private void initClientHandler(EventMeshTCPServer eventMeshTCPServer, EventMeshHTTPServer eventMeshHTTPServer, EventMeshGrpcServer eventMeshGrpcServer, MetaStorage eventMeshMetaStorage, HttpHandlerManager httpHandlerManager) {
        new ShowClientHandler(eventMeshTCPServer, httpHandlerManager);
        new ShowClientBySystemHandler(eventMeshTCPServer, httpHandlerManager);
        new RejectAllClientHandler(eventMeshTCPServer, httpHandlerManager);
        new RejectClientByIpPortHandler(eventMeshTCPServer, httpHandlerManager);
        new RejectClientBySubSystemHandler(eventMeshTCPServer, httpHandlerManager);
        new RedirectClientBySubSystemHandler(eventMeshTCPServer, httpHandlerManager);
        new RedirectClientByPathHandler(eventMeshTCPServer, httpHandlerManager);
        new RedirectClientByIpPortHandler(eventMeshTCPServer, httpHandlerManager);
        new ShowListenClientByTopicHandler(eventMeshTCPServer, httpHandlerManager);
        new QueryRecommendEventMeshHandler(eventMeshTCPServer, httpHandlerManager);
        new TCPClientHandler(eventMeshTCPServer, httpHandlerManager);
        new HTTPClientHandler(eventMeshHTTPServer, httpHandlerManager);
        new GrpcClientHandler(eventMeshGrpcServer, httpHandlerManager);
        new ConfigurationHandler(eventMeshTCPServer.getEventMeshTCPConfiguration(), eventMeshHTTPServer.getEventMeshHttpConfiguration(), eventMeshGrpcServer.getEventMeshGrpcConfiguration(), httpHandlerManager);
        new MetricsHandler(eventMeshHTTPServer, eventMeshTCPServer, httpHandlerManager);
        new TopicHandler(eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshStoragePluginType(), httpHandlerManager);
        new EventHandler(eventMeshTCPServer.getEventMeshTCPConfiguration().getEventMeshStoragePluginType(), httpHandlerManager);
        new MetaHandler(eventMeshMetaStorage, httpHandlerManager);
        if (Objects.nonNull(this.adminWebHookConfigOperationManage.getWebHookConfigOperation())) {
            WebHookConfigOperation webHookConfigOperation = this.adminWebHookConfigOperationManage.getWebHookConfigOperation();
            new InsertWebHookConfigHandler(webHookConfigOperation, httpHandlerManager);
            new UpdateWebHookConfigHandler(webHookConfigOperation, httpHandlerManager);
            new DeleteWebHookConfigHandler(webHookConfigOperation, httpHandlerManager);
            new QueryWebHookConfigByIdHandler(webHookConfigOperation, httpHandlerManager);
            new QueryWebHookConfigByManufacturerHandler(webHookConfigOperation, httpHandlerManager);
        }
    }

    public void setAdminWebHookConfigOperationManage(AdminWebHookConfigOperationManager adminWebHookConfigOperationManage) {
        this.adminWebHookConfigOperationManage = adminWebHookConfigOperationManage;
    }
}

