/*
 * Decompiled with CFR 0.152.
 */
package org.apache.eventmesh.runtime.admin.handler;

import com.sun.net.httpserver.HttpExchange;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.eventmesh.common.Constants;
import org.apache.eventmesh.common.utils.NetUtils;
import org.apache.eventmesh.runtime.admin.controller.HttpHandlerManager;
import org.apache.eventmesh.runtime.admin.handler.AbstractHttpHandler;
import org.apache.eventmesh.runtime.boot.EventMeshTCPServer;
import org.apache.eventmesh.runtime.common.EventHttpHandler;
import org.apache.eventmesh.runtime.core.protocol.tcp.client.recommend.EventMeshRecommendImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EventHttpHandler(path="/eventMesh/recommend")
public class QueryRecommendEventMeshHandler
extends AbstractHttpHandler {
    private static final Logger log = LoggerFactory.getLogger(QueryRecommendEventMeshHandler.class);
    private final EventMeshTCPServer eventMeshTCPServer;

    public QueryRecommendEventMeshHandler(EventMeshTCPServer eventMeshTCPServer, HttpHandlerManager httpHandlerManager) {
        super(httpHandlerManager);
        this.eventMeshTCPServer = eventMeshTCPServer;
    }

    @Override
    public void handle(HttpExchange httpExchange) throws IOException {
        String result = "";
        try (OutputStream out = httpExchange.getResponseBody();){
            if (!this.eventMeshTCPServer.getEventMeshTCPConfiguration().isEventMeshServerMetaStorageEnable()) {
                throw new Exception("registry enable config is false, not support");
            }
            String queryString = httpExchange.getRequestURI().getQuery();
            Map queryStringInfo = NetUtils.formData2Dic((String)queryString);
            String group = (String)queryStringInfo.get("group");
            String purpose = (String)queryStringInfo.get("purpose");
            if (StringUtils.isBlank((CharSequence)group) || StringUtils.isBlank((CharSequence)purpose)) {
                NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
                result = "params illegal!";
                out.write(result.getBytes(Constants.DEFAULT_CHARSET));
                return;
            }
            EventMeshRecommendImpl eventMeshRecommendStrategy = new EventMeshRecommendImpl(this.eventMeshTCPServer);
            String recommendEventMeshResult = eventMeshRecommendStrategy.calculateRecommendEventMesh(group, purpose);
            result = recommendEventMeshResult == null ? "null" : recommendEventMeshResult;
            log.info("recommend eventmesh:{},group:{},purpose:{}", new Object[]{result, group, purpose});
            NetUtils.sendSuccessResponseHeaders((HttpExchange)httpExchange);
            out.write(result.getBytes(Constants.DEFAULT_CHARSET));
        }
        catch (Exception e) {
            log.error("QueryRecommendEventMeshHandler fail...", (Throwable)e);
        }
    }
}

